/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// Copyright (c) 1996-2013 Live Networks, Inc.  All rights reserved.
// Usage Environment
// Implementation

#include "UsageEnvironment.hh"

void UsageEnvironment::reclaim() {
  // We delete ourselves only if we have no remainining state:
  if (liveMediaPriv == NULL && groupsockPriv == NULL) delete this;
}

UsageEnvironment::UsageEnvironment(TaskScheduler& scheduler)
  : liveMediaPriv(NULL), groupsockPriv(NULL), fScheduler(scheduler) {
}

UsageEnvironment::~UsageEnvironment() {
}

// By default, we handle 'should not occur'-type library errors by calling abort().  Subclasses can redefine this, if desired.
// (If your runtime library doesn't define the "abort()" function, then define your own (e.g., that does nothing).)
void UsageEnvironment::internalError() {
  ndk_info("repare to die\n");
  NDK_ASSERT(0);
}

TaskScheduler::TaskScheduler() {
  fSignal = 0;
  if (sp5kOsMutexCreate(&fScheMutex, (CHAR*)"livesche", 0) != SUCCESS)
  	NDK_ASSERT(0);
}

TaskScheduler::~TaskScheduler() {
  sp5kOsMutexDelete(&fScheMutex);
}

void TaskScheduler::rescheduleDelayedTask(TaskToken& task,
					  int64_t microseconds, TaskFunc* proc,
					  void* clientData) {
  unscheduleDelayedTask(task);
  task = scheduleDelayedTask(microseconds, proc, clientData);
}

// By default, we handle 'should not occur'-type library errors by calling abort().  Subclasses can redefine this, if desired.
void TaskScheduler::internalError() {
  NDK_ASSERT(0);
}

void TaskScheduler::lockScheduler()
{
  sp5kOsMutexGet(&fScheMutex, TX_WAIT_FOREVER);
}

void TaskScheduler::unlockScheduler()
{
  sp5kOsMutexPut(&fScheMutex);
}

#define ALARM_POOL_SIZE  32
void *AlarmHandler::fAlarmPool = NULL;
NDKStExitFunc AlarmHandler::fAlarmPoolOnExit;

void AlarmHandler::alarmPoolOnExit(NDKStExitFunc *exit_func)
{
	void *pool;

	ndk_st_sys_protect(-1);
	pool = fAlarmPool;
	fAlarmPool = 0;
	ndk_st_sys_unprotect();

	ndk_blkpool_destroy(pool);
}

void *AlarmHandler::operator new (size_t size) throw()
{
	NDK_ASSERT(size == sizeof(AlarmHandler));

	if (!fAlarmPool) {
		fAlarmPool = ndk_blkpool_create("AlarmHandler", sizeof(AlarmHandler), ALARM_POOL_SIZE);

		if (fAlarmPool) {
			fAlarmPoolOnExit.on_exit = alarmPoolOnExit;
			fAlarmPoolOnExit.user_data = NULL;
			ndk_st_register_exitfunc(&fAlarmPoolOnExit);
		}
		else
			return NULL;
	}

	return ndk_blkpool_alloc_block(fAlarmPool);
}

void AlarmHandler::operator delete (void* ptr)
{
	if (ptr) {
		NDK_ASSERT(fAlarmPool);
		ndk_blkpool_free_block(fAlarmPool, ptr);
	}
}

