/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2013 Live Networks, Inc.  All rights reserved.
// Base64 encoding and decoding
// implementation

#include "Base64.hh"
#include <strDup.hh>
#include <string.h>
#include <livePort/livest_internal.h>

unsigned char* base64Decode(char const* in, unsigned& resultSize) {
  if (in == NULL) return NULL; // sanity check
  return base64Decode(in, strlen(in), resultSize);
}

unsigned char* base64Decode(char const* in, unsigned inSize, unsigned& resultSize) {
  unsigned char* out = new unsigned char [inSize];
  int ret = ndk_base64_decode(out, in, inSize, 'A');
  NDK_ASSERT(ret > 0);
  resultSize = (unsigned)ret;
  return out;
}

char* base64Encode(char const* origSigned, unsigned origLength) {
  unsigned const numOrig24BitValues = origLength/3;
  Boolean havePadding = origLength > numOrig24BitValues*3;

  unsigned const numResultBytes = 4*(numOrig24BitValues + havePadding);
  char* result = new char[numResultBytes+1]; // allow for trailing '\0'
  if (!result)
    return NULL;

  unsigned char *src_p = (unsigned char *)origSigned;
  ndk_base64_encode(result, numResultBytes, &src_p, origLength);

  result[numResultBytes] = '\0';
  return result;
}
