/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2013 Live Networks, Inc.  All rights reserved.
// RTP sink for JPEG video (RFC 2435)
// C++ header

#ifndef _JPEG_VIDEO_RTP_SINK_HH
#define _JPEG_VIDEO_RTP_SINK_HH

#ifndef _VIDEO_RTP_SINK_HH
#include "VideoRTPSink.hh"
#endif

class JPEGVideoRTPSink: public VideoRTPSink
{
public:
	enum { RTP_PAYLOAD_TYPE = 26 };

	static JPEGVideoRTPSink *createNew(UsageEnvironment &env, Groupsock *RTPgs);
	virtual const char *getClassName() const { return "JpgVidRtpSnk"; }

protected:
	JPEGVideoRTPSink(UsageEnvironment &env, Groupsock *RTPgs);
	// called only by createNew()
	virtual ~JPEGVideoRTPSink();
	virtual Boolean continuePlaying();
	char const *JPEGVideoRTPSink::auxSDPLine();

private: // redefined virtual functions:
	char *fFmtpSDPLine;
	//UINT8   fOutBuf[1448];
	//UINT8*  fOutBufEnd;
	//UINT8*  fWrPtr;
	int fLastNetLoad;

	virtual Boolean sourceIsCompatibleWithUs(MediaSource &source);

	virtual
	Boolean frameCanAppearAfterPacketStart(unsigned char const *frameStart,
			unsigned numBytesInFrame) const;

	//void sendFrame();
	static void sendNextPacket(void* firstArg);
	/*static void sendFrameAgain(void *firstArg);

	static void afterGettingFrame(void* clientData,
		unsigned numBytesRead, unsigned numTruncatedBytes,
		struct timeval presentationTime,
		unsigned durationInMicroseconds);

	void afterGettingFrame1(unsigned frameSize, unsigned numTruncatedBytes,
		     struct timeval presentationTime,
		     unsigned durationInMicroseconds);

	static void ourHandleClosure(void* clientData);*/
};

#endif
