/**************************************************************************
 *
 *       Copyright (c) 2013 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#include "CaptureFramedSource.hh"

CaptureFramedSource::CaptureFramedSource(
	UsageEnvironment& env,
	CaptureServerMediaSubsession &capSMSS,
	unsigned sessId)
: FramedSource(env)
, NSFrmFifoClient(capSMSS.getFIFO(), sessId)
, fCapSMSS(capSMSS)
, fLastIdx(0)
, fOrigBitrate(0)
, fFrmIdxResetCnt(0)
, fFlgFirstRead(1)
, fFlgSyncKeyFrame(1)
, fFlgAvSyncEnabled(0)
, fFlgMarkerPerFrame(0)
{
}

CaptureFramedSource::~CaptureFramedSource()
{
}

Boolean CaptureFramedSource::getFrameInfo(Boolean &newFrame, SINT64 &pts)
{
	if (!fFrmReadInf.frm)
		return False;

	newFrame = fFrmReadInf.readPos == 0;
	pts = timeval2mtime(&fFrmReadInf.frm->pts);
	return True;
}

void CaptureFramedSource::readFrameData(
	unsigned char* buf,
	unsigned int bufSize,
	RTPPayloadInf &rpinf)
{
	RTPPayloadVec rpvec;

	rtpPayloadIterate(bufSize, rpvec, rpinf);

	NDK_ASSERT(rpvec.length() == rpinf.size);
	NDK_ASSERT(rpinf.size <= bufSize);
	rpvec.copyToBuffer(buf);

	if (rpinf.lastPacket)
		rtpPayloadIterateEnd();
}

Boolean CaptureFramedSource::prepareFrame()
{
	NSFrmIdx curIdx;
	NSFrame *frmNew = NULL;

lFetchAgain:
	if (!fetchNextFrame(frmNew, curIdx))
		return False;

	if (fFlgSyncKeyFrame) {
		if (!frmNew->isKeyFrame()) {
			NSFrame::unref(frmNew);
			goto lFetchAgain;
		}
		fFlgSyncKeyFrame = 0;
	}

	fFrmReadInf.attach(frmNew, curIdx);
	return True;
}

void CaptureFramedSource::clearCurrentFrame()
{
	fFrmReadInf.detach();
}

void CaptureFramedSource::doStopGettingFrames()
{
	if (fFrmReadInf.frm) {
		if (fFrmReadInf.end())
			fFrmReadInf.detach();
		else
			fFrmReadInf.readPos = 0;
	}

	FramedSource::doStopGettingFrames();
}

Boolean CaptureFramedSource::rtpPayloadIsFirstPacket() const
{
	NDK_ASSERT(fFrmReadInf.frm);
	return fFrmReadInf.readPos == 0;
}

void CaptureFramedSource::rtpPayloadIterateEnd()
{
	if (fFrmReadInf.frm) {
		UINT32 lifetime = mtime_now_get() - timeval2mtime(&fFrmReadInf.frm->timeCreated);
		lifetime <<= 10;
		if (fStaFrmMaxLifetime < lifetime)
			fStaFrmMaxLifetime = lifetime;
		fStaFrmAvgLifetime = (lifetime + fStaFrmAvgLifetime * 15) >> 4;
	}

	fFrmReadInf.detach();
	++fStaFrmNumSent;
}

void CaptureFramedSource::changeBitrateTo(float ratio)
{
	fFrmFifo.getMediaSrc()->dynamicBitRateSet(ratio);
}

CaptureFramedSource::FrameStatus
CaptureFramedSource::checkFrameReady()
{
	if (fAbortStreaming || ndk_st_aborted())
		return SOURCE_ABORTED;

	if (getFifo().isLiveMode()) {
		if (fFlgFirstRead) {
			fFlgAvSyncEnabled = avSyncInit() ? 1 : 0;

			NSFrmIdx idx;
			ndk_st_sys_protect(-1);
			bool r = fFrmFifo.syncIdxFromHead(idx);

			if (r && getFifo().isVideo() && (fFrmFifo.getHeadFrmIdx() - idx > 3))
				r = false;
			ndk_st_sys_unprotect();

			if (!r)
				return FRAME_NOT_READY;

			setInitialFrmIdx(idx);
			fLastIdx = idx;
			fFlgFirstRead = 0;
			ndk_info("initial frmidx: %c %u %d", getFifo().isAudio() ?'A':'C', (UINT32)idx, fFlgAvSyncEnabled);
		}
	}
	else {
		if (fFrmIdxResetCnt != fFrmFifo.getFrmIdxResetCnt()) {
			// The FIFO is reset because a seeking operation is did on media-source.
			fFrmIdxResetCnt = fFrmFifo.getFrmIdxResetCnt();
			clearCurrentFrame();
			setInitialFrmIdx(0);

			profLogPrintf(0, "FIFO %c is reset", getFifo().isAudio()?'A':'V');
		}
	}

	return updateFrameStatus();
}

CaptureFramedSource::FrameStatus CaptureFramedSource::checkFrame()
{
	if (fAbortStreaming || ndk_st_aborted())
		return SOURCE_ABORTED;

	// Some bytes is readed.
	if (fFrmReadInf.frm && fFrmReadInf.readPos > 0)
		return FRAME_READY;

	while (fFrmReadInf.frm || prepareFrame()) {
		if (getFifo().isLiveMode() && !checkFrameLagTime(fFrmReadInf.frm)) {
			if (fLastIdx == fFrmReadInf.idx) {
				++fLastIdx;
				++fStaFrmNumDrop;
				//ndk_info("drop %d %u", getFifo().isAudio(), (UINT32)fFrmReadInf.idx);
				sendDropFrameEvent(fFrmReadInf.idx);
			}

			fFrmReadInf.detach();
			if (getFifo().isVideo())
				fFlgSyncKeyFrame = 1;
		}
		else {
			if (fFrmReadInf.idx > fLastIdx + 1) {
				NSFrmIdx i;
				int count = 100;

				for (i = fLastIdx + 1; i < fFrmReadInf.idx && --count > 0; ++i) {
					//ndk_info("drop %d %u", getFifo().isAudio(), (UINT32)i);
					sendDropFrameEvent(i);
				}

				fStaFrmNumDrop += fFrmReadInf.idx - (fLastIdx + 1);
			}

			// Update last frame index
			fLastIdx = fFrmReadInf.idx;
			return FRAME_READY;
		}
	}

	if (isEndOfSource())
		return SOURCE_ABORTED;

	return FRAME_NOT_READY;
}

CaptureFramedSource::FrameStatus CaptureFramedSource::updateFrameStatus()
{
	return checkFrame();
}

Boolean CaptureFramedSource::checkFrameLagTime(NSFrame *frm)
{
	long droptime = ndk_st_get_attr(NDK_ST_ATTR_TIME_TO_DROP_FRAME);

	if (droptime > 0) {
		long lagtime = timeval_diff_now_ms(&frm->timeCreated);

		if (frm->isKeyFrame()) {
			return lagtime <= droptime;
		}
		else {
			return lagtime <= droptime*3/5;
		}
	}

	return True;
}

void CaptureFramedSource::sendDropFrameEvent(NSFrmIdx idx)
{
	UINT32 i = (UINT32)idx;
	if (getFifo().isAudio()) i |= 0x10000000;
	ndk_st_send_event(NDK_ST_EVT_FRAME_DROPPED, i);
}

