/**************************************************************************
 *
 *       Copyright (c) 2013 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#ifndef _CAPTURE_FRAMED_SOURCE_HH__
#define _CAPTURE_FRAMED_SOURCE_HH__

#include <FramedSource.hh>
#include <RTPInterface.hh>
#include <livePort/streaming_api.h>
#include <livePort/fifo.h>
#include <livePort/mediasrc.hh>
#include <livePort/CaptureServerMediaSubsession.hh>

///////////////////////////////////////////////////////////////////////////////
class CaptureFramedSource : public FramedSource, public NSFrmFifoClient
{
public:
	void setMarkerPerFrame(Boolean yes) { fFlgMarkerPerFrame = yes ? 1 : 0; }

	enum FrameStatus {
		SOURCE_ABORTED  = -1,
		FRAME_READY     = 0,
		FRAME_NOT_READY = 10  // Not ready. Sleep for a long time.
	};
	FrameStatus checkFrameReady();
	Boolean getFrameInfo(Boolean &newFrame, SINT64 &pts);

	void readFrameData(unsigned char *buf, unsigned int bufSize, RTPPayloadInf &rpinf);

	virtual Boolean prepareFrame();
	virtual void clearCurrentFrame();
	virtual void doStopGettingFrames();

	virtual Boolean rtpPayloadIsFirstPacket() const;
	virtual void rtpPayloadIterate(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf) = 0;
	virtual void rtpPayloadIterateEnd();
	virtual void doGetNextFrame() { NDK_ASSERT(0); }

	void changeBitrateTo(float ratio/*must > 0 and <= 1*/);

protected:
	CaptureFramedSource(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId);
	virtual ~CaptureFramedSource();
	FrameStatus checkFrame();
	virtual FrameStatus updateFrameStatus();

	Boolean checkFrameLagTime(NSFrame *frm);
	void sendDropFrameEvent(NSFrmIdx idx);

protected:
	CaptureServerMediaSubsession &fCapSMSS;
	NSFrmIdx fLastIdx;
	UINT32   fOrigBitrate;
	int      fFrmIdxResetCnt;
	// Flags
	unsigned fFlgFirstRead : 1,
	         fFlgSyncKeyFrame : 1,
	         fFlgAvSyncEnabled : 1,
	         fFlgMarkerPerFrame : 1;
};

#endif

