/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 *  Author: Andy.Li                                                       *
 *                                                                        *
 **************************************************************************/
#ifndef __CAPTURE_RTSP_SERVER_HH__
#define __CAPTURE_RTSP_SERVER_HH__

#include "RTSPServer.hh"
#include "CaptureServerMediaSubsession.hh"
#include <livePort/streaming_api.h>

typedef CaptureServerMediaSubsession* (*SMSSCreateNewFunc)(UsageEnvironment&, NSFrmFifoMgr*, CaptureServerMediaSubsession *master);

class CaptureRTSPServer : public RTSPServer
{
public:
	static CaptureRTSPServer* createNew(UsageEnvironment& env, Port ourPort,
					    UserAuthenticationDatabase* authDatabase,
					    unsigned reclamationTestSeconds = 65);

	void reclaim();

protected:
	CaptureRTSPServer(UsageEnvironment& env, int ourSocket, Port ourPort,
			  UserAuthenticationDatabase* authDatabase, unsigned reclamationTestSeconds);
	// called only by createNew();
	virtual ~CaptureRTSPServer();

protected: // redefined virtual functions
	virtual ServerMediaSession* lookupServerMediaSession(char const* streamName, char const* fullRequestStr);

private:
	ServerMediaSession *createCaptureSMS(char const *streamName, char const* info, char const* description
		, SMSSCreateNewFunc videoCreateNewFunc, NDKFrmFifoType videoFifoType
		, SMSSCreateNewFunc audioCreateNewFunc, NDKFrmFifoType audioFifoType);

#ifdef ICAT_STREAMING_FILE
	ServerMediaSession *createMediaSrcSMS(char const *streamName, char const *fileName, BOOL fAudio, BOOL fVideo);
#endif
};

#endif
