/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2013 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#include "CaptureServerMediaSubsession.hh"
#include <livePort/mediasrc.hh>
#include <livePort/fifo.h>
#include <livePort/streaming_api.h>

static void streamingMonitorTask(void* clientData);
static int       mon_smss_cnt = 0;
static TaskToken mon_task_token = NULL;

CaptureServerMediaSubsession::CaptureServerMediaSubsession(
	UsageEnvironment& env,
	NSFrmFifoMgr* mgr,
	CaptureServerMediaSubsession *master)
: OnDemandServerMediaSubsession(env, False)
, fSourceFlags(0)
, fMasterSMSS(master)
, fFifoMgr(mgr)
{
	NDK_ASSERT(mgr);
	mgr->ref(); // Hold the object

	if (mon_smss_cnt++ == 0) {
		UsageEnvironment *env = &envir();
		mon_task_token = env->taskScheduler().scheduleDelayedTask(100*1000, (TaskFunc*)streamingMonitorTask, env);
	}
}

CaptureServerMediaSubsession::~CaptureServerMediaSubsession()
{
	if (--mon_smss_cnt == 0) {
		envir().taskScheduler().unscheduleDelayedTask(mon_task_token);
	}

	NSFrmFifoMgr::unref(fFifoMgr);
}

void CaptureServerMediaSubsession::seekStreamSource(FramedSource* /*inputSource*/,
	double& seekNPT, double streamDuration, u_int64_t& numBytes)
{
	if (!fMasterSMSS) {
		NSMediaSrcAgent *msrc = getFIFO().getMediaSrc();
		double currNPT;

		if (msrc && msrc->seekSource(seekNPT, currNPT)) {
			//ndk_info("%s %s", f2str(seekNPT, 3), f2str(currNPT, 3));
			seekNPT = currNPT;
		}
	}
}

float CaptureServerMediaSubsession::duration() const
{
	if (fMasterSMSS)
		return fMasterSMSS->duration();

	NSMediaSrcAgent const *msrc = const_cast<CaptureServerMediaSubsession*>(this)->getFIFO().getMediaSrc();
	if (msrc)
		return msrc->getSourceDuration();

	return 0.0f;
}

// Monitor Task Variables
static int            mon_last_netload = 0;
static struct timeval mon_time_netload_high;

static void streamingMonitorTask(void* clientData)
{
	UsageEnvironment *env = (UsageEnvironment *)clientData;
	long time_to_clear_txbufq = ndk_st_get_attr(NDK_ST_ATTR_TIME_CLR_TXBUFQ);

	if (time_to_clear_txbufq <= 0) {
		mon_task_token = env->taskScheduler().scheduleDelayedTask(
				1000*1000, (TaskFunc*)streamingMonitorTask, clientData);
		return;
	}

	int loading = ndk_st_get_netload(env->ifname, NULL);
	int64_t delay_time = 200*1000;

	if (loading != mon_last_netload) {
		mon_last_netload = loading;

		if (loading == NDK_ST_NETLOAD_HIGH) {
			tmrTimeStampGet(&mon_time_netload_high);
		}
	}

	if (loading == NDK_ST_NETLOAD_HIGH) {
		long duration = timeval_diff_now_ms(&mon_time_netload_high);

		if (duration >= time_to_clear_txbufq) {
			ndk_netif_ioctl(NDK_IOCS_WIFI_QUEUE_CLR, (long)env->ifname, 0);
			profLogPrintf(0, "livest: clr WiFi txbufq");
			ndk_st_send_event(NDK_ST_EVT_TXBUFQ_CLEARED, 0);
		}

		delay_time = 100 * 1000;
	}

	mon_task_token = env->taskScheduler().scheduleDelayedTask(
			delay_time, (TaskFunc*)streamingMonitorTask, clientData);
}

