/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#ifndef __ICAT_CAPTURE_SMSS_HH__
#define __ICAT_CAPTURE_SMSS_HH__

#include "OnDemandServerMediaSubsession.hh"
#include <livePort/fifo.h>

class NSFrmFifoMgr;
class NSMediaSrcAgent;
class CaptureServerMediaSubsession : public OnDemandServerMediaSubsession
{
public:
	enum { FLG_AUD_MARKER_PER_FRAME = 1 << 0 };
public:
	CaptureServerMediaSubsession(UsageEnvironment& env
		, NSFrmFifoMgr* mgr
		, CaptureServerMediaSubsession *master);
	virtual ~CaptureServerMediaSubsession();

	virtual void seekStreamSource(FramedSource* inputSource, double& seekNPT
		, double streamDuration, u_int64_t& numBytes);
	virtual float duration() const;
	virtual Boolean isAudio() const { return False; }

	NSFrmFifo &getFIFO() { return *fFifoMgr->getFIFO(isAudio()); }
	void addSourceFlags(unsigned f) { fSourceFlags |= f; }

protected:
	unsigned fSourceFlags;

private:
	// Master SMSS. For audio and video streaming, video is master streaming.
	// NULL: I'm the master
	CaptureServerMediaSubsession *fMasterSMSS;
	NSFrmFifoMgr* fFifoMgr;
};

#endif

