/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#include "H264VideoCaptureRTPSink.hh"
#include "Base64.hh"
#include "H264VideoCaptureSource.hh"

////////// H264VideoCaptureRTPSink implementation //////////

H264VideoCaptureRTPSink
::H264VideoCaptureRTPSink(UsageEnvironment& env
	, Groupsock* RTPgs
	, unsigned char rtpPayloadFormat
	, FramedSource* inputSource)
: VideoCaptureRTPSink(env, RTPgs, rtpPayloadFormat, "H264")
, fFmtpSDPLine(NULL)
, fInputSource(inputSource)
{
	//ndk_info("+");
}

H264VideoCaptureRTPSink::~H264VideoCaptureRTPSink()
{
	//ndk_info("-");
	delete[] fFmtpSDPLine;
}

H264VideoCaptureRTPSink*
H264VideoCaptureRTPSink::createNew(UsageEnvironment& env
	, Groupsock* RTPgs
	, unsigned char rtpPayloadFormat
	, FramedSource* inputSource)
{
	return new H264VideoCaptureRTPSink(env, RTPgs, rtpPayloadFormat, inputSource);
}

Boolean H264VideoCaptureRTPSink::sourceIsCompatibleWithUs(MediaSource& source)
{
	// Our source must be an appropriate framer:
	return source.isH264VideoStreamFramer();
}

Boolean H264VideoCaptureRTPSink
::frameCanAppearAfterPacketStart(unsigned char const* /*frameStart*/,
				 unsigned /*numBytesInFrame*/) const
{
	return False;
}

char const* H264VideoCaptureRTPSink::auxSDPLine()
{
	H264VideoCaptureSource *src = (H264VideoCaptureSource*)fInputSource;
	NDK_ASSERT(src);

	NSFrame *frmSPS = NULL, *frmPPS = NULL;
	// Generate a new "a=fmtp:" line each time, using our SPS and PPS (if we have them),
	// otherwise parameters from our framer source (in case they've changed since the last time that
	// we were called):
	int cnt = 100;

	while (cnt-- > 0) {
		frmSPS = frmPPS = NULL;
		if (src->getSPSAndPPSFrame(frmSPS, frmPPS))
			break;
		else
			ndk_msleep(100);
	}

	if (!frmSPS || !frmPPS) {
		ndk_err_return(NULL);
	}

	u_int8_t* sps = frmSPS->data;
	unsigned spsSize = frmSPS->length;

	u_int8_t* pps = frmPPS->data;
	unsigned ppsSize = frmPPS->length;

	if (sps == NULL || pps == NULL)
		return NULL;

	NDK_ASSERT(sps[0] == 0 && sps[1] == 0 && sps[2] == 0 && sps[3] == 1);
	NDK_ASSERT(pps[0] == 0 && pps[1] == 0 && pps[2] == 0 && pps[3] == 1);

	sps += 4; spsSize -= 4;
	pps += 4; ppsSize -= 4;

	u_int32_t profile_level_id;

	if (spsSize < 4) { // sanity check
		profile_level_id = 0;
	} else {
		profile_level_id = (sps[1] << 16) | (sps[2] << 8) | sps[3]; // profile_idc|constraint_setN_flag|level_idc
	}

	// Set up the "a=fmtp:" SDP line for this stream:
	char* sps_base64 = base64Encode((char*)sps, spsSize);
	char* pps_base64 = base64Encode((char*)pps, ppsSize);
	char const* fmtpFmt =
		"a=fmtp:%d packetization-mode=1"
		";profile-level-id=%06X"
		";sprop-parameter-sets=%s,%s\r\n"
		"a=framerate:%.1f\r\n";
	unsigned fmtpFmtSize = strlen(fmtpFmt)
			       + 3 /* max char len */
			       + 6 /* 3 bytes in hex */
			       + strlen(sps_base64) + strlen(pps_base64);
	char* fmtp = new char[fmtpFmtSize];
	sprintf(fmtp, fmtpFmt,
		rtpPayloadType(),
		profile_level_id,
		sps_base64, pps_base64,
		src->getFrameRate());
	delete[] sps_base64;
	delete[] pps_base64;

	delete[] fFmtpSDPLine;
	fFmtpSDPLine = fmtp;

	NSFrame::unref(frmSPS);
	NSFrame::unref(frmPPS);

	ndk_info("'%s'", fFmtpSDPLine);
	return fFmtpSDPLine;
}

