/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 *  Author: Andy.Li                                                       *
 *                                                                        *
 **************************************************************************/
#ifndef _H264_VIDEO_CAPTURE_RTP_SINK_HH
#define _H264_VIDEO_CAPTURE_RTP_SINK_HH

#include "VideoCaptureRTPSink.hh"

class H264VideoCaptureRTPSink: public VideoCaptureRTPSink
{
public:
	static H264VideoCaptureRTPSink *createNew(UsageEnvironment &env
			, Groupsock *RTPgs
			, unsigned char rtpPayloadFormat
			, FramedSource *inputSource);

	virtual const char* getClassName() const { return "H264VidCapRtpSnk"; }

protected:
	H264VideoCaptureRTPSink(UsageEnvironment &env
		, Groupsock *RTPgs
		, unsigned char rtpPayloadFormat
		, FramedSource *inputSource);
	virtual ~H264VideoCaptureRTPSink();
	virtual char const *auxSDPLine();
	virtual Boolean frameCanAppearAfterPacketStart(unsigned char const *frameStart,
		unsigned numBytesInFrame) const;

private:
	char *fFmtpSDPLine;
	FramedSource *fInputSource;

	virtual Boolean sourceIsCompatibleWithUs(MediaSource &source);
};

#endif

