/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2013 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 *  Author: Andy.Li                                                       *
 *                                                                        *
 **************************************************************************/

#include "H264VideoCaptureSMSS.hh"
#include "H264VideoCaptureRTPSink.hh"
#include "H264VideoCaptureSource.hh"

H264VideoCaptureSMSS*
H264VideoCaptureSMSS::createNew(UsageEnvironment& env, NSFrmFifoMgr* mgr, CaptureServerMediaSubsession *master)
{
	H264VideoCaptureSMSS *smss = new H264VideoCaptureSMSS(env, mgr, master);
	return smss;
}

H264VideoCaptureSMSS::
H264VideoCaptureSMSS(UsageEnvironment& env, NSFrmFifoMgr* mgr, CaptureServerMediaSubsession *master)
: CaptureServerMediaSubsession(env, mgr, master)
{
	ndk_info("+ %p", this);
}

H264VideoCaptureSMSS::~H264VideoCaptureSMSS()
{
	ndk_info("-");
}

FramedSource* H264VideoCaptureSMSS::createNewStreamSource(unsigned clientSessionId, unsigned& estBitrate)
{
	estBitrate = (12*1024*1024)*8/1024; // kbps, estimate

	// Create the video source:
	return H264VideoCaptureSource::createNew(envir(), *this, clientSessionId);
}

RTPSink* H264VideoCaptureSMSS
::createNewRTPSink(Groupsock* rtpGroupsock,
		   unsigned char rtpPayloadTypeIfDynamic,
		   FramedSource* inputSource)
{
	RTPSink *p = H264VideoCaptureRTPSink::createNew(envir(), rtpGroupsock, rtpPayloadTypeIfDynamic, inputSource);
	return p;
}

