/**************************************************************************
 *
 *       Copyright (c) 2013 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#include "H264VideoCaptureSource.hh"
#include <GroupsockHelper.hh> // for "gettimeofday()"
#include <new>

///////////////////////////////////////////////////////////////////////////////
H264VideoCaptureSource
*H264VideoCaptureSource::createNew(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId)
{
	H264VideoCaptureSource *src = new H264VideoCaptureSource(env, capSMSS, sessId);
	return src;
}

H264VideoCaptureSource::H264VideoCaptureSource(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId)
: CaptureFramedSource(env, capSMSS, sessId)
, fFrmSPSIdx(0)
, fFrmPPSIdx(0)
{
	//ndk_info("++ %d %p %s", id, fifo, _fifo->getClassName());
}

H264VideoCaptureSource::~H264VideoCaptureSource()
{
	//ndk_info("-- %d", _objid);
}

bool H264VideoCaptureSource::getSPSAndPPSFrame(NSFrame *&sps, NSFrame *& pps)
{
	NSH264FrmFifo &fifo = (NSH264FrmFifo&)fFrmFifo;

	ndk_st_sys_protect(-1);
	sps = fifo.getSPSFrame();
	pps = fifo.getPPSFrame();
	if (sps && pps) {
		ndk_info("%p %s %p %p", &fifo, fifo.getClassName(), sps, pps);
		sps->ref();
		pps->ref();
	}
	ndk_st_sys_unprotect();

	return (sps != NULL) && (pps != NULL);
}

double H264VideoCaptureSource::getFrameRate() const
{
	return fFrmFifo.getMediaSrc()->getSourceFrameRate();
}

Boolean H264VideoCaptureSource::isH264VideoStreamFramer() const
{
	return True;
}

void H264VideoCaptureSource::rtpPayloadIterate(
	unsigned payloadSizeMax,
	RTPPayloadVec &rpvec,
	RTPPayloadInf &rpinf)
{
	NDK_ASSERT(fFrmReadInf.frm);

	bool bFirst = fFrmReadInf.readPos == 0;

	if (bFirst) {
		fFrmReadInf.advance(4); // skip 00000001
		rpinf.duration = (long)fFrmReadInf.frm->duration;
		//profLogPrintf(0, "H264 PTS: %d.%d", fPresentationTime.tv_sec, fPresentationTime.tv_usec);
	}

	rpinf.specialHeaderSize = 0;
	rpinf.pts = fFrmReadInf.frm->pts;
	rpinf.timeCreated = fFrmReadInf.frm->timeCreated;
	rpinf.index = fFrmReadInf.frm->index;

	u_int32_t nRemainder = fFrmReadInf.remainder();
	bool bFUAFragment = !bFirst || (nRemainder > payloadSizeMax);
	u_int32_t nCopied = nRemainder > payloadSizeMax ? payloadSizeMax : nRemainder;

	if (bFUAFragment) {
		u_int8_t NALType = fFrmReadInf.frm->data[4];

		if (bFirst) {
			if (nCopied > payloadSizeMax - 1) // Reserver one byte for the first FU-A fragment
				nCopied = payloadSizeMax - 1;
		}
		else {
			if (nCopied > payloadSizeMax - 2) // Reserver two bytes for the left FU-A fragment
				nCopied = payloadSizeMax - 2;
		}

		fHeaderBuffer[0] = (NALType & 0xE0) | 28; // FU indicator

		if (bFirst) { // first FU-A fragment
			fHeaderBuffer[1] = 0x80 | (NALType & 0x1F); // FU header (with S bit)
		}
		else {
			fHeaderBuffer[1] = (NALType & 0x1F); // FU header (no S bit)
		}

		if (nCopied == nRemainder) { // last fragment
			fHeaderBuffer[1] |= 0x40; // set the E bit in the FU header
		}

		rpvec.append(fHeaderBuffer, 2);

		if (bFirst) {
			rpvec.append(fFrmReadInf.getData() + 1, nCopied - 1);
			rpinf.size = nCopied + 1;
		}
		else {
			rpvec.append(fFrmReadInf.getData(), nCopied);
			rpinf.size = nCopied + 2;
		}
	}
	else {
		rpvec.append(fFrmReadInf.getData(), nCopied);
		rpinf.size = nCopied;
	}

	fFrmReadInf.advance(nCopied);

	//ndk_info("fMaxSize=%u, fFrameSize=%u, rdpos=%u, nCopied=%u, idx=%lld"
	//	, fMaxSize, fFrameSize, _frmReadPos, nCopied, _frmNextIdx);

	if (fFrmReadInf.end()) {
		rpinf.lastPacket = True;
	}
	else
		rpinf.lastPacket = False;
}

