/**************************************************************************
 *
 *       Copyright (c) 2013 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#ifndef _H264_VIDEO_CAPTURE_SOURCE_HH__
#define _H264_VIDEO_CAPTURE_SOURCE_HH__

#include "CaptureFramedSource.hh"

///////////////////////////////////////////////////////////////////////////////
// Class CaptureDeviceSource
class H264VideoCaptureSource: public CaptureFramedSource
{
public:
	static H264VideoCaptureSource* createNew(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId);

	virtual const char* getClassName() const { return "H264VidCapSrc"; }
	virtual void rtpPayloadIterate(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);

	bool getSPSAndPPSFrame(NSFrame *&sps, NSFrame *& pps);
	double getFrameRate() const;

protected:
	H264VideoCaptureSource(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId);
	virtual ~H264VideoCaptureSource();
	virtual Boolean isH264VideoStreamFramer() const;

private:
	NSFrmIdx fFrmSPSIdx;
	NSFrmIdx fFrmPPSIdx;
	u_int8_t fHeaderBuffer[2];
};

#endif
