/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2012 Live Networks, Inc.  All rights reserved.
// RTP sink for JPEG video (RFC 2435)
// Implementation

#include "JPEGVideoCaptureRTPSink.hh"
#include "JPEGVideoSource.hh"
#include <JPEGVideoCaptureSource.hh>

JPEGVideoCaptureRTPSink
::JPEGVideoCaptureRTPSink(UsageEnvironment &env, Groupsock *RTPgs)
: VideoCaptureRTPSink(env, RTPgs, RTP_PAYLOAD_TYPE, "JPEG")
, fLastNetLoad(NDK_ST_NETLOAD_LOW)
{
	//ndk_info("++ %s", name());
}

JPEGVideoCaptureRTPSink::~JPEGVideoCaptureRTPSink()
{
	//ndk_info("-- %s", name());
}

JPEGVideoCaptureRTPSink *
JPEGVideoCaptureRTPSink::createNew(UsageEnvironment &env, Groupsock *RTPgs)
{
	return new JPEGVideoCaptureRTPSink(env, RTPgs);
}

Boolean JPEGVideoCaptureRTPSink::sourceIsCompatibleWithUs(MediaSource &source)
{
	return source.isJPEGVideoSource();
}

#if 0
void JPEGVideoCaptureRTPSink::dynamicFrmrateControl(int loading)
{
	if (loading == fLastNetLoad)
		return;

	UINT32 fr;

	sp5kMediaRecAttrGet(SP5K_MEDIA_ATTR_VIDEO_FRAME_RATE, &fr);
	if (fr == 0 || fr > 30)
		fr = 30;

	switch (loading) {
	case NDK_ST_NETLOAD_LOW:
		fMaxOutPacketNumInOnePlaying = 32;
		ndk_dualstream_set_framerate(fr);
		break;
	case NDK_ST_NETLOAD_MIDDLE:
		fMaxOutPacketNumInOnePlaying = 12;
		ndk_dualstream_set_framerate(fr*4/5);
		break;
	case NDK_ST_NETLOAD_HIGH:
	default:
		fMaxOutPacketNumInOnePlaying = 4;
		ndk_dualstream_set_framerate(fr*2/3);
		break;
	}
}
#endif

