/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#include "JPEGVideoCaptureSMSS.hh"
#include "JPEGVideoCaptureSource.hh"
#include "JPEGVideoCaptureRTPSink.hh"

JPEGVideoCaptureSMSS *JPEGVideoCaptureSMSS::createNew(UsageEnvironment &env, NSFrmFifoMgr* mgr, CaptureServerMediaSubsession *master)
{
	JPEGVideoCaptureSMSS *smss = new JPEGVideoCaptureSMSS(env, mgr, master);
	return smss;
}

JPEGVideoCaptureSMSS::JPEGVideoCaptureSMSS(UsageEnvironment &env,
	NSFrmFifoMgr* mgr,
	CaptureServerMediaSubsession *master)
: CaptureServerMediaSubsession(env, mgr, master)
{
	ndk_info("+ %p", this);
}

JPEGVideoCaptureSMSS::~JPEGVideoCaptureSMSS()
{
	ndk_info("--");
}

FramedSource *JPEGVideoCaptureSMSS::createNewStreamSource(unsigned clientSessionId, unsigned &estBitrate)
{
	estBitrate = (512*1024)*8/1024; // kbps, estimate
	return JPEGVideoCaptureSource::createNew(envir(), *this, clientSessionId);
}

RTPSink *JPEGVideoCaptureSMSS::createNewRTPSink(Groupsock *rtpGroupsock, unsigned char rtpPayloadTypeIfDynamic, FramedSource *inputSource)
{
	RTPSink *p = JPEGVideoCaptureRTPSink::createNew(envir(), rtpGroupsock);
	return p;
}

char const *JPEGVideoCaptureSMSS::sdpLines()
{
	if (fSDPLines == NULL)
		fSDPLines = generateSDPLines();

	return fSDPLines;
}

char *JPEGVideoCaptureSMSS::generateSDPLines()
{
	unsigned estBitrate = 1024 * 12;
	char const *mediaType = "video";
	unsigned char rtpPayloadType = JPEGVideoCaptureRTPSink::RTP_PAYLOAD_TYPE;
	AddressString ipAddressStr(fServerAddressForSDP);
	char const *rtpmapLine = ""; // Payload type < 96
	char const *rangeLine = rangeSDPLine();
	char const *auxSDPLine = generateAuxSDPLine();

	char const *const sdpFmt =
		"m=%s %u RTP/AVP %d\r\n"
		"c=IN IP4 %s\r\n"
		"b=AS:%u\r\n"
		"%s"
		"%s"
		"%s"
		"a=control:%s\r\n";
	unsigned sdpFmtSize = strlen(sdpFmt)
			+ strlen(mediaType) + 5 /* max short len */ + 3 /* max char len */
			+ strlen(ipAddressStr.val())
			+ 20 /* max int len */
			+ strlen(rtpmapLine)
			+ strlen(rangeLine)
			+ strlen(auxSDPLine)
			+ strlen(trackId());
	char *sdpLines = new char[sdpFmtSize];
	snprintf(sdpLines, sdpFmtSize,
		sdpFmt,
		mediaType, // m= <media>
		fPortNumForSDP, // m= <port>
		rtpPayloadType, // m= <fmt list>
		ipAddressStr.val(), // c= address
		estBitrate, // b=AS:<bandwidth>
		rtpmapLine, // a=rtpmap:... (if present)
		rangeLine, // a=range:... (if present)
		auxSDPLine, // optional extra SDP line
		trackId()); // a=control:<track-id>
	delete[] (char *)rangeLine;

	return sdpLines;
}

char const *JPEGVideoCaptureSMSS::generateAuxSDPLine()
{
	char const *fmtpFmt = "a=frmerate:%.1f\r\n";
	NDK_ASSERT(strlen(fmtpFmt) + 16 < sizeof(fAuxSDPLine));

	double fr;
	NSMediaSrcAgent *msrc = getFIFO().getMediaSrc();

	if (!msrc)
		return "";

	fr = msrc->getSourceFrameRate();
	if (fr < 0.01)
		fr = 30;

	sprintf(fAuxSDPLine, fmtpFmt, fr);
	return fAuxSDPLine;
}

