/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#ifndef __JPEG_VIDEO_CAPTURE_SOURCE_HH__
#define __JPEG_VIDEO_CAPTURE_SOURCE_HH__

#include "CaptureFramedSource.hh"

class JPEGVideoCaptureSource : public CaptureFramedSource
{
public:
	static JPEGVideoCaptureSource *createNew(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId);

	virtual const char* getClassName() const { return "JpgVidCapSrc"; }
	virtual void rtpPayloadIterate(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);

	u_int8_t type();
	u_int8_t qFactor();
	u_int8_t width(); // # pixels/8 (or 0 for 2048 pixels)
	u_int8_t height(); // # pixels/8 (or 0 for 2048 pixels)

	u_int8_t const* quantizationTables(u_int8_t& precision, u_int16_t& length);

protected:
	JPEGVideoCaptureSource(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId);
	virtual ~JPEGVideoCaptureSource();

	// If "qFactor()" returns a value >= 128, then this function is called
	// to tell us the quantization tables that are being used.
	// (The default implementation of this function just returns NULL.)
	// "precision" and "length" are as defined in RFC 2435, section 3.1.8.

	virtual Boolean prepareFrame();
	virtual u_int16_t restartInterval();
	Boolean isJPEGVideoSource() const { return True; }

	virtual FrameStatus updateFrameStatus();

private:
	struct timeval fLastSentTime;

	u_int8_t  fImgWidth;
	u_int8_t  fImgHeight;
	u_int8_t  fImgType;
	u_int8_t  fQFactor;

	u_int8_t  fDqtPrec; // precision
	u_int16_t fDqtLen;
	u_int8_t  fDqtTable[64*4];
	u_int8_t  fHeaderBuffer[64*4 + 8 + 4];

	bool parseFrame(FrmReadInf *frinf);
	bool parseJfifHeader(FrmReadInf *frinf);
#ifdef ICAT_DUALSTREAM
	bool parseJpegData(FrmReadInf *frinf);
#endif
	bool parseSOF(FrmReadInf *frinf);
	bool parseDQT(FrmReadInf *frinf, int len);
};

#endif

