/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2012 Live Networks, Inc.  All rights reserved.
// A simple RTP sink that packs frames into each outgoing
//     packet, without any fragmentation or special headers.
// Implementation

#include "PCMAudioCaptureRTPSink.hh"
#include "PCMAudioCaptureSource.hh"

AudioCaptureRTPSink::AudioCaptureRTPSink(UsageEnvironment &env, Groupsock *RTPgs,
	unsigned char rtpPayloadFormat,
	unsigned rtpTimestampFrequency,
	char const *rtpPayloadFormatName,
	unsigned numChannels,
	char const *strAuxSDPLine)
: CaptureRTPSink(env, RTPgs
, rtpPayloadFormat, rtpTimestampFrequency, rtpPayloadFormatName, numChannels
, True)
, fStrAuxSDPLine(strAuxSDPLine)
{
}

AudioCaptureRTPSink::~AudioCaptureRTPSink()
{
	delete [] fStrAuxSDPLine;
}

AudioCaptureRTPSink *
AudioCaptureRTPSink::createNew(UsageEnvironment &env, Groupsock *RTPgs,
		unsigned char rtpPayloadFormat,
		unsigned rtpTimestampFrequency,
		char const *rtpPayloadFormatName,
		unsigned numChannels,
		char const *strAuxSDPLine)
{
	return new AudioCaptureRTPSink(env, RTPgs,
		rtpPayloadFormat, rtpTimestampFrequency, rtpPayloadFormatName, numChannels, strAuxSDPLine);
}

char const* AudioCaptureRTPSink::auxSDPLine()
{
	return fStrAuxSDPLine;
}

Boolean AudioCaptureRTPSink::onBeforePlaying()
{
	//CaptureFramedSource *capsrc = (CaptureFramedSource*)fSource;

	//if (capsrc->getFifo().isLiveMode())
		//return True; // Always send frame. Don't delay.
	//else
		return CaptureRTPSink::onBeforePlaying();
}

