/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/
#include "PCMAudioCaptureSMSS.hh"
#include "PCMAudioCaptureSource.hh"
#include "PCMAudioCaptureRTPSink.hh"

AudioCaptureSMSS *
AudioCaptureSMSS::createNew(UsageEnvironment &env, NSFrmFifoMgr *mgr, CaptureServerMediaSubsession *master)
{
	AudioCaptureSMSS* smss = new AudioCaptureSMSS(env, mgr, master);
	return smss;
}

AudioCaptureSMSS::AudioCaptureSMSS(UsageEnvironment &env, NSFrmFifoMgr *mgr, CaptureServerMediaSubsession *master)
: CaptureServerMediaSubsession(env, mgr, master)
{
	ndk_info("+ %p", this);
}

AudioCaptureSMSS::~AudioCaptureSMSS()
{
	ndk_info("-");
}

FramedSource *AudioCaptureSMSS::createNewStreamSource(unsigned clientSessionId, unsigned &estBitrate)
{
	NSMediaSrcAgent *msrc = getFIFO().getMediaSrc();
	u_int32_t codec, sampleBits, sampleRate, channels;

	if (!msrc)
		ndk_err_return(NULL);

	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_CODEC, &codec);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_RATE, &sampleRate);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_CHANNELS, &channels);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_BITS, &sampleBits);

	u_int32_t bitrate = sampleRate * sampleBits * channels;
	estBitrate = bitrate/1024;

	AudioCaptureSource *src = AudioCaptureSource::createNew(envir(), *this, clientSessionId,
		sampleBits, bitrate/8, codec);
	if (fSourceFlags & FLG_AUD_MARKER_PER_FRAME)
		src->setMarkerPerFrame(True);

	return src;
}

RTPSink *AudioCaptureSMSS::createNewRTPSink(Groupsock *rtpGroupsock
		, unsigned char rtpPayloadTypeIfDynamic
		, FramedSource *inputSource)
{
	NSMediaSrcAgent *msrc = getFIFO().getMediaSrc();
	u_int32_t codec, sampleRate, sampleBits, channels;
	char const *mimeType = "";
	unsigned char payloadFormatCode;
	char* fmtpSDPLine = NULL;

	if (!msrc)
		ndk_err_return(NULL);

	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_CODEC, &codec);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_RATE, &sampleRate);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_BITS, &sampleBits);
	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_CHANNELS, &channels);
	ndk_info("codec=%08x sr=%d ch=%d", codec, sampleRate, channels);

	switch (codec) {
	case SP5K_MEDIA_AUDIO_AAC:
	{
		u_int16_t audioSpecificConfig = getAACAudioSpecificConfig();
		if (audioSpecificConfig == 0)
			ndk_err_return(NULL);

		payloadFormatCode = rtpPayloadTypeIfDynamic;
		mimeType = "MPEG4-GENERIC";

		// Set up the "a=fmtp:" SDP line for this stream:
		char const* fmtpFmt = "a=fmtp:%d streamtype=5;profile-level-id=1;mode=AAC-hbr"
			";sizeLength=13;indexLength=3;indexDeltaLength=3"
			";config=%04X\r\n";
		fmtpSDPLine = new char[strlen(fmtpFmt) + 3 + 4 + 8];
		if (!fmtpSDPLine)
			return NULL;

		sprintf(fmtpSDPLine, fmtpFmt, payloadFormatCode, audioSpecificConfig);
		break;
	}
	case SP5K_MEDIA_AUDIO_MULAW:
	{
		if (sampleRate != 8000 || channels != 1) {
			ndk_error("Audio streaming with mu-law noly supports sample-rate 8000 and one channel.\n");
			return NULL;
		}

		payloadFormatCode = 0;
		mimeType = "PCMU";
		break;
	}
	case SP5K_MEDIA_AUDIO_ALAW:
	{
		if (sampleRate != 8000 || channels != 1) {
			ndk_error("Audio streaming with a-law noly supports sample-rate 8000 and one channel.\n");
			return NULL;
		}

		payloadFormatCode = 8;
		mimeType = "PCMA";
		break;
	}
	case SP5K_MEDIA_AUDIO_PCM:
	{
		u_int32_t sampleBits;

		msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_BITS, &sampleBits);

		if (sampleBits == 16) {
			mimeType = "L16";

			if (sampleRate == 44100 && channels == 2) {
				payloadFormatCode = 10; // a static RTP payload type
			}
			else if (sampleRate == 44100 && channels == 1) {
				payloadFormatCode = 11; // a static RTP payload type
			}
			else {
				payloadFormatCode = rtpPayloadTypeIfDynamic;
			}
		}
		else if (sampleBits == 8) {
			mimeType = "L8";
			payloadFormatCode = rtpPayloadTypeIfDynamic;
		}
		else
			ndk_err_return(NULL);

		break;
	}
	case SP5K_MEDIA_AUDIO_IMA_ADPCM:
	{
		mimeType = "DVI4";

		if (sampleRate == 8000) {
			payloadFormatCode = 5;
		}
		else if (sampleRate == 16000) {
			payloadFormatCode = 6;
		}
		else if (sampleRate == 11025) {
			payloadFormatCode = 16;
		}
		else if (sampleRate == 22050) {
			payloadFormatCode = 17;
		}
		else {
			payloadFormatCode = rtpPayloadTypeIfDynamic;
			char const *fmtpFmt = "a=fmtp:%d samplebits=%u\r\n";
			fmtpSDPLine = new char[strlen(fmtpFmt) + 32];
			if (!fmtpSDPLine)
				return NULL;

			sprintf(fmtpSDPLine, fmtpFmt, payloadFormatCode, sampleBits);
		}
		break;
	}
	default:
		ndk_err_return(NULL);
	}

	AudioCaptureRTPSink *p = AudioCaptureRTPSink::createNew(envir(), rtpGroupsock,
		payloadFormatCode, sampleRate, mimeType, channels, fmtpSDPLine);
	return p;
}

u_int16_t AudioCaptureSMSS::getAACAudioSpecificConfig()
{
	NSMediaSrcAgent *msrc = getFIFO().getMediaSrc();
	if (!msrc)
		ndk_err_return(0);

	u_int16_t cfg = 0;
	u_int32_t attrVal;

	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_SAMPLE_RATE, &attrVal);

	cfg |= 0x02 << 11; // AAC Low Complexity

#define AAC_ASC_SAMPLE_RATE(i, v) case v: cfg |= i << 7; break
	switch (attrVal) {
	AAC_ASC_SAMPLE_RATE(0x0, 96000);
	AAC_ASC_SAMPLE_RATE(0x1, 88200);
	AAC_ASC_SAMPLE_RATE(0x2, 64000);
	AAC_ASC_SAMPLE_RATE(0x3, 48000);
	AAC_ASC_SAMPLE_RATE(0x4, 44100);
	AAC_ASC_SAMPLE_RATE(0x5, 32000);
	AAC_ASC_SAMPLE_RATE(0x6, 24000);
	AAC_ASC_SAMPLE_RATE(0x7, 22050);
	AAC_ASC_SAMPLE_RATE(0x8, 16000);
	AAC_ASC_SAMPLE_RATE(0x9, 12000);
	AAC_ASC_SAMPLE_RATE(0xa, 11025);
	AAC_ASC_SAMPLE_RATE(0xb, 8000);
	AAC_ASC_SAMPLE_RATE(0xc, 7350);
	default: return 0;
	}
#undef AAC_ASC_SAMPLE_RATE

	msrc->getSourceAttribute(SP5K_MEDIA_ATTR_AUDIO_CHANNELS, &attrVal);
	if (attrVal == 2)
		cfg |= 0x02 << 3;
	else if (attrVal == 1)
		cfg |= 0x01 << 3;
	else
		return 0;

	cfg |= 0x0 << 2; // Frame Legnth 1024
	cfg |= 0x0 << 1; // Core decoder
	cfg |= 0x0 << 0; // Extension Tag.

	printf("AAC AudioSpecificConfig = %04X\n", cfg);
	return cfg;
}

