/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2014 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#ifndef __AUDIO_CAPTURE_SMSS_HH__
#define __AUDIO_CAPTURE_SMSS_HH__

#include "CaptureServerMediaSubsession.hh"

// SMSS = ServerMediaSubsession
class AudioCaptureSMSS : public CaptureServerMediaSubsession
{
public:
	static AudioCaptureSMSS *createNew(UsageEnvironment &env
		, NSFrmFifoMgr *mgr
		, CaptureServerMediaSubsession *master);
	virtual const char *getClassName() const { return "PCMAudCapSMSS"; }
	virtual Boolean isAudio() const { return True; }

protected:
	AudioCaptureSMSS(UsageEnvironment &env, NSFrmFifoMgr *mgr, CaptureServerMediaSubsession *master);
	virtual ~AudioCaptureSMSS();

	virtual FramedSource *createNewStreamSource(unsigned clientSessionId,
		unsigned &estBitrate);
	virtual RTPSink *createNewRTPSink(Groupsock *rtpGroupsock,
		unsigned char rtpPayloadTypeIfDynamic,
		FramedSource *inputSource);

private:
	u_int16_t getAACAudioSpecificConfig();
};

#endif

