/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2012 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#include "PCMAudioCaptureSource.hh"

///////////////////////////////////////////////////////////////////////////////
// Class PCMAudioCaptureSource
AudioCaptureSource *AudioCaptureSource::createNew(UsageEnvironment& env,
	CaptureServerMediaSubsession &capSMSS,
	u_int32_t sampleBits, u_int32_t bytesPerSec, u_int32_t codec,
	unsigned sessId)
{
	return new AudioCaptureSource(env, capSMSS, sampleBits, bytesPerSec, codec, sessId);
}

AudioCaptureSource::AudioCaptureSource(UsageEnvironment& env,
	CaptureServerMediaSubsession &capSMSS,
	unsigned sessId,
	u_int32_t sampleBits,
	u_int32_t bytesPerSec,
	u_int32_t codec)
: CaptureFramedSource(env, capSMSS, sessId)
{
	//ndk_info("++ %d %s", id, name());
	fBytesPerSec = bytesPerSec;
	fCodec = codec;
}

AudioCaptureSource::~AudioCaptureSource()
{
	//ndk_info("-- %d %s", _objid, name());
}

AudioCaptureSource::FrameStatus AudioCaptureSource::updateFrameStatus()
{
	FrameStatus frmstat;

lCheckFrame:
	frmstat = checkFrame();

	if (fFlgAvSyncEnabled && frmstat == FRAME_READY) {
		struct timeval pts = fFrmReadInf.frm->pts;
		if (fFrmReadInf.readPos)
			timeval_add_ms(&pts, (fFrmReadInf.readPos*1000)/fBytesPerSec);

		int sync_res = avSyncCheck(pts);

		switch (sync_res) {
		case AV_SYNC_INVALID:
			if (fFrmReadInf.idx + 1 < fFrmFifo.getHeadFrmIdx()) {
				fFrmReadInf.detach();
				goto lCheckFrame;
			}
			else
				frmstat = FRAME_NOT_READY;
			break;

		case AV_SYNC_BEFORE:
			if (fCodec != SP5K_MEDIA_AUDIO_PCM) {
				fFrmReadInf.detach();
				goto lCheckFrame;
			}
			else {
				if (fFrmReadInf.readPos == 0)
					fFrmReadInf.startPos = fFrmReadInf.frm->length/2;
				frmstat = FRAME_READY;
			}
			break;

		case AV_SYNC_OK:
		case AV_SYNC_WAIT:
			frmstat = FRAME_READY;
			break;
		}
	}

	return frmstat;
}

void AudioCaptureSource::rtpPayloadIterate(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf)
{
	NDK_ASSERT(fFrmReadInf.frm);

	if (fFrmReadInf.readPos == 0) {
		rpinf.duration = (long)fFrmReadInf.frm->duration;
		//profLogPrintf(0, "PCM PTS: %d.%d", fPresentationTime.tv_sec, fPresentationTime.tv_usec);
	}

	switch (fCodec) {
	case SP5K_MEDIA_AUDIO_PCM:
		paylodIterate_PCM(payloadSizeMax, rpvec, rpinf);
		break;
	case SP5K_MEDIA_AUDIO_AAC:
		paylodIterate_AAC(payloadSizeMax, rpvec, rpinf);
		break;
	case SP5K_MEDIA_AUDIO_ALAW:
	case SP5K_MEDIA_AUDIO_MULAW:
		paylodIterate_ALAW_MULAW(payloadSizeMax, rpvec, rpinf);
		break;
	case SP5K_MEDIA_AUDIO_IMA_ADPCM:
		paylodIterate_IMA_ADPCM(payloadSizeMax, rpvec, rpinf);
		break;
	default:
		NDK_ASSERT(0);
		break;
	}

	rpinf.index = fFrmReadInf.frm->index;
	rpinf.timeCreated = fFrmReadInf.frm->timeCreated;
	rpinf.lastPacket = fFrmReadInf.end();
}

void AudioCaptureSource::paylodIterate_PCM(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf)
{
	unsigned pos = fFrmReadInf.startPos;

	if (!fFlgMarkerPerFrame)
		pos += fFrmReadInf.readPos;

	rpinf.pts = fFrmReadInf.frm->pts;
	timeval_add_ms(&rpinf.pts, pos * 1000 / fBytesPerSec);

	u_int32_t nRead = fFrmReadInf.remainder();
	if (nRead > payloadSizeMax)
		nRead = payloadSizeMax;

	rpvec.append(fFrmReadInf.advance(nRead), nRead);
	rpinf.size = nRead;
	rpinf.markerPerFrame = fFlgMarkerPerFrame ? True : False;
}

void AudioCaptureSource::paylodIterate_AAC(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf)
{
	payloadSizeMax -= 4;

	u_int32_t nRead = fFrmReadInf.remainder();
	if (nRead > payloadSizeMax)
		nRead = payloadSizeMax;

	NDK_ASSERT(nRead < ((1<<14) - 1));
	u_int8_t *headers = fPayloadlHeaders;
	headers[0] = 0;
	headers[1] = 16 /* bits */; // AU-headers-length
	headers[2] = nRead >> 5;
	headers[3] = (nRead&0x1F)<<3;

	rpvec.append(headers, 4);
	rpvec.append(fFrmReadInf.advance(nRead), nRead);

	rpinf.size = nRead + 4;
	rpinf.markerPerFrame = True;
	rpinf.pts = fFrmReadInf.frm->pts;
}

void AudioCaptureSource::paylodIterate_ALAW_MULAW(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf)
{
	rpinf.pts = fFrmReadInf.frm->pts;
	timeval_add_ms(&rpinf.pts, fFrmReadInf.readPos / 40/*frame size*/ * 5 /*ms*/);

	unsigned nRead = fFrmReadInf.remainder();
	if (nRead > payloadSizeMax)
		nRead = payloadSizeMax;
	if (nRead > 40)
		nRead -= nRead % 40;

	rpvec.append(fFrmReadInf.advance(nRead), nRead);
	rpinf.size = nRead;
	rpinf.markerPerFrame = False;
}

void AudioCaptureSource::paylodIterate_IMA_ADPCM(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf)
{
	rpinf.pts = fFrmReadInf.frm->pts;

	u_int32_t nRead = fFrmReadInf.remainder();
	if (nRead > payloadSizeMax)
		nRead = payloadSizeMax;

	rpvec.append(fFrmReadInf.advance(nRead), nRead);
	rpinf.size = nRead;
	rpinf.markerPerFrame = True;
}

