/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2014 by iCatch Technology Co., Ltd.             *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/

#ifndef __AUDIO_CAPTURE_SOURCE_HH__
#define __AUDIO_CAPTURE_SOURCE_HH__

#include "CaptureFramedSource.hh"

class AudioCaptureSource : public CaptureFramedSource
{
public:
	static AudioCaptureSource *createNew(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS, unsigned sessId,
		u_int32_t sampleBits, u_int32_t bytesPerSec, u_int32_t codec);

	virtual const char* getClassName() const { return "AudCapSrc"; }
	virtual void rtpPayloadIterate(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);

protected:
	AudioCaptureSource(UsageEnvironment& env, CaptureServerMediaSubsession &capSMSS,
		u_int32_t sampleBits, u_int32_t bytesPerSec, u_int32_t codec,
		unsigned sessId);
	virtual ~AudioCaptureSource();
	virtual FrameStatus updateFrameStatus();

private:
	u_int32_t fBytesPerSec;
	u_int32_t fCodec;
	u_int8_t  fPayloadlHeaders[8];

	void paylodIterate_PCM(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);
	void paylodIterate_AAC(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);
	void paylodIterate_ALAW_MULAW(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);
	void paylodIterate_IMA_ADPCM(unsigned payloadSizeMax, RTPPayloadVec &rpvec, RTPPayloadInf &rpinf);
};

#endif


