/**************************************************************************
 *
 *       Copyright (c) 2013 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/
#ifndef _VIDEO_CAPTURE_RTP_SINK_HH
#define _VIDEO_CAPTURE_RTP_SINK_HH

#include "RTPSink.hh"
#include "CaptureFramedSource.hh"

#ifdef TCPIP_LWIP
# define SENDPACKET_UDP_PBLIST
#endif

///////////////////////////////////////////////////////////////////////////////
class CaptureRTPSink: public RTPSink
{
protected:
	CaptureRTPSink(UsageEnvironment &env,
		Groupsock *RTPgs,
		unsigned char rtpPayloadFormat,
		unsigned rtpTimestampFrequency,
		char const *rtpPayloadFormatName,
		unsigned numChannels,
		Boolean audio);
	virtual ~CaptureRTPSink();

	virtual char const *sdpMediaType() const;
	virtual Boolean continuePlaying();
	Boolean continuePlaying1();
	virtual Boolean onBeforePlaying();
	Boolean preCheckPlaying(CaptureFramedSource *capsrc, Boolean &continuePlayingResult);

protected:
	SINT64 fStartTime;
	SINT64 fStartPTS;
	Boolean fFirstPlaying;
	unsigned fMaxOutPacketNumInOnePlaying;
	unsigned fRTPPayloadSize;

private:
	u_int8_t fRtpOutBuf[RTP_PAYLOAD_SIZE_MAX + RTP_HEADER_SIZE_MAX];
	Boolean fAudio;
	const char *fPrefix;

	void buildRTPHeader(u_int8_t *hdrbuf,
		RTPPayloadInf const &rpinf,
		u_int32_t ssrc,
		unsigned bPadding,
		Boolean firstPacket,
		Boolean hasExtenHeader,
		RTPExtenHeader *&extenHeader);
	void buildExtenHeader(RTPExtenHeader *extenHeader, RTPPayloadInf const &rpinf);
#ifdef SENDPACKET_UDP_PBLIST
	Boolean sendPacket_UDP_PBList(CaptureFramedSource *capsrc, u_int32_t ssrc, RTPPayloadInf &rpinf);
#endif
	Boolean sendPacket(CaptureFramedSource *capsrc, u_int32_t ssrc, RTPPayloadInf &rpinf);
	static void sendNextPacket(void *firstArg);
};

///////////////////////////////////////////////////////////////////////////////
class VideoCaptureRTPSink: public CaptureRTPSink
{
protected:
	VideoCaptureRTPSink(UsageEnvironment &env, Groupsock *RTPgs, unsigned char rtpPayloadFormat, char const *rtpPayloadFormatName);
	virtual Boolean onBeforePlaying();

protected:
	long fDbrcRatio;
	SINT64 fDbrcRecentTime;
};

#endif
