/**************************************************************************
 *
 *       Copyright (c) 2014 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/
#ifndef __LIVEST_INTERNAL_H__
#define __LIVEST_INTERNAL_H__

#if defined(SPCA6350)
# define ICAT_SPCA6350
#elif defined(SPCA6330)
# define ICAT_SPCA6330
#elif defined(SPCA5330)
# define ICAT_SPCA5330
#else
# error Unsupported Platform
#endif

#include <stdio.h>

#include <sp5k_os_api.h>
#include "cmd.h"

#include <ndk_global_api.h>
#include <ndk_misc_api.h>

extern "C" {
///////////////////////////////////////////////////////////////////////////////
// Debug & Log.

#define perror(s)               ndk_warning(s)

UINT32 profLogAddN(UINT32 id, const char *msg, UINT32 n);
UINT32 profLogPrintf(UINT32 slot, const char *format, ...);
UINT32 profLogCallStack(UINT32 id);

///////////////////////////////////////////////////////////////////////////////
// Thread
void*  ndk_thread_create(const char *name, UINT32 priority, void (*start_routine)(void *param), void *param, UINT32 stack_size);
void*  ndk_thread_identify();
void   ndk_thread_destroy(void *thread);
void   ndk_thread_yield();

///////////////////////////////////////////////////////////////////////////////
void   ndk_global_lock(unsigned int *x);
void   ndk_global_unlock(unsigned int *x);
void   ndk_cmd_register_syscmd(cmd_t *cmd, UINT32 nr);
void   ndk_cmd_dbgswitch_add(const char *name, long *addr);
int    ndk_base64_encode(char *dest_p, unsigned dest_len, unsigned char **src_pp, unsigned src_len);
int    ndk_base64_decode(unsigned char *dest_p, char const *src_p, unsigned src_len, char substitute_char);
void   ndk_cpuidle_begin(unsigned prio);
UINT32 ndk_cpuidle_get();
void   ndk_cpuidle_end();
int    ndk_sscanf(const char *ibuf, const char *fmt, ...);

void* ndk_blkpool_create(const char* name, int blk_size, int blk_num);
void  ndk_blkpool_destroy(void *pool_id);
void* ndk_blkpool_alloc_block(void *pool_id);
void  ndk_blkpool_free_block(void *pool_id, void *block_ptr);
void  ndk_blkpool_info_get(void *pool_id, int *available, int *total);

void* ndk_mem_malloc(size_t size);
void* ndk_mem_realloc(void * ptr, size_t size);
void  ndk_mem_free(void *ptr);

void *osMemAlloc(UINT32 size);
UINT32 osMemFree(void *pointer);

///////////////////////////////////////////////////////////////////////////////
const char *f2str(double d, int precision);
const char *tv2str(struct timeval const* tv);

void   tmrTimeStampGet(struct timeval *tv);
void   timeval_sub2(struct timeval *minuend, struct timeval const *subtrahend);
void   timeval_sub3(struct timeval *result, struct timeval const *minuend, struct timeval const *subtrahend);
void   timeval_add2(struct timeval *summand, struct timeval const *addend);
void   timeval_add3(struct timeval *result, struct timeval const *summand, struct timeval const *addend);
void   timeval_add_ms(struct timeval *summand, long diff_ms);
long   timeval_diff_ms(struct timeval const *minuend, struct timeval const *subtrahend);
long   timeval_diff_now_ms(struct timeval const *tv);
SINT64 timeval_diff_us(struct timeval const *minuend, struct timeval const *subtrahend);

static inline SINT64 timeval2mtime(struct timeval const *tv) { return ((SINT64)tv->tv_sec)*1000 + ((SINT64)tv->tv_usec)/1000; }
static inline SINT64 timeval2utime(struct timeval const *tv) { return ((SINT64)tv->tv_sec)*1000000 + (SINT64)tv->tv_usec; }
static inline void   mtime2timeval(struct timeval *tv, SINT64 t) { tv->tv_sec = t/1000; tv->tv_usec = (t%1000) * 1000; }
static inline void   utime2timeval(struct timeval *tv, SINT64 t) { tv->tv_sec = t/1000000; tv->tv_usec = t%1000000; }
static inline SINT64 mtime_now_get() { struct timeval tv; tmrTimeStampGet(&tv); return timeval2mtime(&tv); }
static inline SINT64 utime_now_get() { struct timeval tv; tmrTimeStampGet(&tv); return timeval2utime(&tv); }

UINT32 tmrTimeClockGet();
#define gettimeofday(tv, tz)	ndk_gettimeofday(tv)

///////////////////////////////////////////////////////////////////////////////
// Monitor
enum { NDK_MON_RES_OK = 0, NDK_MON_RES_INVALID, NDK_MON_RES_BREAK };

void ndk_mon_reset();
void ndk_mon_add_var(const char* var_name, UINT32 var_id, int width,
	int (*getval_func)(UINT32 var_id, char *val, int width, unsigned long param),
	unsigned long param);
void ndk_mon_start(int expires);
void ndk_mon_stop();

///////////////////////////////////////////////////////////////////////////////
int getch(void);
int puts(const char* s);
void memdump(const void *p, UINT32 size);

///////////////////////////////////////////////////////////////////////////////
// Media source and sink functions
#include <media_def.h>

/* Media record Dual-Stream functions */
#ifdef ICAT_SPCA6330
UINT32 mediaRecDualStreamOpen(mediaRecDualStreamClient_t *p_cli);
UINT32 mediaRecDualStreamClose(mediaRecDualStreamClient_t *p_cli);
UINT32 mediaRecDualStreamSetFrameRate(mediaRecDualStreamClient_t *p_cli, UINT32 frmrate); /* Return old frame rate */

mediaRecDualStreamState_e mediaRecDualStreamGetState();
UINT32 mediaRecDualStreamControl(mediaRecDualStreamCtrlCode_e code, ...);
#endif

/* Media Source APIs */
void   mediaSrcGlobalInit(UINT32 flags);

/* If on_get_buffer is NULL, caller can use mediaSrcGetBuffer function to get buffer. */
mediaSrcHandle_t mediaSrcOpenFile(const char *filename
	, mediaSrcOnGotBuffer_t on_got_buffer
	, unsigned long user_data
	, UINT32 flags);

#if defined(SPCA6350)
  mediaSrcHandle_t mediaSrcOpenAudioStream(mediaSrcOnGotBuffer_t on_got_buffer, unsigned long user_data, UINT32 flags);
  mediaSrcHandle_t mediaSrcOpenVideoStream(mediaSrcOnGotBuffer_t on_got_buffer, unsigned long user_data, UINT32 flags, UINT32 streamId, UINT32 codec);
#elif defined(SPCA6330)
  mediaSrcHandle_t mediaSrcOpenRmx(UINT32 es_type, mediaSrcOnGotBuffer_t on_got_buffer, unsigned long user_data, UINT32 flags);
  mediaSrcHandle_t mediaSrcOpenLiveAudio(mediaSrcOnGotBuffer_t on_got_buffer, unsigned long user_data, UINT32 flags);
#else
  #error Wrong Platform
#endif

void   mediaSrcClose(mediaSrcHandle_t h);
/* Always return FAIL if on_got_buffer is not NULL. */
UINT32 mediaSrcGetBuffer(mediaSrcHandle_t h, mediaSrcBuffer_t *buf, UINT32 wait_ms);
BOOL   mediaSrcEndOfSource(mediaSrcHandle_t h);
UINT32 mediaSrcControl(mediaSrcHandle_t h, mediaSrcCtrlCode_e code, ...);
UINT32 mediaSrcGetAttribute(mediaSrcHandle_t h, UINT32 attr, UINT32 *val);
void   mediaSrcHoldBufferObject(mediaBufferObject_t bufobj);
void   mediaSrcReleaseBufferObject(mediaBufferObject_t bufobj);
UINT32 mediaSrcJoinBuffer(mediaSrcBuffer_t *dst, UINT32 n, mediaSrcBuffer_t *srcs[]);

/* Media Sink APIs */
#ifdef SPCA6350
void   mediaSnkGlobalInit(UINT32 flags);
#endif

}

#endif

