/**************************************************************************
 *
 *       Copyright (c) 2011 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#ifndef __LIVEST_MEDIACLI_RTP_H__
#define __LIVEST_MEDIACLI_RTP_H__

#include <stdarg.h>
#include <ndk_rtpcli.h>

class RTPMediaClient;
/////////////////////////////////////////////////////////////////////////////////
struct RTPMediaClientStats
{
	int used;
	int avg_rx_delay;
};

/////////////////////////////////////////////////////////////////////////////////
// RTPMediaCli_MediaSession
class RTPMediaClientSession : public MediaSession
{
public:
	static RTPMediaClientSession *createNew(UsageEnvironment& env, char const* sdpDescription, RTPMediaClient &mcli);
	virtual ~RTPMediaClientSession();
	RTPMediaClient &mediaClient() { return fMediaCli; }

private:
	RTPMediaClient &fMediaCli;

	RTPMediaClientSession(UsageEnvironment& env, RTPMediaClient &mcli);
};

/////////////////////////////////////////////////////////////////////////////////
// RTP Option Get
class RTPMediaGetOpt
{
	int fOptNum;
	NDKMediaCliOpt *fOpts;

public:
	RTPMediaGetOpt(int optnum, NDKMediaCliOpt *opts) : fOptNum(optnum), fOpts(opts) {}
	long   getl(long id, long defval);
	double getd(long id, double defval);
};

/////////////////////////////////////////////////////////////////////////////////
// RTP Media Client
class RTPMediaClient : public RTSPClient
{
public:
	union MsgParam {
		unsigned u;
		double   d;
		long     l;
		Boolean  b;
	};

	struct MsgStru {
		MsgParam param0;
		MsgParam param1;
		MsgStru() { param0.u = param1.u = 0; }
	};

	typedef void (RTPMediaClient::*MsgFunc)(RTPMediaClient::MsgStru *m);

public:
	RTPMediaClient(
		UsageEnvironment& env,
		char const* rtspURL,
		int  verbosityLevel,
		char const* applicationName,
		NDKMediaCliAVSink *avsink,
		NDKMediaCliRtpMsgHandler *msgHandler,
		int optnum,
		NDKMediaCliOpt *opts);
	virtual ~RTPMediaClient();

	static int mediaCliInit(
		NDKMediaCliHandle *handle,
		const char *source_url,
		NDKMediaCliAVSink *avsink,
		NDKMediaCliRtpMsgHandler *msgHandler,
		int optnum,
		NDKMediaCliOpt *opts);
private:
	friend void ndk_mediacli_rtp_global_init();

	enum {
		STAT_INITIAL = 0,
		STAT_OPTIONS,
		STAT_DESCRIBE,
		STAT_SETUP,
		STAT_PLAYING,
		STAT_PAUSED,
		STAT_TEARDOWN,
		STAT_CLOSED,
		// State transtion error
		STAT_TRANS_ERROR
	};

	enum {
		SEEK_NONE = 0,
		SEEK_IN_PROGRESS,
		SEEK_PENDED
	};

	unsigned char  __start;
	RTPMediaClientSession *fSession;
	TaskToken      fGetParameterTask;
	TaskToken      fArrivalCheckTimerTask;
	TaskToken      fInterPacketGapCheckTimerTask;
	TaskToken      fTeardownTask;
	Boolean        fAudioOnly;
	Boolean        fVideoOnly;
	double         fDuration;
	double         fDurationStop; // extra seconds to play at the end
	double         fInitialSeekTime;
	char           *fInitialAbsoluteSeekTime;
	float          fScale;
	double         fEndTime;
	unsigned       fInterPacketGapMaxTime;
	unsigned       fTotNumPacketsReceived; // used if checking inter-packet gaps
	Boolean        fSendOptionsRequestOnly;
	Boolean        fStreamUsingTCP;
	Boolean        fForceMulticastOnUnspecified;
	unsigned short fDesiredPortNum;
	portNumBits    fTunnelOverHTTPPortNum;
	unsigned char  fDesiredAudioRTPPayloadFormat;
	char           *fMimeSubtype;
	Boolean        fMovieWidthOptionSet;
	Boolean        fMovieHeightOptionSet;
	Boolean        fMovieFPSOptionSet;
	unsigned       fSocketInputBufferSize;
	Boolean        fPacketLossCompensate;
	Boolean        fSyncStreams;
	Boolean        fWaitForResponseToTEARDOWN;
	portNumBits    fHandlerServerForREGISTERCommandPortNum;
	struct timeval fStartTime;

	// for SETUP request
	MediaSubsessionIterator *fSetupIter;
	MediaSubsession *fSetupSubsession;

	NDKMediaCli    fMediaCliBase;
	NDKMediaCliAVSink *fAVSink;
	unsigned       fSetupInProgress : 1,
	               fPauseOrResumeInProgress : 1,
	               fShutdownInProgress : 1,
	               fDestroyed : 1;

	unsigned char  __end;
	// The above values can be reset.

	RTPMediaClient *fNext;

	unsigned int   fFlgTCP : 1,
	               fFlgUnused : 1;
	long           fPktArrivalTimeout;
	unsigned int   fPlaybackCacheTime;
	int            fAudioPTSCorrection;
	unsigned int   fState;
	NDKMediaCliRtpMsgHandler *fMsgHandler;
	SP5K_EVENT_FLAGS_GROUP fStateEvt;
	char const     *fSingleMedium;
	TaskToken      fMsgToken;
	RTPMediaClientStats fStatsAudio, fStatsVideo;

	// Media Attributes
	UINT32         fH264GopNo;

private:
	void initClient();
	void setState(unsigned int state);
	Boolean waitState(unsigned int state);

	void start(double startTime);

	// startTime < 0.0: resume from current time or the pending seek time in fSeekPosition.
	UINT32 resume(long position, Boolean wait); // Cannot run in the task-scheduler thread.
	void msgResume(MsgStru *m);

	UINT32 pause(Boolean wait); // Cannot run in the task-scheduler thread.
	void msgPause(MsgStru *m);

	void shutdown();
	void msgShutdown(MsgStru *m);
	void shutdown2();

	void sendUserMsg(NDKMediaCliRtpMsg msg, long param);

	TaskToken scheduleMsgTask(RTPMediaClient::MsgFunc f, RTPMediaClient::MsgStru const &m);
	TaskToken scheduleTask(int64_t mSecsToDelay, void (*func)(RTPMediaClient *));

	void setupStreams();
	void sessionAfterPlaying(Boolean bye);
	void closeMediaSinks();
	Boolean updateAttributes();

	static void continueAfterOPTIONS0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterOPTIONS(resultCode, resultString); }
	static void continueAfterDESCRIBE0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterDESCRIBE(resultCode, resultString); }
	static void continueAfterSETUP0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterSETUP(resultCode, resultString); }
	static void continueAfterPLAY0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterPLAY(resultCode, resultString); }
	static void continueAfterPAUSE0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterPAUSE(resultCode, resultString); }
	static void continueAfterTEARDOWN0(RTSPClient *This, int resultCode, char *resultString) { ((RTPMediaClient*)This)->continueAfterTEARDOWN(resultCode, resultString); }
	static void continueAfterGET_PARAMETER0(RTSPClient *This, int resultCode, char *resultString) { delete [] resultString; }

	void continueAfterOPTIONS(int resultCode, char *resultString);
	void continueAfterDESCRIBE(int resultCode, char *resultString);
	void continueAfterSETUP(int resultCode, char *resultString);
	void continueAfterPLAY(int resultCode, char *resultString);
	void continueAfterPAUSE(int resultCode, char *resultString);
	void continueAfterTEARDOWN(int resultCode, char *resultString);

	static void subsessionAfterPlaying(void *session);
	static void subsessionByeHandler(void *subsession);
	static void checkForPacketArrival(RTPMediaClient *This);
	static void checkInterPacketGaps(RTPMediaClient *This);
	static void checkForGET_PARAMETER(RTPMediaClient *This);
	static void checkForTEARDOWN(RTPMediaClient *This);

	static UINT32 avSinkMsgHandler(UINT32 msg, long param, void *user_data);

	static int  mediaCliStart(struct NDKMediaCli *cli, int optnum, NDKMediaCliOpt *opts);
	static int  mediaCliStop(struct NDKMediaCli *cli);
	static void mediaCliDestroy(struct NDKMediaCli *cli);

	static Boolean findClient(RTPMediaClient *This);
};

#endif
