#ifndef __NDK_NAL_PARSER_H__
#define __NDK_NAL_PARSER_H__

#include <ndk_types.h>

#ifdef __cplusplus
extern "C" {
#endif

struct SeqParameterSetRbsp {
	UINT8     profile_idc;            // 0xff
	UINT8     constraint_setN_flag;   // 0x0f
	UINT8     level_idc;              // 0xff
	UINT32    seq_parameter_set_id;
	UINT32    chroma_format_idc;
	UINT8     residual_colour_transform_flag;  // 0x01
	UINT32    bit_depth_luma_minus8;
	UINT32    bit_depth_chroma_minus8;
	UINT8     qpprime_y_zero_transform_bypass_flag;
	UINT8     seq_scaling_matrix_present_flag;
	UINT8     seq_scaling_lists_present_flag;  // each bit = 1 list flag
	UINT32    log2_max_frame_num_minus4;
	UINT32    pic_order_cnt_type;
	UINT32    log2_max_pic_order_cnt_lsb_minus4;
	UINT8     delta_pic_order_always_zero_flag;
	SINT32    offset_for_non_ref_pic;
	SINT32    offset_for_top_to_bottom_field;
	UINT8     num_ref_frames_in_pic_order_cnt_cycle;
	SINT32    offset_for_ref_frame[256];
	UINT32    num_ref_frames;
	UINT8     gaps_in_frame_num_value_allowed_flag;
	UINT32    pic_width;
	UINT32    pic_height;
	UINT8     frame_mbs_only_flag;
	UINT8     mb_adaptive_frame_field_flag;
	UINT8     direct_8x8_inference_flag;
	UINT8     frame_cropping_flag;
	UINT32    frame_crop_left_offset;
	UINT32    frame_crop_right_offset;
	UINT32    frame_crop_top_offset;
	UINT32    frame_crop_bottom_offset;
	UINT8     vui_parameters_present_flag;
};

struct PicParameterSetRbsp {
	UINT32    pic_parameter_set_id;
	UINT32    seq_parameter_set_id;
	UINT8     entropy_coding_mode_flag;
	UINT8     pic_order_present_flag;
};

struct NALBufferReader {
	UINT8     *buf;
	UINT8     *cur_pos;
	int       len;
	int       cur_offset;
};

int ndk_parse_sps(struct NALBufferReader *buf, struct SeqParameterSetRbsp *sps);
int ndk_parse_pps(struct NALBufferReader *buf, struct PicParameterSetRbsp *pps);

#ifdef __cplusplus
}
#endif

#endif

