/**************************************************************************
 *
 *       Copyright (c) 2011 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/
#ifndef __STREAMING_API_H__
#define __STREAMING_API_H__

#include <livePort/streaming_def.h>

extern "C" {

///////////////////////////////////////////////////////////////////////////////
int closeSocket(int s);

///////////////////////////////////////////////////////////////////////////////
// Capture FIFO functions
bool    ndk_st_capfifo_ref(const char *streamName,
	NDKFrmFifoType vfft, NSFrmFifo **ppvff,
	NDKFrmFifoType afft, NSFrmFifo **ppaff);

void    ndk_st_capfifo_unref(const char *streamName,
	NDKFrmFifoType afft,
	NDKFrmFifoType vfft);

BOOL    ndk_st_send_event(UINT32 event, UINT32 data);
BOOL    ndk_st_in_mediasrv_thread();
BOOL    ndk_st_defsoc_is_used();
int     ndk_st_parse_streaming_type(const char *name);
int     ndk_st_get_netload(const char* ifname, int *loading_ret);
long    ndk_st_get_attr(NDKStAttr attr);

/* Called by liveMedia Server to finish stopping media-server */
void	ndk_st_stop_server_done(NDKStCtx *stctx);

void    streaming_server_global_init();
void    ndk_st_register_exitfunc(NDKStExitFunc *exit_func);
int     ndk_st_register_rtp_server(BOOL bTUTK);
int     ndk_st_register_rtp_client(BOOL bTUTK);
void    ndk_st_unregister_rtp_server();
void    ndk_st_unregister_rtp_client();

#ifdef ICAT_DUALSTREAM_JPEG
void	ndk_dualstream_config(NDKDualStreamCbFunc cbfunc, void* user_data);
void    ndk_dualstream_set_framerate(UINT32 frmrate);
#endif

BOOL    ndk_st_has_custom_mediasrc(NDKStMediaSrcType type);
void    ndk_st_get_custom_mediasrc(NDKStMediaSrcType type, NDKStMediaSrcCallback *cb);

/* Get existing RTP streaming connection number */
int     ndk_st_get_conn_num();
void    ndk_st_start_monitor();
void    ndk_st_dump_info();

} // extern "C"

#endif

