/**************************************************************************
 *
 *       Copyright (c) 2014 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include <sp5k_os_api.h>
#include <ndk_config.h>
#include <ndk_config.h>
#include <ndk_global_api.h>
#include <ndk_streaming.h>
#include <ndk_rtpcli.h>
#include <ndk_soc_api.h>
#include <ndk_httpd.h>
#include <livePort/livest_internal.h>
#include <livePort/streaming_api.h>

extern "C" {
#include <sp5k_disp_api.h>
#include "cmd.h"

long kmgstr_to_long(const char *s);
}

#ifdef NDK_CONFIG_TUTKSOCKET
# include <tutk_socket.h>
#endif

static const char *ifname_get()
{
	static char ifname[IF_NAMESIZE];

	if (ndk_netif_ioctl(NDK_IOCG_IF_INDEXTONAME, 1, (long*)ifname) == 0)
		return ifname;
	else
		return "wlan0";
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
static void cmd_st_dumpinfo(int argc, char **argv)
{
	ndk_st_dump_info();
}

#ifdef SPCA6350
# include "streaming_cmd_v35.c"
#else
# include "streaming_cmd_v33.c"
#endif

static cmd_t stcmds[] =
{
	{"stinf", cmd_st_dumpinfo,     "Dump Streaming Info."},
	{"ms",    cmd_mediasrv,        "Media server start/stop"},
	{"mc",    cmd_mediactl,        "Media server control"},
#ifdef SPCA6350
	{"rtp",   cmd_rtpcli_main,     "RTP media client"},
#ifdef NDK_CONFIG_HTTPD
	{"stcgi", cmd_stcgi_main,      "Streaming CGI"}
#endif
#else
	{"dust",  cmd_dualstream_test, "DualStream-JPEG test"},
#endif
};

extern void rtp_pktpbuf_global_init();

void _ndk_st_global_init()
{
	static char inited = 0;

	if (!inited) {
		rtp_pktpbuf_global_init();

		mediaSrcGlobalInit(0);
	#ifdef SPCA6350
		mediaSnkGlobalInit(0);
	#endif
		ndk_cmd_register_syscmd(stcmds, NDK_ARRAY_SIZE(stcmds));
		inited = 1;
	}
}

