/**************************************************************************
 *
 *       Copyright (c) 2014 by iCatch Technology, Inc.
 *
 *  This software is copyrighted by and is the property of iCatch Technology,
 *  Inc.. All rights are reserved by iCatch Technology, Inc..
 *  This software may only be used in accordance with the corresponding
 *  license agreement. Any unauthorized use, duplication, distribution,
 *  or disclosure of this software is expressly forbidden.
 *
 *  This Copyright notice MUST not be removed or modified without prior
 *  written consent of iCatch Technology, Inc..
 *
 *  iCatch Technology, Inc. reserves the right to modify this software
 *  without notice.
 *
 *  iCatch Technology, Inc.
 *  19-1, Innovation First Road, Science-Based Industrial Park,
 *  Hsin-Chu, Taiwan, R.O.C.
 *
 **************************************************************************/

#ifndef __STREAMING_DEF_H__
#define __STREAMING_DEF_H__

#ifndef __cplusplus
# error Need C++ compiler
#endif

extern "C" {
#include <sp5k_os_api.h>
#include <sp5k_media_api.h>
#include <sp5k_global_api.h>
}

#include <ndk_streaming.h>

#ifdef SPCA6330
#define ICAT_STREAMING_FILE
#endif

#ifdef SPCA6350
#define ICAT_STREAMING_H264H264
#endif

///////////////////////////////////////////////////////////////////////////////
// Macros
#define NDK_MEDIACLI_APPNAME_V1         "iCatchMediaClient v1.0"
#define RTP_EXTEN_HEADER                1

#if RTP_EXTEN_HEADER
# define RTP_EXTEN_HEADER_SIZE          sizeof(RTPExtenHeader)
# define RTP_EXTEN_HEADER_BIT           0x10
#else
# define RTP_EXTEN_HEADER_SIZE          0
# define RTP_EXTEN_HEADER_BIT           0
#endif

///////////////////////////////////////////////////////////////////////////////
// Constants
typedef enum {
	NDK_ST_STAT_INVALID             = 0,
	NDK_ST_STAT_STOPPED,
	NDK_ST_STAT_STARTED
} NDKStState;

enum {
	NDK_ST_EXT_ATTR_RANDOM_LOADING  = NDK_ST_ATTR_MAX,
	NDK_ST_EXT_ATTR_PSEUDO_LOADING, /* For testing only. */
	NDK_ST_EXT_ATTR_MAX
};

enum {
	NDK_ST_NETLOAD_LOW              = 0,
	NDK_ST_NETLOAD_MIDDLE,
	NDK_ST_NETLOAD_HIGH,

	NDK_ST_NETLOAD_LOW_THRESHOLD    = 25
};

/* capture FIFO type. */
typedef enum {
	NDK_ST_FIFO_AUDIO               = 0,
	NDK_ST_FIFO_JPEG,
	NDK_ST_FIFO_H264,
	NDK_ST_FIFO_H264S0              = NDK_ST_FIFO_H264,
#ifdef ICAT_STREAMING_H264H264
	NDK_ST_FIFO_H264S1,
#endif

	NDK_ST_FIFO_NUM,
	NDK_ST_FIFO_INVALID             = 100,
} NDKFrmFifoType;

#define NDK_ST_IS_VALID_FIFO_TYPE(t)    ((t) >= 0 && (t) < NDK_ST_FIFO_NUM)

///////////////////////////////////////////////////////////////////////////////
// Forward Reference
class RTSPServer;
class NSFrmFifo;

///////////////////////////////////////////////////////////////////////////////
// Types
#ifdef ICAT_DUALSTREAM_JPEG
typedef void (*NDKDualStreamCbFunc)(mediaSrcBuffer_t *buf, mediaRecDualStreamJpegAttr_t const *jpegattr, void* user_data);
#endif

struct NDKStExitFunc
{
	void            (*on_exit)(struct NDKStExitFunc *exit_func);
	void            *user_data;
	struct NDKStExitFunc *next;
};

struct NDKStCapFifoInf
{
	int             refcnt;
	NSFrmFifo*      fifo;
};

struct NDKStCtx
{
	NDKStCfg        cfg;
	NDKStCapFifoInf capfifos[NDK_ST_FIFO_NUM];

	// Attributes
	long            attrs[NDK_ST_EXT_ATTR_MAX];

	// Custom media-source callback
	NDKStMediaSrcCallback custom_mediasrc_cb[NDK_ST_MEDIASRC_NUM];

	// For RTSP Server
	struct timeval  tv_start;
	RTSPServer      *rtspServ;
	SP5K_MUTEX      mutex;
	void            *thrid; // streaming thread id.
	BOOL            abort_streaming;
	char            abort_server;
};

// Size must be multiple of 4.
struct RTPExtenHeader {
	UINT8           creationTimeMsecHigh;
	UINT8           creationTimeMsecLow;
	UINT8           ehl1;
	UINT8           ehl0;
	UINT32          creationTimeSec;
	UINT32          index;
} __attribute__((packed));

///////////////////////////////////////////////////////////////////////////////
// Global Streaming Context Variable. Don't use it directly. Is is for optimization.
extern "C" {

extern NDKStCtx g_stctx;

// Inline and Macro functions
static inline BOOL ndk_st_sys_protect(int millisec) { return sp5kOsMutexGet(&g_stctx.mutex, millisec >= 0 ? millisec : TX_WAIT_FOREVER) == SUCCESS; }
static inline void ndk_st_sys_unprotect() { sp5kOsMutexPut(&g_stctx.mutex); }

static inline BOOL ndk_st_aborted() { return g_stctx.abort_streaming; }
static inline void ndk_st_get_starttime(struct timeval *tv) { *tv = g_stctx.tv_start; }
static inline const char* ndk_st_get_rootdir() { return g_stctx.cfg.root_dir; }

}

#endif

