/**************************************************************************
 *                                                                        *
 *         Copyright (c) 2014 by iCatch Technology Co., Ltd.              *
 *                                                                        *
 *  This software is copyrighted by and is the property of Sunplus        *
 *  Technology Co., Ltd. All rights are reserved by Sunplus Technology    *
 *  Co., Ltd. This software may only be used in accordance with the       *
 *  corresponding license agreement. Any unauthorized use, duplication,   *
 *  distribution, or disclosure of this software is expressly forbidden.  *
 *                                                                        *
 *  This Copyright notice MUST not be removed or modified without prior   *
 *  written consent of Sunplus Technology Co., Ltd.                       *
 *                                                                        *
 *  Sunplus Technology Co., Ltd. reserves the right to modify this        *
 *  software without notice.                                              *
 *                                                                        *
 *  Sunplus Technology Co., Ltd.                                          *
 *  19, Innovation First Road, Science-Based Industrial Park,             *
 *  Hsin-Chu, Taiwan, R.O.C.                                              *
 *                                                                        *
 **************************************************************************/
#ifndef __NS_TASKQUEUE_H__
#define __NS_TASKQUEUE_H__

#include <ndk_types.h>
#include <sp5k_os_api.h>

class NSTaskQueue
{
public:
	enum { TASK_TIMEOUT, TASK_REMOVED };
	typedef void TaskHandler(void *data, int evt);

	NSTaskQueue(int dataSize, int queSize);
	virtual ~NSTaskQueue();

	bool  initialize();
	void  deinitialize();
	bool  showHeadTask(void **data, int *timeLeft);
	void* pushTask(TaskHandler *handler, void *data, int delayTimeMs, bool backIfEqual);
	void  clearTasks();
	void  freeze(bool froze);
	int   getAvailableSize() const { return fMaxEntryNum - fEntryNum; }
	int   getTotalDelayTime() const;

private:
	struct TaskEntry {
		UINT32 magicNumber;
		TaskEntry *next;
		TaskHandler *handler;
		int  timeLeft;
	};

	// Scheduler event
	enum { SCHE_WAKEUP = 1, SCHE_ABORT = 2, SCHE_ABORTED = 4 };

	bool       fInited;
	bool       fFrozen;
	int        fDataSize;
	int        fMaxEntryNum;
	int        fEntryNum;
	TaskEntry  *fEntryHead;
	void       *fBlkPool;
	int        fTotalTime;
	SINT64     fTimeLastSync;
	SP5K_EVENT_FLAGS_GROUP fEvtFlags;
	SP5K_MUTEX fMutex;
	UINT32     fThrId;

	void synchronize();
	void scheTaskFunc();
	TaskEntry *popTaskEntry(bool force);
	static void scheTaskFunc0(UINT32 arg) { ((NSTaskQueue *)arg)->scheTaskFunc(); }
};

#endif

