/*
 *  linux/drivers/mmc/core/bus.h
 *
 *  Copyright (C) 2003 Russell King, All Rights Reserved.
 *  Copyright 2007 Pierre Ossman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef _MMC_CORE_BUS_H
#define _MMC_CORE_BUS_H

#include <general.h>
#include <os/ros_api.h>
#include "mmc_config.h"
#include "mmc_errno.h"
#include "mmc_core.h"

#include "mmc_ops.h"
#include "sdio_bus.h"
#include "sdio_cis.h"
#include "sdio_ops.h"

#define pr_debug	printf
#define pr_warning	printf
#define printk		printf

#if 0
#define WARN_ON(x) assert(!(x))
#define BUG_ON(x)  assert(!(x))
#else
#define WARN_ON(x)
#define BUG_ON(x)
#endif

#define ERR_LINE   (-__LINE__)

extern void SDBUSDBG(const char *fmt, ...);

#define MMC_DEBUG 1
#define MMC_CMD_RETRIES        3

struct mmc_host;
struct mmc_bus_type
{
	struct mmc_host* hosts[CONFIG_MMC_HOST_NR];

	/* TODO: support more function drivers in the future */
	struct sdio_driver* sdio_func_driver;
};

/* The following is from core.h */
struct mmc_bus_ops {
	void (*remove)(struct mmc_host *);
	void (*detect)(struct mmc_host *);
	int (*suspend)(struct mmc_host *);
	int (*resume)(struct mmc_host *);
};

void mmc_attach_bus(struct mmc_host *host, const struct mmc_bus_ops *ops);
void mmc_detach_bus(struct mmc_host *host);

void mmc_set_clock(struct mmc_host *host, unsigned int hz);
void mmc_set_bus_width(struct mmc_host *host, unsigned int width);

#define mmc_delay(ms) ros_thread_sleep(ms)

int mmc_rescan(struct mmc_host *host);
int  mmc_attach_sdio(struct mmc_host *host);

#endif

