/*
 *  linux/drivers/mmc/core/host.c
 *
 *  Copyright (C) 2003 Russell King, All Rights Reserved.
 *  Copyright (C) 2007-2008 Pierre Ossman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  MMC host class device management
 */

#include "bus.h"

extern struct mmc_bus_type g_mmc_bus;
static char hostname[12];

int mmc_init_host(struct mmc_host* host)
{
	memset(host, 0, sizeof(*host));

	sprintf(hostname, "mmc_host:%02d", (UINT32)host->index);

	host->lock = ros_mutex_create(hostname, 0);
	if (host->lock == 0) {
		return -1;
	}

	return 0;
}

int mmc_deinit_host(struct mmc_host* host)
{
	if (host->lock) {
		ros_mutex_destroy(host->lock);
		host->lock = 0;
	}

	return 0;
}


int mmc_add_host(struct mmc_host *host)
{
	if (!host)
		return -1;

	int n;
	struct mmc_bus_type* bus = &g_mmc_bus;

	for (n = 0; n < CONFIG_MMC_HOST_NR; ++n) {
		if (!bus->hosts[n]) {
			bus->hosts[n] = host;
			if (mmc_rescan(host)) {
				bus->hosts[n] = NULL;
				return -1;
			}

			return 0;
		}
	}

	return -1;
}

void mmc_remove_host(struct mmc_host *host)
{
	if (!host)
		return;

	int n;
	struct mmc_bus_type* bus = &g_mmc_bus;

	for (n = 0; n < CONFIG_MMC_HOST_NR; ++n) {
		if (bus->hosts[n] == host) {
			host->bus_ops->remove(host);
			mmc_claim_host(host);
			mmc_detach_bus(host);
			mmc_release_host(host);

			bus->hosts[n] = NULL;
		}
	}
}

const char* mmc_hostname(struct mmc_host* host)
{
	return hostname;
}

