/*
 *  arch/arm/include/debug/pesaro.S
 *
 *  Early serial output macro for VATICS Pesaro SoC
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#define VPL_UARTC_0_MMR_BASE            0xAB800004
#define VPL_UARTC_1_MMR_BASE            0xAC000004
#define VPL_UARTC_2_MMR_BASE            0xAC800004
#define VPL_UARTC_3_MMR_BASE            0xAD000004

#define IO_BASE		0xF0000000
#define IO_ADDRESS(x) ((((x) & 0xFFF00000) >> 4) | ((x) & 0x0000FFFF) | IO_BASE)

#define __PESARO_UART(n) VPL_UARTC_##n##_MMR_BASE
#define PESARO_UART(n)   __PESARO_UART(n)
#define UART_BASE PESARO_UART(CONFIG_DEBUG_PESARO_UART_PORT)

#ifndef UART_VIRTBASE
#define UART_VIRTBASE	IO_ADDRESS(UART_BASE)
#endif

	.macro  addruart, rp, rv, tmp
	ldr	\rp, =UART_BASE					@ Physical base
	ldr	\rv, =UART_VIRTBASE    				@ Virtual base, map by map_desc in pesaro.c
	.endm

#define UART_SHIFT  2
#include "8250_32.S"
