/*
 *  arch/arm/mach-pesaro/include/mach/irqs.h
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

/*  IRQ numbers definition  */
#define ARM926U_IRQ_NUM                 0
#define N903U_IRQ_NUM                   1
#define APBC_IRQ_NUM                    2

#define DMAC_IRQ_NUM                    4
#define VIC_IRQ_NUM                     6
#define VOC_IRQ_NUM                     7
#define CCE_IRQ_NUM                     8
#define DCE_IRQ_NUM                     9
#define H4EE_IRQ_NUM                    10
#define ISPE_IRQ_NUM                    11
#define JEBE_IRQ_NUM                    12
#define MEAE_IRQ_NUM                    13

#define GMAC_IRQ_NUM                    16
#define MIPIRC_IRQ_NUM                  17
#define MSHC0_IRQ_NUM                   18
#define MSHC1_IRQ_NUM                   19
#define NFC_IRQ_NUM                     20
#define USBC_IRQ_NUM                    21
#define HDMITC_IRQ_NUM                  22
#define HDMITC_WK_IRQ_NUM               23

#define SSIC_IRQ_NUM                    33

#define I2SSC_RX_IRQ_NUM                35
#define I2SSC_TX_IRQ_NUM                36
#define VIC0_VSYNC_IRQ_NUM              37
#define VIC0_INV_VSYNC_IRQ_NUM          38
#define VIC1_VSYNC_IRQ_NUM              39
#define VIC1_INV_VSYNC_IRQ_NUM          40
#define GPADC_IRQ_NUM                   41
#define I2CC0_IRQ_NUM                   42
#define I2CC1_IRQ_NUM                   43
#define I2CC2_IRQ_NUM                   44

#define AGPOC_IRQ_NUM                   48
#define GPIOC0_IRQ_NUM                  49
#define GPIOC1_IRQ_NUM                  50
#define GPIOC2_IRQ_NUM                  51
#define IRDAC_IRQ_NUM                   52
#define TMRC_IRQ_NUM                    53
#define TMRC_TM0_IRQ_NUM                54
#define UARTC0_IRQ_NUM                  55
#define UARTC1_IRQ_NUM                  56
#define UARTC2_IRQ_NUM                  57
#define UARTC3_IRQ_NUM                  58
#define WDTC_IRQ_NUM                    59

#define SYSC_IRQ_NUM                    63

/* Unified Macros */
#define VPL_APBC_IRQ_NUM                APBC_IRQ_NUM
#define VPL_DMAC_IRQ_NUM                DMAC_IRQ_NUM
#define VPL_VIC_IRQ_NUM                 VIC_IRQ_NUM
#define VPL_VOC_IRQ_NUM                 VOC_IRQ_NUM
#define VMA_CCE_IRQ_NUM                 CCE_IRQ_NUM
#define VMA_DCE_IRQ_NUM                 DCE_IRQ_NUM
#define VMA_H4EE_IRQ_NUM                H4EE_IRQ_NUM
#define VMA_ISPE_IRQ_NUM                ISPE_IRQ_NUM
#define VMA_JEBE_IRQ_NUM                JEBE_IRQ_NUM
#define VMA_MEAE_IRQ_NUM                MEAE_IRQ_NUM
#define VPL_GMAC_IRQ_NUM                GMAC_IRQ_NUM
#define VMA_MIPIRC_IRQ_NUM              MIPIRC_IRQ_NUM
#define VPL_MSHC0_IRQ_NUM               MSHC0_IRQ_NUM
#define VPL_MSHC1_IRQ_NUM               MSHC1_IRQ_NUM
#define VPL_NFC_IRQ_NUM                 NFC_IRQ_NUM
#define VPL_USBC_IRQ_NUM                USBC_IRQ_NUM
#define VPL_HDMITC_IRQ_NUM              HDMITC_IRQ_NUM
#define VPL_HDMITC_WK_IRQ_NUM           HDMITC_WK_IRQ_NUM
#define VPL_SSIC_IRQ_NUM                SSIC_IRQ_NUM
#define VPL_I2SSC_RX_IRQ_NUM            I2SSC_RX_IRQ_NUM
#define VPL_I2SSC_TX_IRQ_NUM            I2SSC_TX_IRQ_NUM
#define VPL_VIC0_VSYNC_IRQ_NUM          VIC0_VSYNC_IRQ_NUM
#define VPL_VIC0_INV_VSYNC_IRQ_NUM      VIC0_INV_VSYNC_IRQ_NUM
#define VPL_VIC1_VSYNC_IRQ_NUM          VIC1_VSYNC_IRQ_NUM
#define VPL_VIC1_INV_VSYNC_IRQ_NUM      VIC1_INV_VSYNC_IRQ_NUM
#define VPL_GPADC_IRQ_NUM               GPADC_IRQ_NUM
#define VPL_I2CC_0_IRQ_NUM              I2CC0_IRQ_NUM
#define VPL_I2CC_1_IRQ_NUM              I2CC1_IRQ_NUM
#define VPL_I2CC_2_IRQ_NUM              I2CC2_IRQ_NUM
#define VPL_AGPOC_IRQ_NUM               AGPOC_IRQ_NUM
#define VPL_GPIOC_IRQ_NUM               GPIOC0_IRQ_NUM //legency only one GPIOC
#define VPL_GPIOC_0_IRQ_NUM             GPIOC0_IRQ_NUM
#define VPL_GPIOC_1_IRQ_NUM             GPIOC1_IRQ_NUM
#define VPL_GPIOC_2_IRQ_NUM             GPIOC2_IRQ_NUM
#define VPL_IRDAC_IRQ_NUM               IRDAC_IRQ_NUM
#define VPL_TMRC_IRQ_NUM                TMRC_IRQ_NUM
#define VPL_TMRC_TM0_IRQ_NUM            TMRC_TM0_IRQ_NUM
#define VPL_UARTC_0_IRQ_NUM             UARTC0_IRQ_NUM
#define VPL_UARTC_1_IRQ_NUM             UARTC1_IRQ_NUM
#define VPL_UARTC_2_IRQ_NUM             UARTC2_IRQ_NUM
#define VPL_UARTC_3_IRQ_NUM             UARTC3_IRQ_NUM
#define VPL_WDTC_IRQ_NUM                WDTC_IRQ_NUM
#define VPL_SYSC_IRQ_NUM                SYSC_IRQ_NUM

/* multi platform driver compatible */
#define TMRC_TMSYS_IRQ_NUM		VPL_TMRC_TM0_IRQ_NUM
#define TMRC_TMCOM_IRQ_NUM		VPL_TMRC_IRQ_NUM

#define MAXIRQNUM                       63
#define MAXFIQNUM                       31
#define PESARO_NR_IRQS                 (MAXIRQNUM + 1)
#define PESARO_NR_FIQS                 (MAXFIQNUM + 1)

#endif /* __ASM_ARCH_IRQS_H */
