/*
 *  arch/arm/mach-pesaro/mach/maps.h
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_MAPS_H__
#define __ASM_ARCH_MAPS_H__

/* AHB Slaves */
#define PESARO_AHBC_0_BASE             0x80000000
#define PESARO_AHBC_1_BASE             0x81000000
#define PESARO_AHBC_2_BASE             0x82000000
#define PESARO_APBC_MMR_BASE           0x83000000
#define PESARO_DDR32SDMC_MMR_BASE      0x84000000
#define PESARO_DMAC_MMR_BASE           0x85000000
#define PESARO_INTC_MMR_BASE           0x86000000
#define PESARO_VIC_MMR_BASE            0x87000000
#define PESARO_VOC_MMR_BASE            0x88000000
#define PESARO_CCE_MMR_BASE            0x89000000
#define PESARO_DCE_MMR_BASE            0x8A000000
#define PESARO_H4EE_MMR_BASE           0x8B000000
#define PESARO_ISPE_MMR_BASE           0x8C000000
#define PESARO_JEBE_MMR_BASE           0x8D000000
#define PESARO_MEAE_MMR_BASE           0x8E000000

#define PESARO_GMAC_MMR_BASE           0x90000000
#define PESARO_MIPIRC_MMR_BASE         0x91000000
#define PESARO_MSHC0_MMR_BASE          0x92000000
#define PESARO_MSHC1_MMR_BASE          0x93000000
#define PESARO_NFC_MMR_BASE            0x94000000
#define PESARO_USBC_MMR_BASE           0x95000000

#define PESARO_APBC_DEV_MMR_BASE       0xA0000000
#define PESARO_APB3C_DEV_MMR_BASE      0xB0000000

#define PESARO_BRC_MEM_BASE            0x40000000 //0x00000000 befor remap
#define PESARO_DDR32SDMC_MEM_BASE      0x00000000 //0x40000000 befor remap

//---------------------------------------------------------------------
#define PESARO_SRAM_CTRL_MMR_BASE      (PESARO_BRC_MEM_BASE + 0x1800008)//0x4004)
#define PESARO_SRAM_MMR_BASE           (PESARO_BRC_MEM_BASE + 0x1000000)//0x1000)
//---------------------------------------------------------------------

/* APB Slaves */
#define PESARO_SSIC_MMR_BASE           0xA0800000
#define PESARO_I2SSC_RX_MMR_BASE       0xA1800000
#define PESARO_I2SSC_TX_MMR_BASE       0xA2000000

#define PESARO_ACDCC_MMR_BASE          0xA4000000
#define PESARO_GPADC_MMR_BASE          0xA4800000
#define PESARO_I2CC_0_MMR_BASE         0xA5000000
#define PESARO_I2CC_1_MMR_BASE         0xA5800000
#define PESARO_I2CC_2_MMR_BASE         0xA6000000
#define PESARO_MIPIRSSC_MMR_BASE       0xA6800000
#define PESARO_USBSSC_MMR_BASE         0xA7000000
#define PESARO_VDAC_MMR_BASE           0xA7800000
#define PESARO_AGPOC_MMR_BASE          0xA8000000
#define PESARO_GPIOC_0_MMR_BASE        0xA8800000
#define PESARO_GPIOC_1_MMR_BASE        0xA9000000
#define PESARO_GPIOC_2_MMR_BASE        0xA9800000
#define PESARO_IRDAC_MMR_BASE          0xAA000000
#define PESARO_RTCC_MMR_BASE           0xAA800000
#define PESARO_TMRC_MMR_BASE           0xAB000000
#define PESARO_UARTC0_MMR_BASE         0xAB800004
#define PESARO_UARTC1_MMR_BASE         0xAC000004
#define PESARO_UARTC2_MMR_BASE         0xAC800004
#define PESARO_UARTC3_MMR_BASE         0xAD000004
#define PESARO_WDTC_MMR_BASE           0xAD800000

#define PESARO_PLLC_MMR_BASE           0xAF000000
#define PESARO_SYSC_MMR_BASE           0xAF800000

/* APB 3.0 Slaves */
#define PESARO_DDR32SDMC_PUB_MMR_BASE  0xB0000000
#define PESARO_HDMITC_MMR_BASE         0xB1800000
#define PESARO_TVESSC_MMR_BASE         0xB1901000

/*
 *-----------------------------
 * Device Base Unified MACROs
 *-----------------------------
 */
/* AHB slaves */
#define VPL_AHBC_0_MMR_BASE             PESARO_AHBC_0_BASE
#define VPL_AHBC_1_MMR_BASE             PESARO_AHBC_1_BASE
#define VPL_AHBC_2_MMR_BASE             PESARO_AHBC_2_BASE
#define VPL_APBC_MMR_BASE               PESARO_APBC_MMR_BASE
#define VPL_DDRSDMC_0_MMR_BASE          PESARO_DDR32SDMC_MMR_BASE
#define VPL_DMAC_MMR_BASE               PESARO_DMAC_MMR_BASE
#define VPL_INTC_MMR_BASE               PESARO_INTC_MMR_BASE
#define VPL_VIC_MMR_BASE                PESARO_VIC_MMR_BASE
#define VPL_VOC_MMR_BASE                PESARO_VOC_MMR_BASE

#define VMA_CCE_MMR_BASE                PESARO_CCE_MMR_BASE
#define VMA_DCE_MMR_BASE                PESARO_DCE_MMR_BASE
#define VMA_H4EE_MMR_BASE               PESARO_H4EE_MMR_BASE
#define VMA_ISPE_MMR_BASE               PESARO_ISPE_MMR_BASE
#define VMA_JEBE_MMR_BASE               PESARO_JEBE_MMR_BASE
#define VMA_MEAE_MMR_BASE               PESARO_MEAE_MMR_BASE

#define VPL_GMAC_MMR_BASE               PESARO_GMAC_MMR_BASE
#define VPL_MIPIRC_MMR_BASE             PESARO_MIPIRC_MMR_BASE
#define VPL_MSHC_0_MMR_BASE             PESARO_MSHC0_MMR_BASE
#define VPL_MSHC_1_MMR_BASE             PESARO_MSHC1_MMR_BASE
#define VPL_NFC_MMR_BASE                PESARO_NFC_MMR_BASE
#define VPL_USBC_MMR_BASE               PESARO_USBC_MMR_BASE

#define VPL_APBC_DEV_MMR_BASE           PESARO_APBC_DEV_MMR_BASE
#define VPL_APB3C_DEV_MMR_BASE          PESARO_APB3C_DEV_MMR_BASE

#define VPL_BRC_MEM_BASE                PESARO_BRC_MEM_BASE

/* APB slaves */
#define VPL_SSI_MMR_BASE                PESARO_SSIC_MMR_BASE
#define VPL_I2S_TX_MMR_BASE             PESARO_I2SSC_TX_MMR_BASE
#define VPL_I2S_RX_MMR_BASE             PESARO_I2SSC_RX_MMR_BASE
#define VPL_ACDCC_MMR_BASE              PESARO_ACDCC_MMR_BASE
#define VPL_GPADC_MMR_BASE              PESARO_GPADC_MMR_BASE
#define VPL_I2CC_0_MMR_BASE             PESARO_I2CC_0_MMR_BASE
#define VPL_I2CC_1_MMR_BASE             PESARO_I2CC_1_MMR_BASE
#define VPL_I2CC_2_MMR_BASE             PESARO_I2CC_2_MMR_BASE
#define VPL_MIPIR_SSC_MMR_BASE          PESARO_MIPIRSSC_MMR_BASE
#define VPL_USBC_SSC_BASE               PESARO_USBSSC_MMR_BASE
#define VPL_VDAC_MMR_BASE               PESARO_VDAC_MMR_BASE
#define VPL_AGPOC_MMR_BASE              PESARO_AGPOC_MMR_BASE
#define VPL_GPIOC_0_MMR_BASE            PESARO_GPIOC_0_MMR_BASE
#define VPL_GPIOC_1_MMR_BASE            PESARO_GPIOC_1_MMR_BASE
#define VPL_GPIOC_2_MMR_BASE            PESARO_GPIOC_2_MMR_BASE
#define VPL_IRDAC_MMR_BASE              PESARO_IRDAC_MMR_BASE
#define VPL_RTCC_MMR_BASE               PESARO_RTCC_MMR_BASE
#define VPL_TMRC_MMR_BASE               PESARO_TMRC_MMR_BASE
#define VPL_UARTC_0_MMR_BASE            PESARO_UARTC0_MMR_BASE
#define VPL_UARTC_1_MMR_BASE            PESARO_UARTC1_MMR_BASE
#define VPL_UARTC_2_MMR_BASE            PESARO_UARTC2_MMR_BASE
#define VPL_UARTC_3_MMR_BASE            PESARO_UARTC3_MMR_BASE
#define VPL_WDTC_MMR_BASE               PESARO_WDTC_MMR_BASE

#define VPL_PLLC_MMR_BASE               PESARO_PLLC_MMR_BASE
#define VPL_SYSC_MMR_BASE               PESARO_SYSC_MMR_BASE

#define VPL_HDMITC_MMR_BASE             PESARO_HDMITC_MMR_BASE
#define VPL_TVEC_MMR_BASE               PESARO_TVESSC_MMR_BASE


#define SYS_CLK                         CONFIG_SYS_CLK
#define AHB_CLK                         SYS_CLK
#define MAX_TIMER                       3
#define APB_CLK                         (SYS_CLK / 2)
#define DEFAULT_TICK                    1
#define PCLK_HZ                         (SYS_CLK/4)

/*  System Clock=22.1184MHZ   FCLK=System Clock/2   PCLK=System Clock/4
 *  UART clock =22118400/4=5529600     DLL=5529600/16 * baud
 */
#define UART_CLOCK                      CONFIG_UART_CLK
#define UART_CLK                        CONFIG_UART_CLK
#define PESARO_UART_CLOCK              UART_CLK
#define VPL_UART_BAUD_115200            (UART_CLOCK / 1843200)
#define VPL_UART_BAUD_57600             (UART_CLOCK / 921600)
#define VPL_UART_BAUD_38400             (UART_CLOCK / 614400)
#define VPL_UART_BAUD_19200             (UART_CLOCK / 307200)
#define VPL_UART_BAUD_9600              (UART_CLOCK / 153600)
#define VPL_UART_BAUD_4800              (UART_CLOCK / 76800)
#define VPL_UART_BAUD_2400              (UART_CLOCK / 38400)
#define VPL_UART_BAUD_1200              (UART_CLOCK / 19200)
#define VPL_UART_BAUD_300               (UART_CLOCK / 4800)
#define HOST_COMPORT                    IO_ADDRESS(PESARO_UARTC0_MMR_BASE)
#define HOST_IRQBIT_NUMBER              IRQ_UART1

/* Default port for use by Operating System or program */
#define OS_COMPORT                      PESARO_UART2_BASE
#define OS_IRQBIT_NUMBER                IRQ_UART2
#define DEBUG_COMPORT                   OS_COMPORT
#define DEBUG_IRQBIT                    OS_IRQBIT
#define MAX_UART_NUM                    4
#define DEFAULT_HOST_BAUD               VPL_UART_BAUD_38400
#define PESARO_FLASH_BASE              0x10000000
#define PESARO_FLASH_SIZE              0x00800000
#define FLASH_ADDRESS(x) ((x&0x0fffffff) + IO_BASE)

#endif  // __ASM_ARCH_MAPS_H__
