/*
 *  arch/arm/mach-pesaro/include/mach/uncompress.h
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/serial_reg.h>
#include <mach/maps.h>

#define __PESARO_UART(n) VPL_UARTC_##n##_MMR_BASE
#define PESARO_UART(n)   __PESARO_UART(n)
#define UART_BASE PESARO_UART(CONFIG_DEBUG_PESARO_UART_PORT)

static inline void putc(int c)
{
	volatile u32 *base = (u32 *)UART_BASE;
	int i;

	for (i = 0; i < 0x10000; i++) {
		if (base[UART_LSR] & UART_LSR_THRE)
			break;
		barrier();
	}

	base[UART_TX] = c;
}

static inline void flush(void)
{
	volatile u32 *base = (u32 *)UART_BASE;
	u32 mask;
	int i;
	mask = UART_LSR_TEMT | UART_LSR_THRE;

	for (i = 0; i < 0x10000; i++) {
		if ((base[UART_LSR] & mask) == mask)
			break;
		barrier();
	}
}

/*
 * nothing to do
 */
#define arch_decomp_setup()
