/*
 *  arch/arm/mach-pesaro/include/mach/vpl_sysc.h
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_VPL_SYSC_H
#define __ASM_ARCH_VPL_SYSC_H

#define SYSC_CNT_CTRL   0x18
#define SYSC_CNT_LOW    0x1C
#define SYSC_CNT_HIGH   0x20

/* PAD control in sysc */
#define SYSC_PAD_NUM                 7
#define SYSC_PAD_0                   0x9C
#define SYSC_PAD_1                   0xA0
#define SYSC_PAD_2                   0xA4
#define SYSC_PAD_3                   0xA8
#define SYSC_PAD_4                   0xAC
#define SYSC_PAD_5                   0xB0
#define SYSC_PAD_6                   0xB4

#define SYSC_RST_CTRL                0x24
#define SYSC_RST_N903		     9

#define SYSC_N903_CTRL               0x68

#define VPL_PAD_NUM                     SYSC_PAD_NUM
#define VPL_PAD_GPIO                    SYSC_PAD_2
#define VPL_PAD_GPIO_NUM		3

#define VPL_PAD_0                       SYSC_PAD_0
#define VPL_PAD_1                       SYSC_PAD_1
#define VPL_PAD_2                       SYSC_PAD_2
#define VPL_PAD_3                       SYSC_PAD_3
#define VPL_PAD_4                       SYSC_PAD_4
#define VPL_PAD_5                       SYSC_PAD_5
#define VPL_PAD_6                       SYSC_PAD_6
/*
 * Bit definition part
 */
#define SYSC_CNT_CTRL_CNT_CLEAR (1 << 16)
#define SYSC_CNT_CTRL_CNT_DIV_MASK 0xff

#endif /* __ASM_ARCH_VPL_SYSC_H */
