/*
 * arch/arm/mach-pesaro/pesaro.c
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: ChangHsien Ho <vincent.ho@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/slab.h>
#include <linux/clk-provider.h>
#include <linux/clocksource.h>
#include <linux/of_platform.h>
#include <linux/platform_device.h>
#include <linux/time.h>
#include <linux/irqchip.h>
#include <linux/memblock.h>
#include <linux/i2c.h>
#include <linux/irqdomain.h>
#include <asm/system_misc.h>
#include <asm/mach-types.h>
#include <asm/sizes.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irq.h>
#include <asm/setup.h>
#include <mach/hardware.h>
#include <mach/maps.h>
#ifdef CONFIG_USB
#include <mach/lm.h>
#include <mach/irqs.h>
#endif
#include "pesaro.h"

static struct map_desc pesaro_io_desc[]  __initdata = {
	/* ---- AHB ---- */
	{
		.virtual	= __IO_ADDRESS(VPL_AHBC_0_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_AHBC_0_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_AHBC_1_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_AHBC_1_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_AHBC_2_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_AHBC_2_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	},  {
		.virtual        = __IO_ADDRESS(VPL_APBC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_APBC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_DDRSDMC_0_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_DDRSDMC_0_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_MIPIRC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_MIPIRC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_INTC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_INTC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	},
	/* ---- APB ---- */
	{
		.virtual	= __IO_ADDRESS(VPL_I2S_TX_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_I2S_TX_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_I2S_RX_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_I2S_RX_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_MIPIR_SSC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_MIPIR_SSC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_AGPOC_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_AGPOC_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_GPIOC_0_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_GPIOC_0_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_GPIOC_1_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_GPIOC_1_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_GPIOC_2_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_GPIOC_2_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_UARTC_0_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_UARTC_0_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_UARTC_1_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_UARTC_1_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_UARTC_2_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_UARTC_2_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual	= __IO_ADDRESS(VPL_UARTC_3_MMR_BASE),
		.pfn		= __phys_to_pfn(VPL_UARTC_3_MMR_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_SYSC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_SYSC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	}, {
		.virtual        = __IO_ADDRESS(VPL_PLLC_MMR_BASE),
		.pfn            = __phys_to_pfn(VPL_PLLC_MMR_BASE),
		.length         = SZ_4K,
		.type           = MT_DEVICE,
	},
};

static void __init pesaro_map_io(void)
{
	iotable_init(pesaro_io_desc, ARRAY_SIZE(pesaro_io_desc));
}

static void __init pesaro_timer_and_clk_init(void)
{
	of_clk_init(NULL);
	clocksource_of_init();
}

static void __init pesaro_dt_init(void)
{
#ifdef CONFIG_SUSPEND
	pesaro_pm_init();
#endif
	of_platform_populate(NULL, of_default_bus_match_table, NULL, NULL);
	pesaro_pinmux_init();

#ifdef CONFIG_USB
	{
	struct lm_device *lmdev;
	lmdev = kzalloc(sizeof(struct lm_device), GFP_KERNEL);
	if (!lmdev)
		printk("Fail\n");

	lmdev->resource.start = VPL_USBC_MMR_BASE;
	lmdev->resource.end = lmdev->resource.start + SZ_256K - 1;
	lmdev->resource.flags = IORESOURCE_MEM;
	lmdev->irq = irq_create_mapping(NULL, USBC_IRQ_NUM);
	lmdev->id = 0;

	lm_device_register(lmdev);
	printk("lm device registered, virq: %d!\n", lmdev->irq);
	}
#endif
}

#ifdef CONFIG_PESARO_N9_RTOS
#define N9_MEMORY_USAGE		0x00600000 //2mb
#define N9_MEMORY_BASE		0x01400000 //22mb
void __init pesaro_n9_reserve(void)
{
	/* reserve 20mb ~ 22mb */
	memblock_reserve(N9_MEMORY_BASE, N9_MEMORY_USAGE);
	return;
}
#endif

static void pesaro_restart(char mode, const char *cmd)
{
	//struct device_node *np;
	void __iomem *wdt_base;

	//np = of_find_compatible_node(NULL, NULL, "vatics,vpl-wdt");
	//wdt_base = of_iomap(np, 0);
	wdt_base = ioremap(VPL_WDTC_MMR_BASE, SZ_4K);
	if (WARN_ON(!wdt_base))
		return;
#define WDTC_CTRL		(0x4)
#define WDTC_RELOAD_VALUE	(0x10)
#define WDTC_RELOAD_CTRL	(0x18)
#define WDTC_RST_LEN		(0x1c)

#define WDTC_RELOAD_KEY		0x28791166
#define WDTC_CTRL_ENABLE	0x4

	writel(0x0, wdt_base + WDTC_CTRL); 		//disable first
	writel(0xffff, wdt_base + WDTC_RST_LEN);	//set reset signal length
	writel(10, wdt_base + WDTC_RELOAD_VALUE);	//count down from 10
	writel(WDTC_RELOAD_KEY, wdt_base + WDTC_RELOAD_CTRL);	//load it to counter
	writel(WDTC_CTRL_ENABLE, wdt_base + WDTC_CTRL); //count down start
	while(1);
}

static const char * const pesaro_dt_compat[] = {
	"vatics,pesaro-soc",
	NULL
};

DT_MACHINE_START(PESARO_DT, "VATICS Pesaro SoC (Flattened Device Tree)")
	.atag_offset	= 0x100,
	.dt_compat	= pesaro_dt_compat,
	.map_io		= pesaro_map_io,
	.init_irq	= irqchip_init,
	.init_time	= pesaro_timer_and_clk_init,
	.init_machine   = pesaro_dt_init,
#ifdef CONFIG_PESARO_N9_RTOS
	.reserve        = pesaro_n9_reserve,
#endif
	.restart	= pesaro_restart,
MACHINE_END
