/*
 * arch/arm/mach-pesaro/pinmux.c
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: relive <paul.chen@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/pinctrl/machine.h>

struct pinctrl_map __initdata pesaro_pinmux_map[] = {
//	PIN_MAP_MUX_GROUP_DEFAULT("a5000000.i2c",  "pesaro-pinmux.1", "i2c0_pos_0", "i2c"),
/* we define init pins in device tree now */
#if 0
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "default_gpio", "gpio"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "arm926u", "arm926u"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "gmac", "gmac"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "hdmitc", "hdmitc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "i2c0_pos_0", "i2c"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "i2c1", "i2c"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "i2c2", "i2c"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "irdac", "irdac"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "mshc0", "mshc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "mshc0_pos_0", "mshc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "mshc0_pos_1", "mshc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "nfc", "nfc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "ssic_pos_0", "ssic"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "uart0_pos_0", "uart"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "uart1_pos_0", "uart"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "uart2_pos_0", "uart"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "uart3_pos_0", "uart"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "vic_dev_0", "vic"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "vic_ref_clk", "vic"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "voc_16bit", "voc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "voc_ref_clk", "voc"),
	PIN_MAP_MUX_GROUP_HOG_DEFAULT("pesaro-pinmux.1", "wdt", "wdt"),
#endif
};

void __init pesaro_pinmux_init(void)
{
	pinctrl_register_mappings(pesaro_pinmux_map,
			ARRAY_SIZE(pesaro_pinmux_map));

}
