#define DEBUG

#include <linux/delay.h>
#include <linux/firmware.h>
#include <linux/irqchip.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/irqdomain.h>
#include <linux/suspend.h>
#include <asm/suspend.h>
#include <asm/cacheflush.h>
#include <asm/system_misc.h>
#include <asm/mach-types.h>
#include <asm/sizes.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <mach/hardware.h>
#include <mach/maps.h>

#include <linux/irqchip/pesaro.h>
#include <mach/irqs.h>
#include <mach/vpl_sysc.h>
#include <mach/vpl_gpioc.h>
#include <mach/pm.h>
#include "pesaro.h"

// TODO: add wakeup sources setting, we hard code uart here first
static void* intc_base;
static void* sysc_base;
#ifdef CONFIG_N9_WAKEUP
static void* n9_base;
#endif
static int pesaro_cpu_suspend(unsigned long arg)
{
#ifdef CONFIG_N9_WAKEUP
	u32 reg;
	/* reset base adderss @ 0x41000000 */
       __raw_writel(0x01410000, sysc_base + SYSC_N903_CTRL);
	/* release reset signal */
       reg = readl(sysc_base + SYSC_RST_CTRL);
       reg |= 0x1 << SYSC_RST_N903;
       __raw_writel(reg, sysc_base + SYSC_RST_CTRL);
#endif
       cpu_do_idle();
       return 0;
}

#ifdef CONFIG_N9_WAKEUP
static void firmware_update(void)
{
       const char *fw_name = "n9-pm.bin";
       const struct firmware *fw_p;
       struct device dev;
       void* fw_base;
       fw_base = ioremap(N9_PM_BASE_ADDRESS, 0x1000);// BRC SRAM

       if (request_firmware(&fw_p, fw_name, &dev)) {
	       pr_info("%s - %s not found\n", __func__, fw_name);
       }
       memcpy(fw_base, fw_p->data, fw_p->size);
       printk("firmware_size:%d\n", fw_p->size);
       iounmap(fw_base);
       return;
}
static u32 intr_mask_lo;
static u32 intr_mask_hi;
#endif

static int pesaro_pm_enter(suspend_state_t state)
{
       int ret;
       u32 reg;
       u32 pin = 0x1 << WAKEUP_GPIO_PIN;
       pr_debug("%s(%d)\n", __func__, __LINE__);

       /* prepare wakeup irqs */
       /*
	*  TODO: add wakeup source setting
	*/
#ifdef CONFIG_N9_WAKEUP
	firmware_update();
       intr_mask_lo = readl(intc_base + INTC_HOSTU_0_MASK_LO);
       intr_mask_hi = readl(intc_base + INTC_HOSTU_0_MASK_HI);
       /* n903 is the only one wake up source*/
       reg = (0x1 << N903U_IRQ_NUM);
       __raw_writel(reg, intc_base + INTC_HOSTU_0_MASK_LO);
       __raw_writel(0x0, intc_base + INTC_HOSTU_0_MASK_HI);
       /*  prepare gpio info to n9 
	*  this define MUST sync with n9 code
	*/
       switch(WAKEUP_GPIO_CONTROLLER){
	       case 0:
		       reg = WAKEUP_GPIO_BASE(0);
		       break;
	       case 1:
		       reg = WAKEUP_GPIO_BASE(1);
		       break;
	       case 2:
		       reg = WAKEUP_GPIO_BASE(2);
		       break;
       }
       reg += GPIOC_INTR_ENABLE;
       __raw_writel(reg, n9_base + N9_GPIO_INFO_OFFSET);
       __raw_writel(pin, n9_base + N9_GPIO_INFO_OFFSET + 4);
       printk("reg:0x%x, pin:0x%x\n", reg, pin);
#else
       reg = readl(intc_base + 0x20);
       reg |= 0x1 << 23;
       reg |= 0x1 << 24;
       reg |= 0x1 << 25;
       __raw_writel(reg,intc_base+0x20); //enable uart
#endif

       flush_cache_all();
       ret = cpu_suspend(0, pesaro_cpu_suspend);

       return 0;
}

#ifdef CONFIG_N9_WAKEUP
static irqreturn_t n9_isr(int irq, void *dev_id)
{
	printk("ARM ISR\n");
	return IRQ_HANDLED;
}
#endif

static int pesaro_pm_prepare(void)
{
       __maybe_unused static int isInit = 1;
       __maybe_unused int virq, err;
       pr_debug("%s(%d)\n", __func__, __LINE__);

#ifdef CONFIG_N9_WAKEUP
       if (isInit) {
		/*prepare the n9 clock switch flag*/
	       n9_base = ioremap(N9_PM_BASE_ADDRESS, 0x100);
	       __raw_writel(0x0, n9_base + N9_CLK_FLAG_OFFSET);
	       virq = irq_create_mapping(NULL, N903U_IRQ_NUM);
	       err = request_irq(virq, n9_isr, IRQF_DISABLED | IRQF_TRIGGER_RISING,
			       "n9", NULL);
	       if (err)
		       pr_err("request n9 interrupt failed!\n");
	       isInit = 0;
       }
#endif

       return 0;
}

static void pesaro_pm_finish(void)
{
       __maybe_unused u32 reg;
       pr_debug("%s(%d)\n", __func__, __LINE__);
#ifdef CONFIG_N9_WAKEUP
	/* hold reset signal */
       reg = readl(sysc_base + SYSC_RST_CTRL);
       reg &= ~(0x1 << SYSC_RST_N903);
       __raw_writel(reg, sysc_base + SYSC_RST_CTRL);

       reg = readl(intc_base + INTC_HOSTU_0_MASK_LO);
       reg |= intr_mask_lo;
       reg &= ~(0x1 << N903U_IRQ_NUM);
       __raw_writel(reg, intc_base + INTC_HOSTU_0_MASK_LO);

       reg = readl(intc_base + INTC_HOSTU_0_MASK_HI);
       reg |= intr_mask_hi;
       __raw_writel(reg, intc_base + INTC_HOSTU_0_MASK_HI);
#endif
       return;
}

static const struct platform_suspend_ops pesaro_pm_ops = {
       .enter          = pesaro_pm_enter,
       .prepare        = pesaro_pm_prepare,
       .finish         = pesaro_pm_finish,
       .valid          = suspend_valid_only_mem,
};

int __init pesaro_pm_init(void)
{
       pr_debug("%s(%d)\n", __func__, __LINE__);
       intc_base = ioremap(VPL_INTC_MMR_BASE, 0x100);
       sysc_base = ioremap(VPL_SYSC_MMR_BASE, 0x100);
       suspend_set_ops(&pesaro_pm_ops);
       return 0;
}

