/*
 *  arch/arm/mach-pesaro/class.c
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/module.h>
#include <linux/device.h>
#include <linux/err.h>

static struct class *vma_class;

struct device *vma_register_device(int devno, void *drvdata, const char *fmt, ...)
{
	va_list vargs;
	struct device *dev;
	va_start(vargs, fmt);
	dev = device_create_vargs(vma_class, NULL, devno, drvdata, fmt, vargs);
	va_end(vargs);

	return dev;
}
EXPORT_SYMBOL_GPL(vma_register_device);

void vma_unregister_device(int devno)
{
	device_destroy(vma_class, devno);
}
EXPORT_SYMBOL_GPL(vma_unregister_device);

static int __init vma_class_init(void)
{
	vma_class = class_create(THIS_MODULE, "vma");
	if (IS_ERR(vma_class)) {
		pr_warn("Unable to create vma class; errno = %ld\n", PTR_ERR(vma_class));
		return PTR_ERR(vma_class);
	}
	return 0;
}

static void __exit vma_class_exit(void)
{
	class_destroy(vma_class);
}

subsys_initcall(vma_class_init);
module_exit(vma_class_exit);
MODULE_LICENSE("GPL");
