/*
 * $Header: /rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE/vma_h4cde.h 10    15/12/24 7:46p Dy.lu $
 *
 * vma_h4ee
 * Driver for VMA H4EE
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vma_h4cde.h $
 * 
 * *****************  Version 10  *****************
 * User: Dy.lu        Date: 15/12/24   Time: 7:46p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 9  *****************
 * User: Alan         Date: 15/11/27   Time: 9:18a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 8  *****************
 * User: Dy.lu        Date: 15/10/15   Time: 6:00p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 7  *****************
 * User: Aphon.wu     Date: 15/08/11   Time: 7:04p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 6  *****************
 * User: Cheng.jhu    Date: 15/07/29   Time: 10:29a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 5  *****************
 * User: Cheng.jhu    Date: 15/06/04   Time: 4:27p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 4  *****************
 * User: Jaja         Date: 15/05/28   Time: 3:36p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 3  *****************
 * User: Cheng.jhu    Date: 15/05/19   Time: 5:12p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 2  *****************
 * User: Cheng.jhu    Date: 15/03/10   Time: 11:56a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/11/19   Time: 6:03p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 5  *****************
 * User: Jaja         Date: 14/10/28   Time: 2:56p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 4  *****************
 * User: Jaja         Date: 14/10/21   Time: 5:42p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 3  *****************
 * User: Jaja         Date: 14/10/02   Time: 8:25p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 2  *****************
 * User: Jaja         Date: 14/09/22   Time: 11:01a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/09/18   Time: 7:05p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/08/01   Time: 3:40p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 19  *****************
 * User: Jaja         Date: 12/09/11   Time: 10:52a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 18  *****************
 * User: Jaja         Date: 12/09/07   Time: 8:22a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 17  *****************
 * User: Jaja         Date: 12/08/08   Time: 10:52a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 16  *****************
 * User: Jaja         Date: 12/06/20   Time: 5:54p
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 15  *****************
 * User: Jaja         Date: 12/01/11   Time: 7:02p
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 */

/* ============================================================================================== */
#ifndef __VMA_H4CDE_H__
#define __VMA_H4CDE_H__

/* ============================================================================================== */
#include <linux/ioctl.h>

#include "typedef.h"
#include "vivo_codec.h"

/* ============================================================================================== */
#define VMA_H4CDE_VERSION MAKEFOURCC(2, 0, 0, 7)
#define VMA_H4CDE_ID_VERSION "2.0.0.7"


#define VMA_H4EE_MASTER_0_BUS_NUM	2
#define VMA_H4EE_MASTER_1_BUS_NUM	1
#define VMA_H4EE_MASTER_2_BUS_NUM	1

#define VMA_H4EE_MASTER_0_MASTER_NUM	0x0A
#define VMA_H4EE_MASTER_1_MASTER_NUM	0x0A
#define VMA_H4EE_MASTER_2_MASTER_NUM	0x0B

#define VMA_H4EE_MASTER_0_BUS_BASE_ADDR	VPL_AHBC_2_MMR_BASE
#define VMA_H4EE_MASTER_1_BUS_BASE_ADDR	VPL_AHBC_1_MMR_BASE
#define VMA_H4EE_MASTER_2_BUS_BASE_ADDR	VPL_AHBC_1_MMR_BASE

/* ============================================================================================== */
typedef struct vma_h4ee_info
{
	DWORD dwVersion; // MMR 0					0
	DWORD dwCycles; // MMR 1                    4
	DWORD dwCtrl; // MMR 2                      8
	DWORD dwStat; // MMR 3                      C
	DWORD dwCodingCtrl; // MMR 4                10
	DWORD dwYCurrAddr; // MMR 5                 14
	DWORD dwCbCurrAddr; // MMR 6                18
	DWORD dwCrCurrAddr; // MMR 7                1C
	DWORD dwLumaDeblockAddr; // MMR 8           20
	DWORD dwChmaDeblockAddr; // MMR 9           24
	DWORD dwLumaFwdRef0Addr; // MMR 10          28
	DWORD dwChmaFwdRef0Addr; // MMR 11          2C
	DWORD dwLumaFwdRef1Addr; // MMR 12          30
	DWORD dwChmaFwdRef1Addr; // MMR 13          34
	DWORD dwMBInfoAddr; // MMR 14               38
	DWORD dwBSLowBoundAddr; // MMR 15           3C
	DWORD dwBSUpBoundAddr; // MMR 16            40
	DWORD dwCMTblAddr; // MMR 17                44
	DWORD dwIntraPredAddr; // MMR 18            48
	DWORD dwMBNumInfo; // MMR 19                4C
	DWORD dwSizeInfo; // MMR 20                 50
	DWORD dwQuantInfo; // MMR 21                54
	DWORD dwBSSizeInfo; // MMR 22               58
	DWORD dwPrevSliceInfo0; // MMR 23           5C
	DWORD dwPrevSliceInfo1; // MMR 24           60
	DWORD dwPrevSliceInfo2; // MMR 25           64
	DWORD dwPrevSliceInfo3; // MMR 26           68
	DWORD dwUnalignMSBs; // MMR 27              6C
	DWORD dwUnalignLSBs; // MMR 28              70
	DWORD dwBinsCnt; // MMR 29                  74
	DWORD dwCoeffCost; // MMR 30                78
	DWORD dwMEBECodingCtrl; // MMR 31			7C
	DWORD dwMEBEVLCOutAddr; // MMR 32           80
	DWORD dwMEBETblAddr; // MMR 33              84
	DWORD dwMEBEMBNum; // MMR 34                88
	DWORD dwMEBEWidthBuffSize; // MMR 35        8C
	DWORD dwMEBEQuantBuffSize; // MMR 36        90
	DWORD dwMEBEVPPacketSize; // MMR 37         94
	DWORD dwMEBEVPInfoVPNum; // MMR 38          98
	DWORD dwMEBEVPHdrInfo; // MMR 39            9C
	DWORD dwMEBEVPExtHdrInfo; // MMR 40         A0
	DWORD dwIntraPredModeEnCtrl; // MMR 41      A4
	DWORD dwMBRefreshInfo; // MMR 42            A8
	DWORD dwFmeBlkDisCtrl; // MMR 43            AC
	DWORD dwLambdaQModeCost; // MMR 44          B0
	DWORD dwObjectInfoAddr; // MMR 45           B4
	DWORD dwObjectInfoReserve; // MMR 46        B8
	DWORD dwObjectMBsStride; // MMR 47          BC
	DWORD dwDeblocAhbTsfConfig; // MMR 48       C0
	DWORD dwH4eeConfigInfo0; // MMR 49          C4
	DWORD dwH4eeConfigInfo1; // MMR 50          C8
	DWORD dwH4eeConfigInfo2; // MMR 51          CC
	DWORD dwH4eeConfigInfo3; // MMR 52          D0
	DWORD dwH4eeConfigInfo4; // MMR 53          D4
	DWORD dwH4eeConfigInfo5; // MMR 54			D8
	DWORD dwColIntraRefresh0Info; // MMR 55     DC
	DWORD dwColIntraRefresh1Info; // MMR 56     E0
	DWORD dwCMTblAddr2; // MMR 57               E4
	DWORD dwIntraPredAddr2; // MMR 58           E8
	DWORD dwLumaUpDeblockAddr2; // MMR 59       EC
	DWORD dwMozartV3CodingCtrl; // MMR 60       F0
	DWORD dwMozartV3MeSadThr; // MMR 61         F4
	DWORD dwMozartV3MeMvFactor; // MMR 62       F8
	DWORD dwMozartV3BndBoxQpd0; // MMR 63       FC
	DWORD dwMozartV3BndBoxQpd1; // MMR 64       100
	DWORD dwMozartV3InBndBoxMode; // MMR 65     104
	DWORD dwMozartV3OutBndBoxMode; // MMR 66    108
	DWORD dwCarApp00; // MMR 67          		10C
	DWORD dwCarApp01; // MMR 68          		110
	DWORD dwCarApp02; // MMR 69             	114
	DWORD dwCarApp03; // MMR 70					118
	DWORD dwDecodingInfo; // MMR 71             11C
	DWORD dwIntraPredModeEnCtrl2; // MMR 72     120
	DWORD dwRecRefStride; // MMR 73     		124
	DWORD dwExChmrDblkUpAddr; // MMR 74         128
	DWORD dwChmrDeblockAddr; // MMR 75          12C
	DWORD dwChmrFwdRef0Addr; // MMR 76			130
	DWORD dwChmrFwdRef1Addr; // MMR 77          134
	DWORD dwMeDisableTbl; // MMR 78             138
	DWORD dwMeDisableTbl2; // MMR 79            13C
	DWORD adwObjBndBoxInfo[32];//80,81,82,83,84,85,86,87,88,89			// start 140
	                           //90,91,92,93,94,95,96,97,98,99
	                           //100,101,102,103,104,105,106,107,108,109
	                           //110,111
	DWORD dwConfigCycleUsed; // MMR 112	//1C0
	DWORD dwTemp00;				// MMR 113
	DWORD dwTemp01;				// MMR 114

	DWORD dwOsdCurrLumaAddr;					// MMR 115
	DWORD dwOsdCurrChmaAddr;					// MMR 116
	DWORD dwOsdCurrChmrAddr;					// MMR 117
	DWORD dwOsdSizeInfo;				// MMR 118
	DWORD dwOsdStrideInfo;				// MMR 119
} TVMAH4EEInfo;

typedef struct vma_h4de_info
{
	DWORD dwVersion; // MMR 0
	DWORD dwCycles; // MMR 1
	DWORD dwCtrl; // MMR 2
	DWORD dwStat; // MMR 3
	DWORD dwLumaCurrAddr; // MMR 4
	DWORD dwChromaCurrAddr; // MMR 5
	DWORD dwBlockCurrAddr; // MMR 6
	DWORD dwAHBAccessMBNum; // MMR 7
	DWORD dwMBInfoAddr; // MMR 8
	DWORD dwColMBInfoAddr; // MMR 9
	DWORD dwList0RefAddr00; // MMR 10
	DWORD dwList0RefAddr01; // MMR 11
	DWORD dwList0RefAddr02; // MMR 12
	DWORD dwList0RefAddr03; // MMR 13
	DWORD dwList0RefAddr04; // MMR 14
	DWORD dwList0RefAddr05; // MMR 15
	DWORD dwList0RefAddr06; // MMR 16
	DWORD dwList0RefAddr07; // MMR 17
	DWORD dwList0RefAddr08; // MMR 18
	DWORD dwList0RefAddr09; // MMR 19
	DWORD dwList0RefAddr10; // MMR 20
	DWORD dwList0RefAddr11; // MMR 21
	DWORD dwList0RefAddr12; // MMR 22
	DWORD dwList0RefAddr13; // MMR 23
	DWORD dwList0RefAddr14; // MMR 24
	DWORD dwList0RefAddr15; // MMR 25
	DWORD dwList1RefAddr00; // MMR 26
	DWORD dwList1RefAddr01; // MMR 27
	DWORD dwList1RefAddr02; // MMR 28
	DWORD dwList1RefAddr03; // MMR 29
	DWORD dwList1RefAddr04; // MMR 30
	DWORD dwList1RefAddr05; // MMR 31
	DWORD dwList1RefAddr06; // MMR 32
	DWORD dwList1RefAddr07; // MMR 33
	DWORD dwList1RefAddr08; // MMR 34
	DWORD dwList1RefAddr09; // MMR 35
	DWORD dwList1RefAddr10; // MMR 36
	DWORD dwList1RefAddr11; // MMR 37
	DWORD dwList1RefAddr12; // MMR 38
	DWORD dwList1RefAddr13; // MMR 39
	DWORD dwList1RefAddr14; // MMR 40
	DWORD dwList1RefAddr15; // MMR 41
	DWORD dwList1ColMBInfoAddr; // MMR 42
	DWORD dwIntraDepredAddr; // MMR 43
	DWORD dwDeblockAddr; // MMR 44
	DWORD dwBSCtrl; // MMR 45
	DWORD dwBSCurrAddr; // MMR 46
	DWORD dwBSValidSize; // MMR 47
	DWORD dwBSLowBoundAddr; // MMR 48
	DWORD dwBSUpBoundAddr; // MMR 49
	DWORD dwBSDecSize; // MMR 50
	DWORD dwCMTblAddr; // MMR 51
	DWORD dwWeightScaleTblAddr; // MMR 52
	DWORD dwPredWeightTblAddr; // MMR 53
	DWORD dwFrameSizeInfo0; // MMR 54
	DWORD dwFrameSizeInfo1; // MMR 55
	DWORD dwCrCurrAddr; // MMR 56
	DWORD dwOPCycleLimitation; // MMR 57
	DWORD dwSPSInfo; // MMR 58
	DWORD dwPPSInfo; // MMR 59
	DWORD dwSliceInfo00; // MMR 60
	DWORD dwSliceInfo01; // MMR 61
	DWORD dwSliceInfo02; // MMR 62
	DWORD dwSliceInfo03; // MMR 63
	DWORD dwSliceInfo04; // MMR 64
	DWORD dwSliceInfo05; // MMR 65
	DWORD dwSliceInfo06; // MMR 66
	DWORD dwSliceInfo07; // MMR 67
	DWORD dwSliceInfo08; // MMR 68
	DWORD dwSliceInfo09; // MMR 69
	DWORD dwSliceInfo10; // MMR 70
	DWORD dwLTInfo; // MMR 71
	DWORD dwCurrL0RefIdxPOC00; // MMR 72
	DWORD dwCurrL0RefIdxPOC01; // MMR 73
	DWORD dwCurrL0RefIdxPOC02; // MMR 74
	DWORD dwCurrL0RefIdxPOC03; // MMR 75
	DWORD dwCurrL0RefIdxPOC04; // MMR 76
	DWORD dwCurrL0RefIdxPOC05; // MMR 77
	DWORD dwCurrL0RefIdxPOC06; // MMR 78
	DWORD dwCurrL0RefIdxPOC07; // MMR 79
	DWORD dwCurrL0RefIdxPOC08; // MMR 80
	DWORD dwCurrL0RefIdxPOC09; // MMR 81
	DWORD dwCurrL0RefIdxPOC10; // MMR 82
	DWORD dwCurrL0RefIdxPOC11; // MMR 83
	DWORD dwCurrL0RefIdxPOC12; // MMR 84
	DWORD dwCurrL0RefIdxPOC13; // MMR 85
	DWORD dwCurrL0RefIdxPOC14; // MMR 86
	DWORD dwCurrL0RefIdxPOC15; // MMR 87
	DWORD dwCurrL1RefIdxPOC00; // MMR 88
	DWORD dwCurrL1RefIdxPOC01; // MMR 89
	DWORD dwCurrL1RefIdxPOC02; // MMR 90
	DWORD dwCurrL1RefIdxPOC03; // MMR 91
	DWORD dwCurrL1RefIdxPOC04; // MMR 92
	DWORD dwCurrL1RefIdxPOC05; // MMR 93
	DWORD dwCurrL1RefIdxPOC06; // MMR 94
	DWORD dwCurrL1RefIdxPOC07; // MMR 95
	DWORD dwCurrL1RefIdxPOC08; // MMR 96
	DWORD dwCurrL1RefIdxPOC09; // MMR 97
	DWORD dwCurrL1RefIdxPOC10; // MMR 98
	DWORD dwCurrL1RefIdxPOC11; // MMR 99
	DWORD dwCurrL1RefIdxPOC12; // MMR 100
	DWORD dwCurrL1RefIdxPOC13; // MMR 101
	DWORD dwCurrL1RefIdxPOC14; // MMR 102
	DWORD dwCurrL1RefIdxPOC15; // MMR 103
	DWORD dwIOVectorStartAddr; // MMR 104
	DWORD dwIOVectorEndAddr; // MMR 105
	DWORD dwEmpty[6];//MMR
	DWORD dwConfigCycleUsed;
} TVMAH4DEInfo;

/* ============================================================================================== */
#define VMA_H4EE_IOC_MAGIC 219

#define VMA_H4EE_IOC_START						_IOW	(VMA_H4EE_IOC_MAGIC, 0, DWORD)
#define VMA_H4EE_IOC_WAIT_COMPLETE				_IO		(VMA_H4EE_IOC_MAGIC, 1)
#define VMA_H4EE_IOC_SHARE_MMR_INFO_SPACE		_IOW	(VMA_H4EE_IOC_MAGIC, 2, DWORD)
#define VMA_H4EE_IOC_GET_VERSION_NUMBER			_IOR	(VMA_H4EE_IOC_MAGIC, 3, DWORD)
#define VMA_H4EE_IOC_GET_CHIP_VERSION_NUMBER	_IOR	(VMA_H4EE_IOC_MAGIC, 4, DWORD)
#define VMA_H4EE_IOC_MASTER_0_GET_BANDWIDTH		_IOR	(VMA_H4EE_IOC_MAGIC, 5, DWORD)
#define VMA_H4EE_IOC_MASTER_0_GET_RG_INTERVAL	_IOR	(VMA_H4EE_IOC_MAGIC, 6, DWORD)
#define VMA_H4EE_IOC_MASTER_0_GET_REQ_TIMES		_IOR	(VMA_H4EE_IOC_MAGIC, 7, DWORD)
#define VMA_H4EE_IOC_MASTER_0_CLEAR_PROFILE		_IO		(VMA_H4EE_IOC_MAGIC, 8)
#define VMA_H4EE_IOC_MASTER_1_GET_BANDWIDTH		_IOR	(VMA_H4EE_IOC_MAGIC, 9, DWORD)
#define VMA_H4EE_IOC_MASTER_1_GET_RG_INTERVAL	_IOR	(VMA_H4EE_IOC_MAGIC, 10, DWORD)
#define VMA_H4EE_IOC_MASTER_1_GET_REQ_TIMES		_IOR	(VMA_H4EE_IOC_MAGIC, 11, DWORD)
#define VMA_H4EE_IOC_MASTER_1_CLEAR_PROFILE		_IO		(VMA_H4EE_IOC_MAGIC, 12)
#define VMA_H4EE_IOC_MASTER_2_GET_BANDWIDTH		_IOR	(VMA_H4EE_IOC_MAGIC, 13, DWORD)
#define VMA_H4EE_IOC_MASTER_2_GET_RG_INTERVAL	_IOR	(VMA_H4EE_IOC_MAGIC, 14, DWORD)
#define VMA_H4EE_IOC_MASTER_2_GET_REQ_TIMES		_IOR	(VMA_H4EE_IOC_MAGIC, 15, DWORD)
#define VMA_H4EE_IOC_MASTER_2_CLEAR_PROFILE		_IO		(VMA_H4EE_IOC_MAGIC, 16)
#define VMA_H4EE_IOC_MASTER_3_GET_BANDWIDTH		_IOR	(VMA_H4EE_IOC_MAGIC, 17, DWORD)
#define VMA_H4EE_IOC_MASTER_3_GET_RG_INTERVAL	_IOR	(VMA_H4EE_IOC_MAGIC, 18, DWORD)
#define VMA_H4EE_IOC_MASTER_3_GET_REQ_TIMES		_IOR	(VMA_H4EE_IOC_MAGIC, 19, DWORD)
#define VMA_H4EE_IOC_MASTER_3_CLEAR_PROFILE		_IO		(VMA_H4EE_IOC_MAGIC, 20)
#define VMA_H4EE_IOC_RESET						_IO		(VMA_H4EE_IOC_MAGIC, 21)
#define VMA_H4EE_IOC_H4DE_SHARE_MMR_INFO_SPACE	_IOW	(VMA_H4EE_IOC_MAGIC, 22, DWORD)
#define VMA_H4EE_IOC_GET_CHIP_MODEL_INFO    	_IOR	(VMA_H4EE_IOC_MAGIC, 23, DWORD)

#define VMA_H4EE_IOC_MAX_NUMBER	23

/* ============================================================================================== */
#endif //__VMA_H4CDE_H__

/* ============================================================================================== */
