/*
 * $Header: /rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE/vma_h4cde_driver.c 7     15/12/24 7:46p Dy.lu $
 *
 * vma_h4ee
 * Driver for VMA H4EE
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vma_h4cde_driver.c $
 * 
 * *****************  Version 7  *****************
 * User: Dy.lu        Date: 15/12/24   Time: 7:46p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 6  *****************
 * User: Alan         Date: 15/11/27   Time: 9:18a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * BUG: mutex_unlock() in Open() should be placed after try_module_get() -
 * FIXED.
 * MODIFICATION: initialize ptObjInfo->ptMMRInfo and
 * ptObjInfo->ptMMRDecInfo to NULL in Open() - DONE.
 * 
 * *****************  Version 5  *****************
 * User: Dy.lu        Date: 15/10/15   Time: 6:00p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 4  *****************
 * User: Cheng.jhu    Date: 15/06/04   Time: 4:27p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 3  *****************
 * User: Cheng.jhu    Date: 15/03/10   Time: 3:23p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 2  *****************
 * User: Cheng.jhu    Date: 15/03/10   Time: 11:56a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/11/19   Time: 6:03p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 2  *****************
 * User: Jaja         Date: 14/09/22   Time: 11:01a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/09/18   Time: 7:05p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * 
 * *****************  Version 3  *****************
 * User: Jaja         Date: 14/08/21   Time: 11:49a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/08/01   Time: 3:40p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 6  *****************
 * User: Jaja         Date: 12/09/11   Time: 10:52a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 5  *****************
 * User: Jaja         Date: 12/09/07   Time: 8:35a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 4  *****************
 * User: Jaja         Date: 12/09/07   Time: 8:23a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 3  *****************
 * User: Jaja         Date: 12/08/08   Time: 10:52a
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 2  *****************
 * User: Jaja         Date: 12/06/20   Time: 5:54p
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 12/01/11   Time: 7:03p
 * Created in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 */

/* ============================================================================================== */
#ifndef __KERNEL__
	#define __KERNEL__
#endif //!__KERNEL__

#ifndef MODULE
//	#define MODULE
#endif //!MODULE

#ifndef MODULE
	static int OtusOpenCnt = 0;
#endif

/* ============================================================================================== */
#include <asm/cacheflush.h>
#include <linux/dma-mapping.h>
#include "vma_h4cde_driver.h"

/* ============================================================================================== */
const CHAR VMA_H4EE_ID[] = "$Version: "VMA_H4CDE_ID_VERSION"  (VMA_H4EE) $";
static TVMAH4EESharedInfo *gptSharedInfo = NULL;
static SDWORD gsdwMajor = 0;

/* ============================================================================================== */
MODULE_AUTHOR ("VATICS Inc.");
MODULE_LICENSE ("GPL");
module_param (gsdwMajor, int, 0644);
MODULE_PARM_DESC (gsdwMajor, "Major number for VMA_H4EE module");

#ifdef __USE_SWAIT__
#warning "Use Simple Wait Queue!"
#endif

/* ============================================================================================== */
static irqreturn_t ISR(int irq, void *dev_id)
{
	DWORD dwReadIndex = VMA_H4EE_ISR(gptSharedInfo->hDevInfo);

	gptSharedInfo->abIntr[dwReadIndex] = TRUE;
#ifdef __USE_SWAIT__
	swake_up(&gptSharedInfo->atWaitQueueHead[dwReadIndex]);
#else
	wake_up(&gptSharedInfo->atWaitQueueHead[dwReadIndex]);
#endif

	return IRQ_HANDLED;
}

/* ============================================================================================== */
static SCODE Start(TVMAH4EEObjInfo *ptObjInfo)
{
	DWORD dwWriteIndex;

	dwWriteIndex = VMA_H4EE_StartHead(gptSharedInfo->hDevInfo);

	if (gptSharedInfo->abWriteEn[dwWriteIndex])
	{
		gptSharedInfo->abWriteEn[dwWriteIndex] = FALSE;

		ptObjInfo->dwWriteIndex = dwWriteIndex;
		//printk("ptObjInfo->dwWriteIndex = %d \n", ptObjInfo->dwWriteIndex);

		//VMA_H4EE_StartTail(gptSharedInfo->hDevInfo, dwWriteIndex, ptObjInfo->ptMMRInfo);
		VMA_H4EE_StartTail(gptSharedInfo->hDevInfo, dwWriteIndex, ptObjInfo);

		return S_OK;
	}
	return S_FAIL;
}

/* ============================================================================================== */
static void WaitComplete(TVMAH4EEObjInfo *ptObjInfo)
{
	DWORD dwWriteIndex;

	PDEBUG("Enter WaitComplete function...\n");

	dwWriteIndex = ptObjInfo->dwWriteIndex;
#ifdef __USE_SWAIT__
	swait_event(gptSharedInfo->atWaitQueueHead[dwWriteIndex], (gptSharedInfo->abIntr[dwWriteIndex]==TRUE));
#else
	wait_event(gptSharedInfo->atWaitQueueHead[dwWriteIndex], (gptSharedInfo->abIntr[dwWriteIndex]==TRUE));
#endif

	gptSharedInfo->abIntr[dwWriteIndex] = FALSE;

	gptSharedInfo->abWriteEn[dwWriteIndex] = TRUE;
	ptObjInfo->dwWriteIndex = 0xFFFFFFFF;
#ifdef __PROFILE__
	VMA_H4EE_GetProfileInfo(gptSharedInfo->hDevInfo, ptObjInfo, dwWriteIndex);
#endif

	PDEBUG("Exit WaitComplete function !!\n");
}

/* ============================================================================================== */
static int Close(struct inode *pinode, struct file *pfile)
{
	TVMAH4EEObjInfo *ptObjInfo = (TVMAH4EEObjInfo *)pfile->private_data;

	PDEBUG("Enter Close function...\n");

	if (ptObjInfo != NULL)
	{
		if (ptObjInfo->dwWriteIndex != 0xFFFFFFFF)
		{
			while (1)
			{
				if (gptSharedInfo->abIntr[ptObjInfo->dwWriteIndex] == TRUE)
				{
					break;
				}
			}
			gptSharedInfo->abIntr[ptObjInfo->dwWriteIndex] = FALSE;
			gptSharedInfo->abWriteEn[ptObjInfo->dwWriteIndex] = TRUE;
		}

		if (ptObjInfo->ptMMRInfo != NULL)
		{
			iounmap(ptObjInfo->ptMMRInfo);
		    release_mem_region(ptObjInfo->dwMMRInfoPhyAddr, (ptObjInfo->bEnc)? sizeof(TVMAH4EEInfo):sizeof(TVMAH4DEInfo));
        }
        
		kfree(ptObjInfo);

		pfile->private_data = NULL;
	}

	mutex_lock(&gptSharedInfo->ioctl_lock);
#ifdef MODULE
	module_put(THIS_MODULE);

	if (module_refcount(THIS_MODULE) == 0)
#else
	if ((OtusOpenCnt > 0) && (--OtusOpenCnt == 0))
#endif
	{
	    clk_enable(gptSharedInfo->pClk);
        
		VMA_H4EE_IntrClear(gptSharedInfo->hDevInfo);
		VMA_H4EE_IntrDisable(gptSharedInfo->hDevInfo);

		if (gptSharedInfo->dwIrq != (DWORD)NULL)
		{
		    free_irq(gptSharedInfo->dwIrq, gptSharedInfo);
		    //free_irq(VMA_H4EE_IRQ_NUM, gptSharedInfo);
		}

		gptSharedInfo->dwIrq = (DWORD)NULL;
	    clk_disable(gptSharedInfo->pClk);
	}
	mutex_unlock(&gptSharedInfo->ioctl_lock);

	PDEBUG("Exit Close function !!\n");

	return 0;
}

/* ============================================================================================== */
static int Open(struct inode *pinode, struct file *pfile)
{
	TVMAH4EEObjInfo *ptObjInfo;
	int scResult;
	DWORD i;
	int virq;

	PDEBUG("Enter Open function...\n");

	mutex_lock(&gptSharedInfo->ioctl_lock);
#ifdef MODULE
	i = module_refcount(THIS_MODULE);
#else
	i = OtusOpenCnt;
#endif
	if (i == VMA_H4EE_MMR_BUFF_NUM)
	{
		printk("[vma_h4cde]: only support %d handles\n", VMA_H4EE_MMR_BUFF_NUM);
		mutex_unlock(&gptSharedInfo->ioctl_lock);
		return -EFAULT;
	}

	if (pfile->private_data == NULL)
	{
		if ((pfile->private_data=(TVMAH4EEObjInfo *)kmalloc(sizeof(TVMAH4EEObjInfo), GFP_KERNEL)) == NULL)
		{
			PDEBUG("Insufficient kernel memory space !!\n");
			PDEBUG("Exit Open function !!\n");
			mutex_unlock(&gptSharedInfo->ioctl_lock);
			return -ENOMEM;
		}

		ptObjInfo = (TVMAH4EEObjInfo *)pfile->private_data;
		ptObjInfo->dwWriteIndex = 0xFFFFFFFF;
		ptObjInfo->ptMMRInfo = NULL;
#ifdef __PROFILE__
		if (VMA_H4EE_InitProfileInfo(ptObjInfo) != S_OK)
		{
			PDEBUG("Fail to initialize profile info !!\n");
			PDEBUG("Exit Open function !!\n");
			mutex_unlock(&gptSharedInfo->ioctl_lock);
			return -EFAULT;
		}
#endif
	}
	else
	{
		PDEBUG("Exit Open function !!\n");
		mutex_unlock(&gptSharedInfo->ioctl_lock);
		return -EBUSY;
	}

	if (i == 0)
	{
		clk_enable(gptSharedInfo->pClk);
        
		//VMA_H4EE_Reset(gptSharedInfo->hDevInfo);
		if (gptSharedInfo->dwIrq == (DWORD)NULL)
		{
			VMA_H4EE_IntrDisable(gptSharedInfo->hDevInfo);

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
			scResult = request_irq(VMA_H4EE_IRQ_NUM, &ISR, SA_INTERRUPT, "vma_h4ee", gptSharedInfo);
#else
			virq = irq_create_mapping(NULL, VMA_H4EE_IRQ_NUM);
			scResult = request_irq(virq, &ISR, IRQF_DISABLED | IRQF_TRIGGER_HIGH, "vma_h4ee", gptSharedInfo);
#endif

			if (scResult < 0)
			{
				PDEBUG("Cannot get irq %d !!\n", VMA_H4EE_IRQ_NUM);
				mutex_unlock(&gptSharedInfo->ioctl_lock);
				Close(pinode, pfile);
				PDEBUG("Exit Open function !!\n");
				return scResult;
			}

			gptSharedInfo->dwIrq = virq;
			disable_irq(gptSharedInfo->dwIrq);
			enable_irq(gptSharedInfo->dwIrq);

			VMA_H4EE_IntrClear(gptSharedInfo->hDevInfo);
			VMA_H4EE_IntrEnable(gptSharedInfo->hDevInfo);

			VMA_H4EE_Open(gptSharedInfo->hDevInfo);

			for (i=0; i<VMA_H4EE_MMR_BUFF_NUM; i++)
			{
#ifdef __USE_SWAIT__
				init_swait_queue_head(&gptSharedInfo->atWaitQueueHead[i]);
#else
				init_waitqueue_head(&gptSharedInfo->atWaitQueueHead[i]);
#endif
				gptSharedInfo->abIntr[i] = FALSE;
				gptSharedInfo->abWriteEn[i] = TRUE;
			}
		}
		clk_disable(gptSharedInfo->pClk);
	}

#ifdef MODULE
	scResult = (try_module_get(THIS_MODULE) == 1)? 0:-EBUSY;
#else
	OtusOpenCnt++;
	scResult = 0;
#endif
	mutex_unlock(&gptSharedInfo->ioctl_lock);

	return scResult;
}

/* ============================================================================================== */
static long Ioctl(struct file *pfile, unsigned int dwCmd, unsigned long dwArg)
//static int Ioctl(struct inode *pinode, struct file *pfile, unsigned int dwCmd, unsigned long dwArg)
{
	TVMAH4EEObjInfo *ptObjInfo = (TVMAH4EEObjInfo *)pfile->private_data;
	DWORD dwVersionNum;
	int scError;
	CHAR acMemRegionName[16];

	PDEBUG("Enter Ioctl function...\n");
	
    //mutex_lock(&gptSharedInfo->ioctl_lock);
	
	if (pfile->private_data == NULL)
	{
		PDEBUG("Device does not exist !!\n");
		PDEBUG("Exit Ioctl function !!\n");
		//mutex_unlock(&gptSharedInfo->ioctl_lock);
		return -ENODEV;
	}

	if ((_IOC_TYPE(dwCmd)!=VMA_H4EE_IOC_MAGIC) || (_IOC_NR(dwCmd)>VMA_H4EE_IOC_MAX_NUMBER))
	{
		PDEBUG("Incorrect ioctl command !!\n");
		PDEBUG("Exit Ioctl function !!\n");
        //mutex_unlock(&gptSharedInfo->ioctl_lock);
		return -ENOTTY;
	}

	if (_IOC_DIR(dwCmd) & _IOC_READ)
	{
		scError = !access_ok(VERIFY_WRITE, (void *)dwArg, _IOC_SIZE(dwCmd));
	}
	else if (_IOC_DIR(dwCmd) & _IOC_WRITE)
	{
		scError = !access_ok(VERIFY_READ, (void *)dwArg, _IOC_SIZE(dwCmd));
	}
	else
	{
		scError = 0;
	}

	if (scError != 0)
	{
		PDEBUG("Unsupport ioctl command %d !!\n", dwCmd);
		PDEBUG("Exit Ioctl function !!\n");
        //mutex_unlock(&gptSharedInfo->ioctl_lock);
		return -EFAULT;
	}

	switch (dwCmd)
	{
		case VMA_H4EE_IOC_START:
			mutex_lock(&gptSharedInfo->ioctl_lock);
			if (Start(ptObjInfo) != S_OK)
			{
				PDEBUG("Exit Ioctl function !!\n");
				scError = S_FAIL;
				dwArg = TRUE;
			}
			mutex_unlock(&gptSharedInfo->ioctl_lock);
		if (dwArg)
			break;
		case VMA_H4EE_IOC_WAIT_COMPLETE:
			WaitComplete(ptObjInfo);
			/* TODO: Maybe another leak for official SDK */
			dmac_map_area(ptObjInfo->ptMMRInfo, (ptObjInfo->bEnc)? sizeof(TVMAH4EEInfo):sizeof(TVMAH4DEInfo), DMA_BIDIRECTIONAL);
		break;
		case VMA_H4EE_IOC_SHARE_MMR_INFO_SPACE:
			ptObjInfo->bEnc = TRUE;
			ptObjInfo->dwMMRInfoPhyAddr = dwArg;
			sprintf(acMemRegionName, "%d", (int)ptObjInfo->dwMMRInfoPhyAddr);
			request_mem_region(ptObjInfo->dwMMRInfoPhyAddr, sizeof(TVMAH4EEInfo), acMemRegionName);
			ptObjInfo->ptMMRInfo = (TVMAH4EEInfo *)ioremap_cached((int)ptObjInfo->dwMMRInfoPhyAddr, sizeof(TVMAH4EEInfo));
		break;
		case VMA_H4EE_IOC_H4DE_SHARE_MMR_INFO_SPACE:
			ptObjInfo->bEnc = FALSE;
			ptObjInfo->dwMMRInfoPhyAddr = dwArg;
			sprintf(acMemRegionName, "%d", (int)ptObjInfo->dwMMRInfoPhyAddr);
			request_mem_region(ptObjInfo->dwMMRInfoPhyAddr, sizeof(TVMAH4DEInfo), acMemRegionName);
			ptObjInfo->ptMMRInfo = (TVMAH4DEInfo *)ioremap_cached((int)ptObjInfo->dwMMRInfoPhyAddr, sizeof(TVMAH4DEInfo));
		break;
		case VMA_H4EE_IOC_GET_VERSION_NUMBER:
			dwVersionNum = VMA_H4CDE_VERSION;
			scError = copy_to_user((DWORD *)dwArg, &dwVersionNum, sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				scError = -EFAULT;
			}
			//copy_to_user((DWORD *)dwArg, &dwVersionNum, sizeof(DWORD));
		break;
		case VMA_H4EE_IOC_GET_CHIP_VERSION_NUMBER:
			scError = copy_to_user((DWORD *)dwArg, (DWORD *)IO_ADDRESS(VPL_SYSC_MMR_BASE), sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				scError = -EFAULT;
			}
		break;		
		case VMA_H4EE_IOC_GET_CHIP_MODEL_INFO:
		                                                                                // MMR 48
            scError = copy_to_user((DWORD *)dwArg, (DWORD *)(IO_ADDRESS(VPL_SYSC_MMR_BASE)+0xC0), sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				scError = -EFAULT;
			}
		break;
#ifdef __PROFILE__
		case VMA_H4EE_IOC_MASTER_0_GET_BANDWIDTH:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_0_GET_RG_INTERVAL:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_0_GET_REQ_TIMES:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_0_CLEAR_PROFILE:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_BANDWIDTH:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_RG_INTERVAL:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_REQ_TIMES:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_1_CLEAR_PROFILE:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_BANDWIDTH:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_RG_INTERVAL:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_REQ_TIMES:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_2_CLEAR_PROFILE:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_3_GET_BANDWIDTH:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_3_GET_RG_INTERVAL:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_3_GET_REQ_TIMES:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
		case VMA_H4EE_IOC_MASTER_3_CLEAR_PROFILE:
			VMA_H4EE_SetupProfile(ptObjInfo, dwArg, dwCmd);
		break;
#endif
		case VMA_H4EE_IOC_RESET:
		    //writel(readl(SYSC_CLK_EN_MMR)|(0x1<<VMA_H4EE_CLK_EN_NUM), SYSC_CLK_EN_MMR);
			mutex_lock(&gptSharedInfo->ioctl_lock);
		    clk_enable(gptSharedInfo->pClk);
			VMA_H4EE_Reset(gptSharedInfo->hDevInfo);
		    //writel(readl(SYSC_CLK_EN_MMR)&(~(0x1<<VMA_H4EE_CLK_EN_NUM)), SYSC_CLK_EN_MMR);
		    clk_disable(gptSharedInfo->pClk);
			mutex_unlock(&gptSharedInfo->ioctl_lock);
		break;
		default:
			PDEBUG("Exit Ioctl function !!\n");
			scError = -ENOTTY;
	}

	PDEBUG("Exit Ioctl function !!\n");

	//mutex_unlock(&gptSharedInfo->ioctl_lock);
	return scError;
}

/* ============================================================================================== */
/*static int MMap(struct file *file, struct vm_area_struct *vma)
{
	DWORD dwSize;

	dwSize = vma->vm_end - vma->vm_start;

	vma->vm_page_prot = pgprot_noncached(vma->vm_page_prot);
	vma->vm_flags |= VM_DONTEXPAND | VM_DONTDUMP;

	if (remap_pfn_range(vma, vma->vm_start, (VMA_H4EE_MMR_BASE>>PAGE_SHIFT), dwSize, vma->vm_page_prot))
	{
		return -EAGAIN;
	}

	PDEBUG("Start address = 0x%08lX, end address = 0x%08lX\n", vma->vm_start, vma->vm_end);

	return 0;
}*/

/* ============================================================================================== */
struct file_operations vma_h4ee_fops =
{
 	unlocked_ioctl:		Ioctl,
 	//mmap:				MMap,
 	open:				Open,
 	release:			Close,
};

/* ============================================================================================== */
static void CleanupModule(void)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
	int scResult;
#endif
	TVMAH4EEInfo *ptMMRInfo;

	PDEBUG("Enter CleanupModule function...\n");

	if (gptSharedInfo != NULL)
	{
		if (gptSharedInfo->hDevInfo != NULL)
		{
			if (gsdwMajor != 0)
			{
			    vma_unregister_device(MKDEV(gsdwMajor, 0));

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
				scResult = unregister_chrdev(gsdwMajor, "vma_h4ee");

				if (scResult < 0)
				{
					PDEBUG("Cannot release major number %d !!\n", (int)gsdwMajor);
					PDEBUG("Exit CleanupModule function !!\n");
					return;
				}
#else
				unregister_chrdev(gsdwMajor, "vma_h4ee");
#endif
			}

#ifdef __PROFILE__
			VMA_H4EE_CloseProfile(gptSharedInfo->hDevInfo);
#endif
			ptMMRInfo = (TVMAH4EEInfo *)VMA_H4EE_GetMMRInfo(gptSharedInfo->hDevInfo);

			if (ptMMRInfo != NULL)
			{
				iounmap(ptMMRInfo);
				release_mem_region(VMA_H4EE_MMR_BASE, sizeof(TVMAH4EEInfo));
			}
            
			kfree(gptSharedInfo->hDevInfo);
		}
		
        if (!IS_ERR(gptSharedInfo->pClk))
		{
			clk_unprepare(gptSharedInfo->pClk);
			clk_put(gptSharedInfo->pClk);
		}

		kfree(gptSharedInfo);
	}

	PDEBUG("Exit CleanupModule function !!\n");

	return;
}

/* ============================================================================================== */
static int InitialModule(void)
{
	int scResult;
	
	DWORD dwDevInfoSize, dwVersionNum;
#ifdef __ASM_ARCH_PLATFORM_PESARO_H__
	DWORD dwSize = (sizeof(TVMAH4EEInfo)>sizeof(TVMAH4DEInfo)) ? sizeof(TVMAH4EEInfo) : sizeof(TVMAH4DEInfo);
	volatile TVMAH4EEInfo *ptMMRInfo = (TVMAH4EEInfo *)ioremap((int)VMA_H4EE_MMR_BASE, dwSize);	
	//volatile DWORD *pdwClkEnMmr = (DWORD *)(IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x94);
    volatile DWORD *pdwRstEnMmr = (DWORD *)(IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x24);
#else //!__ASM_ARCH_PLATFORM_PESARO_H__
	volatile TVMAH4EEInfo *ptMMRInfo = (TVMAH4EEInfo *)ioremap((int)VMA_H4EE_MMR_BASE, sizeof(TVMAH4EEInfo));
	volatile DWORD *pdwClkEnMmr = (DWORD *)(IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x74);
    //volatile DWORD *pdwRstEnMmr = (DWORD *)(IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x??);
#endif //__ASM_ARCH_PLATFORM_PESARO_H__

	PDEBUG("Enter InitialModule function...\n");

	if ((gptSharedInfo=(TVMAH4EESharedInfo *)kmalloc(sizeof(TVMAH4EESharedInfo), GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate shared info buffer fail !!\n");
		scResult = -ENOMEM;
		goto FAIL;
	}
	memset(gptSharedInfo, 0, sizeof(TVMAH4EESharedInfo));

	dwDevInfoSize = VMA_H4EE_GetDevInfoSize();

	if ((gptSharedInfo->hDevInfo=(HANDLE)kmalloc(dwDevInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate device info buffer fail !!\n");
		scResult = -ENOMEM;
		goto FAIL;
	}
	memset(gptSharedInfo->hDevInfo, 0, dwDevInfoSize);

	mutex_init(&gptSharedInfo->ioctl_lock);

	gptSharedInfo->pClk = clk_get(NULL, "vma_h4de");    // use h4de
	
	if (IS_ERR(gptSharedInfo->pClk))
	{
		PDEBUG("Fail to get vma h4ee clock !!\n");
		scResult = PTR_ERR(gptSharedInfo->pClk);
		goto FAIL;
	}

	clk_prepare_enable(gptSharedInfo->pClk);
                                          
                                          // size OK ?
	request_mem_region(VMA_H4EE_MMR_BASE, sizeof(TVMAH4EEInfo), "VMA_H4EE");
                                                     // assign to h4ee/h4de ?
	if (VMA_H4EE_SetMMRInfo(gptSharedInfo->hDevInfo, ptMMRInfo, gptSharedInfo->pClk, pdwRstEnMmr) != S_OK)
	{
		scResult = -ENODEV;
		goto FAIL_CLK;
	}

#ifdef __PROFILE__
	VMA_H4EE_InitProfile(gptSharedInfo->hDevInfo);
#endif

	scResult = register_chrdev(gsdwMajor, "vma_h4ee", &vma_h4ee_fops);

	if (scResult < 0)
	{
		PDEBUG("Cannot get major number %d !!\n", (int)gsdwMajor);
		goto FAIL_CLK;
	}

	if (gsdwMajor == 0)
	{
		gsdwMajor = scResult;
	}

    vma_register_device(MKDEV(gsdwMajor, 0), NULL, "vma_h4ee");

	dwVersionNum = VMA_H4EE_GetVersion(gptSharedInfo->hDevInfo);

	printk("Install VMA_H4CDE device driver version %d.%d.%d.%d on VMA_H4EE hardware version %d.%d.%d.%d complete !!\n",
	       (int)(VMA_H4CDE_VERSION&0xFF),
	       (int)((VMA_H4CDE_VERSION>>8)&0xFF),
	       (int)((VMA_H4CDE_VERSION>>16)&0xFF),
	       (int)((VMA_H4CDE_VERSION>>24)&0xFF),
	       (int)(dwVersionNum>>24)&0xFF,
	       (int)(dwVersionNum>>16)&0xFF,
	       (int)(dwVersionNum>>8)&0xFF,
	       (int)dwVersionNum&0xFF);

	clk_disable(gptSharedInfo->pClk);

	PDEBUG("Exit InitialModule function !!\n");

	return 0;

FAIL_CLK:
	clk_disable(gptSharedInfo->pClk);
FAIL:
	CleanupModule();
	PDEBUG("Exit InitialModule function !!\n");

	return scResult;
}

/* ============================================================================================== */
module_init(InitialModule);
module_exit(CleanupModule);

/* ============================================================================================== */
