/*
 * $Header: /rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE/vma_h4cde_locals.c 5     15/12/24 7:46p Dy.lu $
 *
 * Copyright 2007-2012 VATICS Inc. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.4.0.8.
 *
 * $History: vma_h4cde_locals.c $
 * 
 * *****************  Version 5  *****************
 * User: Dy.lu        Date: 15/12/24   Time: 7:46p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * 
 * *****************  Version 4  *****************
 * User: Aphon.wu     Date: 15/08/11   Time: 7:01p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 * BUG: Decoder MMR read using burst_4w when ratio 3:2 - FIXED
 * *****************  Version 3  *****************
 * User: Cheng.jhu    Date: 15/07/29   Time: 10:29a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 2  *****************
 * User: Jaja         Date: 15/05/28   Time: 3:35p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/11/19   Time: 6:03p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 6  *****************
 * User: Jaja         Date: 14/10/28   Time: 2:56p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 5  *****************
 * User: Aphon.wu     Date: 14/10/21   Time: 6:07p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 4  *****************
 * User: Aphon.wu     Date: 14/10/21   Time: 4:13p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 3  *****************
 * User: Jaja         Date: 14/10/02   Time: 8:25p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 2  *****************
 * User: Jaja         Date: 14/10/02   Time: 11:00a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/09/18   Time: 7:05p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4CDE
 *
 * *****************  Version 3  *****************
 * User: Vincent      Date: 14/08/25   Time: 9:07p
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 2  *****************
 * User: Jaja         Date: 14/08/21   Time: 11:49a
 * Updated in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 14/08/01   Time: 3:40p
 * Created in $/rd_2/project/Rossini/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 4  *****************
 * User: Jaja         Date: 12/06/28   Time: 3:29p
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 3  *****************
 * User: Jaja         Date: 12/06/20   Time: 5:54p
 * Updated in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 * *****************  Version 1  *****************
 * User: Jaja         Date: 12/01/11   Time: 7:03p
 * Created in $/rd_2/project/SoC/Components/H4EE/Device_Driver/H4EE
 *
 */

/* ============================================================================================== */
#include "vma_h4cde_locals.h"

/* ============================================================================================== */
static void burst_4w(volatile DWORD *ptSrc, void *ptDes) {
	asm volatile (
		"ldmia %[in], {r3-r6} \n\t"	// read 16 words from address(ss)
		"stmia %[out]!, {r3-r6} \n\t"	// write 16 words to address(dest32)
		:[out]"+r" (ptDes)
		:[in]"r" (ptSrc)			// address points to memory location
		:"r3","r4","r5","r6","memory"
	);
}

DWORD burst_ctrl(volatile DWORD* ptVersion)
{
	TVMAH4EEInfo tempinfo;
	TVMAH4EEInfo *ptemp = &tempinfo;

	burst_4w(ptVersion, ptemp);

	return ptemp->dwCtrl;
}
DWORD burst_decoding_info(volatile DWORD* ptDecoding)
{
	TVMAH4EEInfo tempinfo;
	TVMAH4EEInfo *ptemp = &tempinfo;

	burst_4w(ptDecoding, ptemp);

	return ptemp->dwDecodingInfo;
}

/* ============================================================================================== */
DWORD VMA_H4EE_GetDevInfoSize(void)
{
	return sizeof(TVMAH4EEDevInfo);
}

/* ============================================================================================== */
//SCODE VMA_H4EE_SetMMRInfo(HANDLE hDevInfo, volatile TVMAH4EEInfo *ptMMRInfo, volatile DWORD *pdwClkEnMmr)
SCODE VMA_H4EE_SetMMRInfo(HANDLE hDevInfo, volatile TVMAH4EEInfo *ptMMRInfo, struct clk *pClk, volatile DWORD *pdwRstEnMmr)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
	DWORD *pdwSysCtrl;
   	TVMAH4EEInfo tempinfo;
	TVMAH4EEInfo *ptemp = &tempinfo;

	ptDevInfo->ptMMRInfo = ptMMRInfo;
	ptDevInfo->ptMMRDecInfo = (TVMAH4DEInfo *)ptMMRInfo;    // assign again ?

	//ptDevInfo->pdwClkEnMmr = pdwClkEnMmr;
	ptDevInfo->pClk = pClk;
    ptDevInfo->pdwRstEnMmr = pdwRstEnMmr;
    //ptDevInfo->dwVersionNum = ptDevInfo->ptMMRInfo->dwVersion;
	pdwSysCtrl = (DWORD *)IO_ADDRESS(VPL_SYSC_MMR_BASE);
    ptDevInfo->dwSysCtrlVersion = readl(pdwSysCtrl);

#if 0
	if ((ptDevInfo->ptMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}
#else //
	burst_4w(&(ptDevInfo->ptMMRInfo->dwVersion), &tempinfo);
	if ((ptemp->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}
	ptDevInfo->dwVersionNum = ptemp->dwVersion;
#endif //

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptMMRInfo);
	PDEBUG("ptDevInfo->ptMMRDecInfo = 0x%08X\n", (int)ptDevInfo->ptMMRDecInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VMA_H4EE_GetMMRInfo(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
DWORD VMA_H4EE_GetDecMMRInfo(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRDecInfo);
}

/* ============================================================================================== */
#ifdef __PROFILE__
SCODE VMA_H4EE_InitProfileInfo(TVMAH4EEObjInfo *ptObjInfo)
{
	DWORD dwProfileInfoSize;

	dwProfileInfoSize = sizeof(TVMAH4EEProfileInfo);
	if ((ptObjInfo->hProfileInfo=(HANDLE)kmalloc(dwProfileInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate profile info buffer fail !!");
		return -ENOMEM;
	}
	memset(ptObjInfo->hProfileInfo, 0, dwProfileInfoSize);

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_H4EE_InitProfile(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

    request_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x108, sizeof(DWORD), "VMA_H4EE Profile Clear");
	ptDevInfo->apdwProfileClr[0] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x108), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Bandwidth");
	ptDevInfo->apdwBandwidth[0] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Grant Interval");
	ptDevInfo->apdwRGInterval[0] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Times");
	ptDevInfo->apdwReqTimes[0] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x108, sizeof(DWORD), "VMA_H4EE Profile Clear");
	ptDevInfo->apdwProfileClr[1] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x108), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Bandwidth");
	ptDevInfo->apdwBandwidth[1] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Grant Interval");
	ptDevInfo->apdwRGInterval[1] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Times");
	ptDevInfo->apdwReqTimes[1] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x108, sizeof(DWORD), "VMA_H4EE Profile Clear");
	ptDevInfo->apdwProfileClr[2] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x108), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Bandwidth");
	ptDevInfo->apdwBandwidth[2] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Grant Interval");
	ptDevInfo->apdwRGInterval[2] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_H4EE Request Times");
	ptDevInfo->apdwReqTimes[2] = (DWORD *)ioremap((int)(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2)), sizeof(DWORD));

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_H4EE_GetProfileInfo(HANDLE hDevInfo, TVMAH4EEObjInfo *ptObjInfo, DWORD dwWriteIndex)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
	TVMAH4EEProfileInfo *ptProfileInfo = (TVMAH4EEProfileInfo *)ptObjInfo->hProfileInfo;

	ptProfileInfo->adwBandwidth[0] = ptDevInfo->aadwBandwidth[dwWriteIndex][0];
	ptProfileInfo->adwRGInterval[0] = ptDevInfo->aadwRGInterval[dwWriteIndex][0];
	ptProfileInfo->adwReqTimes[0] = ptDevInfo->aadwReqTimes[dwWriteIndex][0];
	ptProfileInfo->adwBandwidth[1] = ptDevInfo->aadwBandwidth[dwWriteIndex][1];
	ptProfileInfo->adwRGInterval[1] = ptDevInfo->aadwRGInterval[dwWriteIndex][1];
	ptProfileInfo->adwReqTimes[1] = ptDevInfo->aadwReqTimes[dwWriteIndex][1];
	ptProfileInfo->adwBandwidth[2] = ptDevInfo->aadwBandwidth[dwWriteIndex][2];
	ptProfileInfo->adwRGInterval[2] = ptDevInfo->aadwRGInterval[dwWriteIndex][2];
	ptProfileInfo->adwReqTimes[2] = ptDevInfo->aadwReqTimes[dwWriteIndex][2];

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_H4EE_CloseProfile(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	if (ptDevInfo->apdwProfileClr[0] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[0]);
		release_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[0] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[0]);
		release_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[0] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[0]);
		release_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[0] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[0]);
		release_mem_region(VMA_H4EE_MASTER_0_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwProfileClr[1] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[1]);
		release_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[1] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[1]);
		release_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[1] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[1]);
		release_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[1] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[1]);
		release_mem_region(VMA_H4EE_MASTER_1_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwProfileClr[2] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[2]);
		release_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[2] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[2]);
		release_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x10C+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[2] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[2]);
		release_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x148+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[2] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[2]);
		release_mem_region(VMA_H4EE_MASTER_2_BUS_BASE_ADDR+0x184+((VMA_H4EE_MASTER_2_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_H4EE_SetupProfile(TVMAH4EEObjInfo *ptObjInfo, DWORD dwArg, DWORD dwCmd)
{
	TVMAH4EEProfileInfo *ptProfileInfo = (TVMAH4EEProfileInfo *)ptObjInfo->hProfileInfo;
	int scError;

	switch (dwCmd)
	{
		case VMA_H4EE_IOC_MASTER_0_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[0], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_0_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[0], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_0_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[0], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_0_CLEAR_PROFILE:
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[1], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[1], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_1_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[1], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_1_CLEAR_PROFILE:
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[2], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[2], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_2_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[2], sizeof(DWORD));
			if (scError != 0)
			{
				PDEBUG("Exit Ioctl function !!\n");
				return -EFAULT;
			}
		break;
		case VMA_H4EE_IOC_MASTER_2_CLEAR_PROFILE:
		break;
		default:
			return S_FAIL;
	}


	return S_OK;
}
#endif //__PROFILE__

/* ============================================================================================== */
DWORD VMA_H4EE_GetVersion(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
	TVMAH4EEInfo tempinfo;
	TVMAH4EEInfo *ptemp = &tempinfo;

	writel(readl(BUS_PRIORITY_MMR)|0x08000000, BUS_PRIORITY_MMR);
#if 0
    return ptDevInfo->ptMMRInfo->dwVersion;
#else //
	burst_4w(&(ptDevInfo->ptMMRInfo->dwVersion), &tempinfo);

	return ptemp->dwVersion;
#endif //
}

/* ============================================================================================== */
DWORD VMA_H4EE_StartHead(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	return ptDevInfo->dwWriteIndex;
}
/* ============================================================================================== */
void VMA_H4EE_Reset(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	PDEBUG("Enter Reset function...\n");

    *ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr & (~(VMA_H4EE_RST_EN_VALUE<<VMA_H4EE_RST_EN_NUM));                                                                                  
    *ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr | (VMA_H4EE_RST_EN_VALUE<<VMA_H4EE_RST_EN_NUM); 

	ptDevInfo->ptMMRDecInfo->dwLumaCurrAddr = 0xFFFF;
	while (ptDevInfo->ptMMRInfo->dwVersion != ptDevInfo->dwVersionNum)
	{
		ptDevInfo->ptMMRDecInfo->dwLumaCurrAddr = 0xFFFF;
	}

	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<31);
	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<31) | 0x00000008;

#if 0
	while ((ptDevInfo->ptMMRInfo->dwCtrl&0x00000008) != 0);
#else
    while ((burst_ctrl(&ptDevInfo->ptMMRInfo->dwVersion)&0x00000008) != 0);
#endif //

	ptDevInfo->ptMMRInfo->dwCtrl = 0x0;

	PDEBUG("Exit Reset function !!\n");
}
/* ============================================================================================== */

static inline void vma_h4ee_copy_mmr(volatile TVMAH4EEInfo* hw_ptMMRInfo, TVMAH4EEInfo *ptMMRInfo)
{
	hw_ptMMRInfo->dwDecodingInfo = 0;
	hw_ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl;
	hw_ptMMRInfo->dwCodingCtrl = ptMMRInfo->dwCodingCtrl;
	hw_ptMMRInfo->dwYCurrAddr = ptMMRInfo->dwYCurrAddr;
	hw_ptMMRInfo->dwCbCurrAddr = ptMMRInfo->dwCbCurrAddr;
	hw_ptMMRInfo->dwCrCurrAddr = ptMMRInfo->dwCrCurrAddr;
	hw_ptMMRInfo->dwLumaDeblockAddr = ptMMRInfo->dwLumaDeblockAddr;
	hw_ptMMRInfo->dwChmaDeblockAddr = ptMMRInfo->dwChmaDeblockAddr;
	hw_ptMMRInfo->dwLumaFwdRef0Addr = ptMMRInfo->dwLumaFwdRef0Addr;
	hw_ptMMRInfo->dwChmaFwdRef0Addr = ptMMRInfo->dwChmaFwdRef0Addr;
	hw_ptMMRInfo->dwLumaFwdRef1Addr = ptMMRInfo->dwLumaFwdRef1Addr;
	hw_ptMMRInfo->dwChmaFwdRef1Addr = ptMMRInfo->dwChmaFwdRef1Addr;
	hw_ptMMRInfo->dwMBInfoAddr = ptMMRInfo->dwMBInfoAddr;
	hw_ptMMRInfo->dwBSLowBoundAddr = ptMMRInfo->dwBSLowBoundAddr;
	hw_ptMMRInfo->dwBSUpBoundAddr = ptMMRInfo->dwBSUpBoundAddr;
	hw_ptMMRInfo->dwCMTblAddr = ptMMRInfo->dwCMTblAddr;
	hw_ptMMRInfo->dwIntraPredAddr = ptMMRInfo->dwIntraPredAddr;
	hw_ptMMRInfo->dwMBNumInfo = ptMMRInfo->dwMBNumInfo;
	hw_ptMMRInfo->dwSizeInfo = ptMMRInfo->dwSizeInfo;
	hw_ptMMRInfo->dwQuantInfo = ptMMRInfo->dwQuantInfo;
	hw_ptMMRInfo->dwBSSizeInfo = ptMMRInfo->dwBSSizeInfo;
	hw_ptMMRInfo->dwPrevSliceInfo0 = ptMMRInfo->dwPrevSliceInfo0;
	hw_ptMMRInfo->dwPrevSliceInfo1 = ptMMRInfo->dwPrevSliceInfo1;
	hw_ptMMRInfo->dwPrevSliceInfo2 = ptMMRInfo->dwPrevSliceInfo2;
	hw_ptMMRInfo->dwPrevSliceInfo3 = ptMMRInfo->dwPrevSliceInfo3;
	hw_ptMMRInfo->dwUnalignMSBs = ptMMRInfo->dwUnalignMSBs;
	hw_ptMMRInfo->dwUnalignLSBs = ptMMRInfo->dwUnalignLSBs;
	hw_ptMMRInfo->dwBinsCnt = ptMMRInfo->dwBinsCnt;
	hw_ptMMRInfo->dwCoeffCost = ptMMRInfo->dwCoeffCost;
	hw_ptMMRInfo->dwMEBEVLCOutAddr = ptMMRInfo->dwMEBEVLCOutAddr;
	hw_ptMMRInfo->dwMEBETblAddr = ptMMRInfo->dwMEBETblAddr;
	hw_ptMMRInfo->dwMEBEMBNum = ptMMRInfo->dwMEBEMBNum;
	hw_ptMMRInfo->dwMEBEWidthBuffSize = ptMMRInfo->dwMEBEWidthBuffSize;
	hw_ptMMRInfo->dwMEBEQuantBuffSize = ptMMRInfo->dwMEBEQuantBuffSize;
	//if (((ptDevInfo->ptMMRInfo->dwCodingCtrl>>15)&0x1)==1)
	if (((ptMMRInfo->dwCodingCtrl>>15)&0x1)==1)
	{
		hw_ptMMRInfo->dwMEBECodingCtrl = ptMMRInfo->dwMEBECodingCtrl;
		hw_ptMMRInfo->dwMEBEVPPacketSize = ptMMRInfo->dwMEBEVPPacketSize;
		hw_ptMMRInfo->dwMEBEVPInfoVPNum = ptMMRInfo->dwMEBEVPInfoVPNum;
		hw_ptMMRInfo->dwMEBEVPHdrInfo = ptMMRInfo->dwMEBEVPHdrInfo;
		hw_ptMMRInfo->dwMEBEVPExtHdrInfo = ptMMRInfo->dwMEBEVPExtHdrInfo;
	}
	hw_ptMMRInfo->dwIntraPredModeEnCtrl = ptMMRInfo->dwIntraPredModeEnCtrl;
	hw_ptMMRInfo->dwMBRefreshInfo = ptMMRInfo->dwMBRefreshInfo;
	hw_ptMMRInfo->dwFmeBlkDisCtrl = ptMMRInfo->dwFmeBlkDisCtrl;
	hw_ptMMRInfo->dwLambdaQModeCost = ptMMRInfo->dwLambdaQModeCost;		//Mozart I end

	/*if (ptDevInfo->dwSysCtrlVersion == 0x8010C02) // Mozart II and above version
	{
		DWORD dwObjectBndBoxEn = (ptMMRInfo->dwObjectInfoReserve>>1)&0x1;

		hw_ptMMRInfo->dwObjectInfoAddr = ptMMRInfo->dwObjectInfoAddr;
		hw_ptMMRInfo->dwObjectInfoReserve = ptMMRInfo->dwObjectInfoReserve;
		hw_ptMMRInfo->dwObjectMBsStride = ptMMRInfo->dwObjectMBsStride;		//Mozart II end
		hw_ptMMRInfo->dwMeDisableTbl = ptMMRInfo->dwMeDisableTbl;	//Mozart II have // Bee, Mozart III, Paganini
		if (dwObjectBndBoxEn == 1)
		{
			for (i=0; i<32; i++)
			{
				hw_ptMMRInfo->adwObjBndBoxInfo[i] = ptMMRInfo->adwObjBndBoxInfo[i];	//Mozart II have // Bee, Mozart III, Paganini
			}
		}
	}
	else if (ptDevInfo->dwSysCtrlVersion != 0x8010002)*/
	{
		// Bee(0x5000000), Mozart III(0x8040000), Paganini
		DWORD dwObjectBndBoxEn = (ptMMRInfo->dwObjectInfoReserve>>1)&0x1;

		hw_ptMMRInfo->dwObjectInfoAddr = ptMMRInfo->dwObjectInfoAddr;
		hw_ptMMRInfo->dwObjectInfoReserve = ptMMRInfo->dwObjectInfoReserve;
		hw_ptMMRInfo->dwObjectMBsStride = ptMMRInfo->dwObjectMBsStride;			//Mozart II end
		hw_ptMMRInfo->dwDeblocAhbTsfConfig = ptMMRInfo->dwDeblocAhbTsfConfig;	// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo0 = ptMMRInfo->dwH4eeConfigInfo0;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo1 = ptMMRInfo->dwH4eeConfigInfo1;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo2 = ptMMRInfo->dwH4eeConfigInfo2;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo3 = ptMMRInfo->dwH4eeConfigInfo3;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo4 = ptMMRInfo->dwH4eeConfigInfo4;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwH4eeConfigInfo5 = ptMMRInfo->dwH4eeConfigInfo5;			// Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwColIntraRefresh0Info = ptMMRInfo->dwColIntraRefresh0Info;	//Mozart III, Paganini
		hw_ptMMRInfo->dwColIntraRefresh1Info = ptMMRInfo->dwColIntraRefresh1Info;   //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3CodingCtrl = ptMMRInfo->dwMozartV3CodingCtrl;       //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3MeSadThr = ptMMRInfo->dwMozartV3MeSadThr;           //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3MeMvFactor = ptMMRInfo->dwMozartV3MeMvFactor;       //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3BndBoxQpd0 = ptMMRInfo->dwMozartV3BndBoxQpd0;       //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3BndBoxQpd1 = ptMMRInfo->dwMozartV3BndBoxQpd1;       //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3InBndBoxMode = ptMMRInfo->dwMozartV3InBndBoxMode;   //Mozart III, Paganini
		hw_ptMMRInfo->dwMozartV3OutBndBoxMode = ptMMRInfo->dwMozartV3OutBndBoxMode; //Mozart III, Paganini
		hw_ptMMRInfo->dwCarApp00 = ptMMRInfo->dwCarApp00;
		hw_ptMMRInfo->dwCarApp01 = ptMMRInfo->dwCarApp01;
		hw_ptMMRInfo->dwCarApp02 = ptMMRInfo->dwCarApp02;
		hw_ptMMRInfo->dwCarApp03 = ptMMRInfo->dwCarApp03;
		hw_ptMMRInfo->dwDecodingInfo = ptMMRInfo->dwDecodingInfo;
		hw_ptMMRInfo->dwRecRefStride = ptMMRInfo->dwRecRefStride;
		hw_ptMMRInfo->dwExChmrDblkUpAddr = ptMMRInfo->dwExChmrDblkUpAddr;
		hw_ptMMRInfo->dwChmrDeblockAddr = ptMMRInfo->dwChmrDeblockAddr;
		hw_ptMMRInfo->dwChmrFwdRef0Addr = ptMMRInfo->dwChmrFwdRef0Addr;
		hw_ptMMRInfo->dwChmrFwdRef1Addr = ptMMRInfo->dwChmrFwdRef1Addr;
		hw_ptMMRInfo->dwMeDisableTbl = ptMMRInfo->dwMeDisableTbl;	//Mozart II have // Bee, Mozart III, Paganini

		if (dwObjectBndBoxEn == 1)
		{
			DWORD i;
			for (i=0; i<32; i++)
			{
				hw_ptMMRInfo->adwObjBndBoxInfo[i] = ptMMRInfo->adwObjBndBoxInfo[i];	//Mozart II have // Bee, Mozart III, Paganini
			}
		}
		hw_ptMMRInfo->dwConfigCycleUsed = ptMMRInfo->dwConfigCycleUsed;  // Bee, Mozart III, Paganini
		hw_ptMMRInfo->dwTemp00 = ptMMRInfo->dwTemp00;
		hw_ptMMRInfo->dwTemp01 = ptMMRInfo->dwTemp01;

		hw_ptMMRInfo->dwOsdCurrLumaAddr = ptMMRInfo->dwOsdCurrLumaAddr;
		hw_ptMMRInfo->dwOsdCurrChmaAddr = ptMMRInfo->dwOsdCurrChmaAddr;
		hw_ptMMRInfo->dwOsdCurrChmrAddr = ptMMRInfo->dwOsdCurrChmrAddr;
		hw_ptMMRInfo->dwOsdSizeInfo = ptMMRInfo->dwOsdSizeInfo;
		hw_ptMMRInfo->dwOsdStrideInfo = ptMMRInfo->dwOsdStrideInfo;
	}
#ifdef __PROFILE__
	hw_ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x40000006;
#else //!__PROFILE__
	hw_ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;
#endif //__PROFILE__

}

static inline void vma_h4de_copy_mmr(volatile TVMAH4DEInfo *hw_ptMMRDecInfo, TVMAH4DEInfo *ptMMRDecInfo)
{
	hw_ptMMRDecInfo->dwLTInfo = ptMMRDecInfo->dwLTInfo;
	hw_ptMMRDecInfo->dwCtrl = ptMMRDecInfo->dwCtrl;

	hw_ptMMRDecInfo->dwCtrl = ((ptMMRDecInfo->dwCtrl)|((0xc000<<16)|(0x80)));//gating clock en

	hw_ptMMRDecInfo->dwLumaCurrAddr = ptMMRDecInfo->dwLumaCurrAddr;
	hw_ptMMRDecInfo->dwChromaCurrAddr = ptMMRDecInfo->dwChromaCurrAddr;
	hw_ptMMRDecInfo->dwBlockCurrAddr = ptMMRDecInfo->dwBlockCurrAddr;
	hw_ptMMRDecInfo->dwAHBAccessMBNum = ptMMRDecInfo->dwAHBAccessMBNum;
	hw_ptMMRDecInfo->dwMBInfoAddr = ptMMRDecInfo->dwMBInfoAddr;
	hw_ptMMRDecInfo->dwColMBInfoAddr = ptMMRDecInfo->dwColMBInfoAddr;
	hw_ptMMRDecInfo->dwList0RefAddr00 = ptMMRDecInfo->dwList0RefAddr00;
	hw_ptMMRDecInfo->dwList0RefAddr01 = ptMMRDecInfo->dwList0RefAddr01;
	hw_ptMMRDecInfo->dwList0RefAddr02 = ptMMRDecInfo->dwList0RefAddr02;
	hw_ptMMRDecInfo->dwList0RefAddr03 = ptMMRDecInfo->dwList0RefAddr03;
	hw_ptMMRDecInfo->dwList0RefAddr04 = ptMMRDecInfo->dwList0RefAddr04;
	hw_ptMMRDecInfo->dwList0RefAddr05 = ptMMRDecInfo->dwList0RefAddr05;
	hw_ptMMRDecInfo->dwList0RefAddr06 = ptMMRDecInfo->dwList0RefAddr06;
	hw_ptMMRDecInfo->dwList0RefAddr07 = ptMMRDecInfo->dwList0RefAddr07;
	hw_ptMMRDecInfo->dwList0RefAddr08 = ptMMRDecInfo->dwList0RefAddr08;
	hw_ptMMRDecInfo->dwList0RefAddr09 = ptMMRDecInfo->dwList0RefAddr09;
	hw_ptMMRDecInfo->dwList0RefAddr10 = ptMMRDecInfo->dwList0RefAddr10;
	hw_ptMMRDecInfo->dwList0RefAddr11 = ptMMRDecInfo->dwList0RefAddr11;
	hw_ptMMRDecInfo->dwList0RefAddr12 = ptMMRDecInfo->dwList0RefAddr12;
	hw_ptMMRDecInfo->dwList0RefAddr13 = ptMMRDecInfo->dwList0RefAddr13;
	hw_ptMMRDecInfo->dwList0RefAddr14 = ptMMRDecInfo->dwList0RefAddr14;
	hw_ptMMRDecInfo->dwList0RefAddr15 = ptMMRDecInfo->dwList0RefAddr15;
	hw_ptMMRDecInfo->dwList1RefAddr00 = ptMMRDecInfo->dwList1RefAddr00;
	hw_ptMMRDecInfo->dwList1RefAddr01 = ptMMRDecInfo->dwList1RefAddr01;
	hw_ptMMRDecInfo->dwList1RefAddr02 = ptMMRDecInfo->dwList1RefAddr02;
	hw_ptMMRDecInfo->dwList1RefAddr03 = ptMMRDecInfo->dwList1RefAddr03;
	hw_ptMMRDecInfo->dwList1RefAddr04 = ptMMRDecInfo->dwList1RefAddr04;
	hw_ptMMRDecInfo->dwList1RefAddr05 = ptMMRDecInfo->dwList1RefAddr05;
	hw_ptMMRDecInfo->dwList1RefAddr06 = ptMMRDecInfo->dwList1RefAddr06;
	hw_ptMMRDecInfo->dwList1RefAddr07 = ptMMRDecInfo->dwList1RefAddr07;
	hw_ptMMRDecInfo->dwList1RefAddr08 = ptMMRDecInfo->dwList1RefAddr08;
	hw_ptMMRDecInfo->dwList1RefAddr09 = ptMMRDecInfo->dwList1RefAddr09;
	hw_ptMMRDecInfo->dwList1RefAddr10 = ptMMRDecInfo->dwList1RefAddr10;
	hw_ptMMRDecInfo->dwList1RefAddr11 = ptMMRDecInfo->dwList1RefAddr11;
	hw_ptMMRDecInfo->dwList1RefAddr12 = ptMMRDecInfo->dwList1RefAddr12;
	hw_ptMMRDecInfo->dwList1RefAddr13 = ptMMRDecInfo->dwList1RefAddr13;
	hw_ptMMRDecInfo->dwList1RefAddr14 = ptMMRDecInfo->dwList1RefAddr14;
	hw_ptMMRDecInfo->dwList1RefAddr15 = ptMMRDecInfo->dwList1RefAddr15;
	hw_ptMMRDecInfo->dwList1ColMBInfoAddr = ptMMRDecInfo->dwList1ColMBInfoAddr;
	hw_ptMMRDecInfo->dwIntraDepredAddr = ptMMRDecInfo->dwIntraDepredAddr;
	hw_ptMMRDecInfo->dwDeblockAddr = ptMMRDecInfo->dwDeblockAddr;
	hw_ptMMRDecInfo->dwBSCtrl = ptMMRDecInfo->dwBSCtrl;
	hw_ptMMRDecInfo->dwBSCurrAddr = ptMMRDecInfo->dwBSCurrAddr;
	hw_ptMMRDecInfo->dwBSValidSize = ptMMRDecInfo->dwBSValidSize;
	hw_ptMMRDecInfo->dwBSLowBoundAddr = ptMMRDecInfo->dwBSLowBoundAddr;
	hw_ptMMRDecInfo->dwBSUpBoundAddr = ptMMRDecInfo->dwBSUpBoundAddr;
	hw_ptMMRDecInfo->dwBSDecSize = ptMMRDecInfo->dwBSDecSize;
	hw_ptMMRDecInfo->dwCMTblAddr = ptMMRDecInfo->dwCMTblAddr;
	hw_ptMMRDecInfo->dwWeightScaleTblAddr = ptMMRDecInfo->dwWeightScaleTblAddr;
	hw_ptMMRDecInfo->dwPredWeightTblAddr = ptMMRDecInfo->dwPredWeightTblAddr;
	hw_ptMMRDecInfo->dwFrameSizeInfo0 = ptMMRDecInfo->dwFrameSizeInfo0;
	hw_ptMMRDecInfo->dwFrameSizeInfo1 = ptMMRDecInfo->dwFrameSizeInfo1;
	hw_ptMMRDecInfo->dwCrCurrAddr = ptMMRDecInfo->dwCrCurrAddr;
	hw_ptMMRDecInfo->dwOPCycleLimitation = ptMMRDecInfo->dwOPCycleLimitation;
	hw_ptMMRDecInfo->dwSPSInfo = ptMMRDecInfo->dwSPSInfo;
	hw_ptMMRDecInfo->dwPPSInfo = ptMMRDecInfo->dwPPSInfo;
	hw_ptMMRDecInfo->dwSliceInfo00 = ptMMRDecInfo->dwSliceInfo00;
	hw_ptMMRDecInfo->dwSliceInfo01 = ptMMRDecInfo->dwSliceInfo01;
	hw_ptMMRDecInfo->dwSliceInfo02 = ptMMRDecInfo->dwSliceInfo02;
	hw_ptMMRDecInfo->dwSliceInfo03 = ptMMRDecInfo->dwSliceInfo03;
	hw_ptMMRDecInfo->dwSliceInfo04 = ptMMRDecInfo->dwSliceInfo04;
	hw_ptMMRDecInfo->dwSliceInfo05 = ptMMRDecInfo->dwSliceInfo05;
	hw_ptMMRDecInfo->dwSliceInfo06 = ptMMRDecInfo->dwSliceInfo06;
	hw_ptMMRDecInfo->dwSliceInfo07 = ptMMRDecInfo->dwSliceInfo07;
	hw_ptMMRDecInfo->dwSliceInfo08 = ptMMRDecInfo->dwSliceInfo08;
	hw_ptMMRDecInfo->dwSliceInfo09 = ptMMRDecInfo->dwSliceInfo09;
	hw_ptMMRDecInfo->dwSliceInfo10 = ptMMRDecInfo->dwSliceInfo10;
	hw_ptMMRDecInfo->dwLTInfo = ptMMRDecInfo->dwLTInfo;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC00 = ptMMRDecInfo->dwCurrL0RefIdxPOC00;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC01 = ptMMRDecInfo->dwCurrL0RefIdxPOC01;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC02 = ptMMRDecInfo->dwCurrL0RefIdxPOC02;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC03 = ptMMRDecInfo->dwCurrL0RefIdxPOC03;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC04 = ptMMRDecInfo->dwCurrL0RefIdxPOC04;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC05 = ptMMRDecInfo->dwCurrL0RefIdxPOC05;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC06 = ptMMRDecInfo->dwCurrL0RefIdxPOC06;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC07 = ptMMRDecInfo->dwCurrL0RefIdxPOC07;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC08 = ptMMRDecInfo->dwCurrL0RefIdxPOC08;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC09 = ptMMRDecInfo->dwCurrL0RefIdxPOC09;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC10 = ptMMRDecInfo->dwCurrL0RefIdxPOC10;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC11 = ptMMRDecInfo->dwCurrL0RefIdxPOC11;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC12 = ptMMRDecInfo->dwCurrL0RefIdxPOC12;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC13 = ptMMRDecInfo->dwCurrL0RefIdxPOC13;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC14 = ptMMRDecInfo->dwCurrL0RefIdxPOC14;
	hw_ptMMRDecInfo->dwCurrL0RefIdxPOC15 = ptMMRDecInfo->dwCurrL0RefIdxPOC15;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC00 = ptMMRDecInfo->dwCurrL1RefIdxPOC00;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC01 = ptMMRDecInfo->dwCurrL1RefIdxPOC01;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC02 = ptMMRDecInfo->dwCurrL1RefIdxPOC02;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC03 = ptMMRDecInfo->dwCurrL1RefIdxPOC03;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC04 = ptMMRDecInfo->dwCurrL1RefIdxPOC04;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC05 = ptMMRDecInfo->dwCurrL1RefIdxPOC05;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC06 = ptMMRDecInfo->dwCurrL1RefIdxPOC06;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC07 = ptMMRDecInfo->dwCurrL1RefIdxPOC07;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC08 = ptMMRDecInfo->dwCurrL1RefIdxPOC08;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC09 = ptMMRDecInfo->dwCurrL1RefIdxPOC09;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC10 = ptMMRDecInfo->dwCurrL1RefIdxPOC10;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC11 = ptMMRDecInfo->dwCurrL1RefIdxPOC11;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC12 = ptMMRDecInfo->dwCurrL1RefIdxPOC12;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC13 = ptMMRDecInfo->dwCurrL1RefIdxPOC13;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC14 = ptMMRDecInfo->dwCurrL1RefIdxPOC14;
	hw_ptMMRDecInfo->dwCurrL1RefIdxPOC15 = ptMMRDecInfo->dwCurrL1RefIdxPOC15;
	hw_ptMMRDecInfo->dwIOVectorStartAddr = ptMMRDecInfo->dwIOVectorStartAddr;
	hw_ptMMRDecInfo->dwIOVectorEndAddr = ptMMRDecInfo->dwIOVectorEndAddr;
	hw_ptMMRDecInfo->dwConfigCycleUsed = ptMMRDecInfo->dwConfigCycleUsed;

	hw_ptMMRDecInfo->dwCtrl = ptMMRDecInfo->dwCtrl | 0x00000006;
}

/* ============================================================================================== */

void VMA_H4EE_StartTail(HANDLE hDevInfo, DWORD dwWriteIndex, TVMAH4EEObjInfo *ptObjInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	ptDevInfo->abEnc[dwWriteIndex] = ptObjInfo->bEnc;

	ptDevInfo->aptMMRInfo[dwWriteIndex] = ptObjInfo->ptMMRInfo;

    ptDevInfo->dwWriteIndex = (dwWriteIndex+1) & VMA_H4EE_MMR_BUFF_MASK;

	//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
	if (!ptDevInfo->bBusy)
	{
		ptDevInfo->bBusy = TRUE;
		clk_enable(ptDevInfo->pClk);
		//*ptDevInfo->pdwClkEnMmr = (*ptDevInfo->pdwClkEnMmr) | (0x1<<VMA_H4EE_CLK_EN_NUM);

		if (ptObjInfo->bEnc)
		{
			vma_h4ee_copy_mmr(ptDevInfo->ptMMRInfo, ptObjInfo->ptMMRInfo);
		}
		else
		{
			TVMAH4DEInfo* ptMMRDecInfo = (TVMAH4DEInfo*) ptObjInfo->ptMMRInfo;
			vma_h4de_copy_mmr(ptDevInfo->ptMMRDecInfo, ptMMRDecInfo);

			// clean MMR dec mode for ISR decision
			ptMMRDecInfo->dwLTInfo = 0;
			//ptDevInfo->aptMMRDecInfo[dwWriteIndex]->dwLTInfo = 0; // device info save buffer
		}
	}//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
}

/* ============================================================================================== */
void VMA_H4EE_IntrEnable(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

#if 0
	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl | 0x00000002;
#else
	ptDevInfo->ptMMRInfo->dwCtrl = burst_ctrl(&ptDevInfo->ptMMRInfo->dwVersion) | 0x00000002;
#endif //

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VMA_H4EE_IntrDisable(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

#if 0
	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFD;
#else
	ptDevInfo->ptMMRInfo->dwCtrl = burst_ctrl(&ptDevInfo->ptMMRInfo->dwVersion) & 0xFFFFFFFD;
#endif //

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VMA_H4EE_IntrClear(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
#if 0
    ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;
#else
	ptDevInfo->ptMMRInfo->dwCtrl = burst_ctrl(&ptDevInfo->ptMMRInfo->dwVersion) & 0xFFFFFFFE;
#endif //

	PDEBUG("Interrupt cleared !!\n");
}



/* ============================================================================================== */
void VMA_H4EE_Open(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;

	ptDevInfo->bBusy = FALSE;
	ptDevInfo->dwReadIndex = 0;
	ptDevInfo->dwWriteIndex = 0;
}

/* ============================================================================================== */
DWORD VMA_H4EE_ISR(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
	DWORD dwReadIndex = ptDevInfo->dwReadIndex;
	BOOL bEncMode = ptDevInfo->abEnc[dwReadIndex];


    ptDevInfo->ptMMRInfo->dwCtrl = burst_ctrl(&ptDevInfo->ptMMRInfo->dwVersion) & 0xFFFFFFFE;

#ifdef __PROFILE__
	ptDevInfo->aadwBandwidth[dwReadIndex][0] = *ptDevInfo->apdwBandwidth[0];
	ptDevInfo->aadwRGInterval[dwReadIndex][0] = *ptDevInfo->apdwRGInterval[0];
	ptDevInfo->aadwReqTimes[dwReadIndex][0] = *ptDevInfo->apdwReqTimes[0];
	writel((0x1<<VMA_H4EE_MASTER_0_MASTER_NUM), ptDevInfo->apdwProfileClr[0]);

	ptDevInfo->aadwBandwidth[dwReadIndex][1] = *ptDevInfo->apdwBandwidth[1];
	ptDevInfo->aadwRGInterval[dwReadIndex][1] = *ptDevInfo->apdwRGInterval[1];
	ptDevInfo->aadwReqTimes[dwReadIndex][1] = *ptDevInfo->apdwReqTimes[1];
	writel((0x1<<VMA_H4EE_MASTER_1_MASTER_NUM), ptDevInfo->apdwProfileClr[1]);

	ptDevInfo->aadwBandwidth[dwReadIndex][2] = *ptDevInfo->apdwBandwidth[2];
	ptDevInfo->aadwRGInterval[dwReadIndex][2] = *ptDevInfo->apdwRGInterval[2];
	ptDevInfo->aadwReqTimes[dwReadIndex][2] = *ptDevInfo->apdwReqTimes[2];
	writel((0x1<<VMA_H4EE_MASTER_2_MASTER_NUM), ptDevInfo->apdwProfileClr[2]);
#endif //__PROFILE__

	if (bEncMode)
	{
		TVMAH4EEInfo *ptMMRInfo  = (TVMAH4EEInfo*) ptDevInfo->aptMMRInfo[dwReadIndex];
		if (ptMMRInfo != NULL)
		{
			//printk("[ISRHead] enc mode != NULL go\n");
#if 0
		    ptMMRInfo->dwVersion = ptDevInfo->ptMMRInfo->dwVersion;
		    ptMMRInfo->dwCycles = ptDevInfo->ptMMRInfo->dwCycles;
		    //printk("ptDevInfo->ptMMRInfo->dwCycles = %8d\n", ptDevInfo->ptMMRInfo->dwCycles);
		    //printk("=======================\n");
		    ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl;
		    ptMMRInfo->dwStat = ptDevInfo->ptMMRInfo->dwStat;

		    //ptMMRInfo->dwCodingCtrl = ptDevInfo->ptMMRInfo->dwCodingCtrl;
		    //ptMMRInfo->dwYCurrAddr = ptDevInfo->ptMMRInfo->dwYCurrAddr;
		    //ptMMRInfo->dwCbCurrAddr = ptDevInfo->ptMMRInfo->dwCbCurrAddr;
		    //ptMMRInfo->dwCrCurrAddr = ptDevInfo->ptMMRInfo->dwCrCurrAddr;
		    //ptMMRInfo->dwLumaDeblockAddr = ptDevInfo->ptMMRInfo->dwLumaDeblockAddr;
		    //ptMMRInfo->dwChmaDeblockAddr = ptDevInfo->ptMMRInfo->dwChmaDeblockAddr;
		    //ptMMRInfo->dwLumaFwdRef0Addr = ptDevInfo->ptMMRInfo->dwLumaFwdRef0Addr;
		    //ptMMRInfo->dwChmaFwdRef0Addr = ptDevInfo->ptMMRInfo->dwChmaFwdRef0Addr;
		    //ptMMRInfo->dwLumaFwdRef1Addr = ptDevInfo->ptMMRInfo->dwLumaFwdRef1Addr;
		    //ptMMRInfo->dwChmaFwdRef1Addr = ptDevInfo->ptMMRInfo->dwChmaFwdRef1Addr;
		    //ptMMRInfo->dwMBInfoAddr = ptDevInfo->ptMMRInfo->dwMBInfoAddr;
		    //ptMMRInfo->dwBSLowBoundAddr = ptDevInfo->ptMMRInfo->dwBSLowBoundAddr;
		    //ptMMRInfo->dwBSUpBoundAddr = ptDevInfo->ptMMRInfo->dwBSUpBoundAddr;
		    //ptMMRInfo->dwCMTblAddr = ptDevInfo->ptMMRInfo->dwCMTblAddr;
		    //ptMMRInfo->dwIntraPredAddr = ptDevInfo->ptMMRInfo->dwIntraPredAddr;
		    //ptMMRInfo->dwMBNumInfo = ptDevInfo->ptMMRInfo->dwMBNumInfo;
		    //ptMMRInfo->dwSizeInfo = ptDevInfo->ptMMRInfo->dwSizeInfo;
		    //ptMMRInfo->dwQuantInfo = ptDevInfo->ptMMRInfo->dwQuantInfo;
		    ptMMRInfo->dwBSSizeInfo = ptDevInfo->ptMMRInfo->dwBSSizeInfo;
		    ptMMRInfo->dwPrevSliceInfo0 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo0;
		    ptMMRInfo->dwPrevSliceInfo1 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo1;
		    ptMMRInfo->dwPrevSliceInfo2 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo2;
		    ptMMRInfo->dwPrevSliceInfo3 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo3;
		    ptMMRInfo->dwUnalignMSBs = ptDevInfo->ptMMRInfo->dwUnalignMSBs;
		    ptMMRInfo->dwUnalignLSBs = ptDevInfo->ptMMRInfo->dwUnalignLSBs;
		    ptMMRInfo->dwBinsCnt = ptDevInfo->ptMMRInfo->dwBinsCnt;
#else
		    burst_4w(&(ptDevInfo->ptMMRInfo->dwPrevSliceInfo3), &(ptMMRInfo->dwPrevSliceInfo3));
		    burst_4w(&(ptDevInfo->ptMMRInfo->dwPrevSliceInfo0), &(ptMMRInfo->dwPrevSliceInfo0));
		    burst_4w(&(ptDevInfo->ptMMRInfo->dwSizeInfo), &(ptMMRInfo->dwSizeInfo));
		    burst_4w(&(ptDevInfo->ptMMRInfo->dwVersion), &(ptMMRInfo->dwVersion));
/*
		ptMMRInfo->dwVersion = pttempMMRInfo->dwVersion;
		ptMMRInfo->dwCycles = pttempMMRInfo->dwCycles;
		ptMMRInfo->dwCtrl = pttempMMRInfo->dwCtrl;
		ptMMRInfo->dwStat = pttempMMRInfo->dwStat;
		ptMMRInfo->dwBSSizeInfo = pttempMMRInfo->dwBSSizeInfo;
		ptMMRInfo->dwPrevSliceInfo0 = pttempMMRInfo->dwPrevSliceInfo0;
		ptMMRInfo->dwPrevSliceInfo1 = pttempMMRInfo->dwPrevSliceInfo1;
		ptMMRInfo->dwPrevSliceInfo2 = pttempMMRInfo->dwPrevSliceInfo2;
		ptMMRInfo->dwPrevSliceInfo3 = pttempMMRInfo->dwPrevSliceInfo3;
		ptMMRInfo->dwUnalignMSBs = pttempMMRInfo->dwUnalignMSBs;
		ptMMRInfo->dwUnalignLSBs = pttempMMRInfo->dwUnalignLSBs;
		ptMMRInfo->dwBinsCnt = pttempMMRInfo->dwBinsCnt;
*/
#endif
		    //ptMMRInfo->dwCoeffCost = ptDevInfo->ptMMRInfo->dwCoeffCost;
		    //ptMMRInfo->dwMEBECodingCtrl = ptDevInfo->ptMMRInfo->dwMEBECodingCtrl;
		    //ptMMRInfo->dwMEBEVLCOutAddr = ptDevInfo->ptMMRInfo->dwMEBEVLCOutAddr;
		    //ptMMRInfo->dwMEBETblAddr = ptDevInfo->ptMMRInfo->dwMEBETblAddr;
		    //ptMMRInfo->dwMEBEMBNum = ptDevInfo->ptMMRInfo->dwMEBEMBNum;
		    /*if (ptDevInfo->dwSysCtrlVersion != 0x8010002) // Mozart V2
		    {
		    	ptMMRInfo->dwMEBEWidthBuffSize = ptDevInfo->ptMMRInfo->dwMEBEWidthBuffSize;
		    	ptMMRInfo->dwMEBEQuantBuffSize = ptDevInfo->ptMMRInfo->dwMEBEQuantBuffSize;
		    	ptMMRInfo->dwMEBEVPPacketSize = ptDevInfo->ptMMRInfo->dwMEBEVPPacketSize;
		    	ptMMRInfo->dwMEBEVPInfoVPNum = ptDevInfo->ptMMRInfo->dwMEBEVPInfoVPNum;
		    	ptMMRInfo->dwMEBEVPHdrInfo = ptDevInfo->ptMMRInfo->dwMEBEVPHdrInfo;
		    	ptMMRInfo->dwMEBEVPExtHdrInfo = ptDevInfo->ptMMRInfo->dwMEBEVPExtHdrInfo;
		    }*/
		    //ptMMRInfo->dwIntraPredModeEnCtrl = ptDevInfo->ptMMRInfo->dwIntraPredModeEnCtrl;
		    //ptMMRInfo->dwMBRefreshInfo = ptDevInfo->ptMMRInfo->dwMBRefreshInfo;
		    //ptMMRInfo->dwFmeBlkDisCtrl = ptDevInfo->ptMMRInfo->dwFmeBlkDisCtrl;
		    //ptMMRInfo->dwLambdaQModeCost = ptDevInfo->ptMMRInfo->dwLambdaQModeCost;
		    //if (ptDevInfo->dwSysCtrlVersion != 0x8010002) // Mozart V2
		    {
		    	// Bee(0x5000000), Mozart III(0x8040000), Paganini
    	    	//ptMMRInfo->dwObjectInfoAddr = ptDevInfo->ptMMRInfo->dwObjectInfoAddr;
    	    	//ptMMRInfo->dwObjectInfoReserve = ptDevInfo->ptMMRInfo->dwObjectInfoReserve;
    	    	//ptMMRInfo->dwObjectMBsStride = ptDevInfo->ptMMRInfo->dwObjectMBsStride;
    	    	//ptMMRInfo->dwDeblocAhbTsfConfig = ptDevInfo->ptMMRInfo->dwDeblocAhbTsfConfig;
    	    	ptMMRInfo->dwH4eeConfigInfo0 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo0;
    	    	ptMMRInfo->dwH4eeConfigInfo1 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo1;
    	    	ptMMRInfo->dwH4eeConfigInfo2 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo2;
    	    	ptMMRInfo->dwH4eeConfigInfo3 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo3;
    	    	ptMMRInfo->dwH4eeConfigInfo4 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo4;
    	    	ptMMRInfo->dwH4eeConfigInfo5 = ptDevInfo->ptMMRInfo->dwH4eeConfigInfo5;
		    		//ptMMRInfo->dwCarApp00 = ptDevInfo->ptMMRInfo->dwCarApp00;
		    		//ptMMRInfo->dwCarApp01 = ptDevInfo->ptMMRInfo->dwCarApp01;
		    		//ptMMRInfo->dwCarApp02 = ptDevInfo->ptMMRInfo->dwCarApp02;
		    		//ptMMRInfo->dwCarApp03 = ptDevInfo->ptMMRInfo->dwCarApp03;
		    		//ptMMRInfo->dwDecodingInfo = ptDevInfo->ptMMRInfo->dwDecodingInfo;
		    		//ptMMRInfo->dwRecRefStride = ptDevInfo->ptMMRInfo->dwRecRefStride;
		    		//ptMMRInfo->dwExChmrDblkUpAddr = ptDevInfo->ptMMRInfo->dwExChmrDblkUpAddr;
		    		//ptMMRInfo->dwChmrDeblockAddr = ptDevInfo->ptMMRInfo->dwChmrDeblockAddr;
		    		//ptMMRInfo->dwChmrFwdRef0Addr = ptDevInfo->ptMMRInfo->dwChmrFwdRef0Addr;
		    		//ptMMRInfo->dwChmrFwdRef1Addr = ptDevInfo->ptMMRInfo->dwChmrFwdRef1Addr;

    	    	ptMMRInfo->dwMeDisableTbl = ptDevInfo->ptMMRInfo->dwMeDisableTbl;
    	    	//ptMMRInfo->dwConfigCycleUsed = ptDevInfo->ptMMRInfo->dwConfigCycleUsed;
		    		//ptMMRInfo->dwTemp00 = ptDevInfo->ptMMRInfo->dwTemp00;
		    		//ptMMRInfo->dwTemp01 = ptDevInfo->ptMMRInfo->dwTemp01;
		    		//ptMMRInfo->dwOsdCurrLumaAddrpt = DevInfo->ptMMRInfo->dwOsdCurrLumaAddr;
		    		//ptMMRInfo->dwOsdCurrChmaAddrpt = DevInfo->ptMMRInfo->dwOsdCurrChmaAddr;
		    		//ptMMRInfo->dwOsdCurrChmrAddrpt = DevInfo->ptMMRInfo->dwOsdCurrChmrAddr;
		    		//ptMMRInfo->dwOsdSizeInfo = ptDevInfo->ptMMRInfo->dwOsdSizeInfo;
		    		//ptMMRInfo->dwOsdStrideInfo = ptDevInfo->ptMMRInfo->dwOsdStrideInfo;
		    }
		}
		//VMA_H4EE_Reset(hDevInfo);
	}
	else
	{
		TVMAH4DEInfo *ptMMRDecInfo = (TVMAH4DEInfo*)ptDevInfo->aptMMRInfo[dwReadIndex];
		if (ptMMRDecInfo != NULL)
		{
		    //printk("[ISRHead] dec mode != NULL go\n");

			//ptMMRDecInfo->dwVersion = ptDevInfo->ptMMRDecInfo->dwVersion;
			//ptMMRDecInfo->dwCycles = ptDevInfo->ptMMRDecInfo->dwCycles;
			//ptMMRDecInfo->dwCtrl = ptDevInfo->ptMMRDecInfo->dwCtrl;
			//ptMMRDecInfo->dwStat = ptDevInfo->ptMMRDecInfo->dwStat;
			burst_4w(&(ptDevInfo->ptMMRDecInfo->dwVersion), &(ptMMRDecInfo->dwVersion));

			//printk("ISRHead before ptDevInfo->ptMMRDecInfo->dwStat =  0x%08x!!\n", (int)ptDevInfo->ptMMRDecInfo->dwStat);
			//printk("ISRHead before ptMMRDecInfo->dwStat =  0x%08x!!\n", (int)ptMMRDecInfo->dwStat);

			ptMMRDecInfo->dwLumaCurrAddr = ptDevInfo->ptMMRDecInfo->dwLumaCurrAddr;
			ptMMRDecInfo->dwChromaCurrAddr = ptDevInfo->ptMMRDecInfo->dwChromaCurrAddr;
			ptMMRDecInfo->dwBlockCurrAddr = ptDevInfo->ptMMRDecInfo->dwBlockCurrAddr;
			ptMMRDecInfo->dwAHBAccessMBNum = ptDevInfo->ptMMRDecInfo->dwAHBAccessMBNum;
			ptMMRDecInfo->dwMBInfoAddr = ptDevInfo->ptMMRDecInfo->dwMBInfoAddr;
			ptMMRDecInfo->dwColMBInfoAddr = ptDevInfo->ptMMRDecInfo->dwColMBInfoAddr;
			ptMMRDecInfo->dwList0RefAddr00 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr00;
			ptMMRDecInfo->dwList0RefAddr01 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr01;
			ptMMRDecInfo->dwList0RefAddr02 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr02;
			ptMMRDecInfo->dwList0RefAddr03 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr03;
			ptMMRDecInfo->dwList0RefAddr04 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr04;
			ptMMRDecInfo->dwList0RefAddr05 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr05;
			ptMMRDecInfo->dwList0RefAddr06 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr06;
			ptMMRDecInfo->dwList0RefAddr07 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr07;
			ptMMRDecInfo->dwList0RefAddr08 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr08;
			ptMMRDecInfo->dwList0RefAddr09 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr09;
			ptMMRDecInfo->dwList0RefAddr10 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr10;
			ptMMRDecInfo->dwList0RefAddr11 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr11;
			ptMMRDecInfo->dwList0RefAddr12 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr12;
			ptMMRDecInfo->dwList0RefAddr13 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr13;
			ptMMRDecInfo->dwList0RefAddr14 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr14;
			ptMMRDecInfo->dwList0RefAddr15 = ptDevInfo->ptMMRDecInfo->dwList0RefAddr15;
			ptMMRDecInfo->dwList1RefAddr00 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr00;
			ptMMRDecInfo->dwList1RefAddr01 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr01;
			ptMMRDecInfo->dwList1RefAddr02 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr02;
			ptMMRDecInfo->dwList1RefAddr03 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr03;
			ptMMRDecInfo->dwList1RefAddr04 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr04;
			ptMMRDecInfo->dwList1RefAddr05 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr05;
			ptMMRDecInfo->dwList1RefAddr06 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr06;
			ptMMRDecInfo->dwList1RefAddr07 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr07;
			ptMMRDecInfo->dwList1RefAddr08 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr08;
			ptMMRDecInfo->dwList1RefAddr09 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr09;
			ptMMRDecInfo->dwList1RefAddr10 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr10;
			ptMMRDecInfo->dwList1RefAddr11 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr11;
			ptMMRDecInfo->dwList1RefAddr12 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr12;
			ptMMRDecInfo->dwList1RefAddr13 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr13;
			ptMMRDecInfo->dwList1RefAddr14 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr14;
			ptMMRDecInfo->dwList1RefAddr15 = ptDevInfo->ptMMRDecInfo->dwList1RefAddr15;
			ptMMRDecInfo->dwList1ColMBInfoAddr = ptDevInfo->ptMMRDecInfo->dwList1ColMBInfoAddr;
			ptMMRDecInfo->dwIntraDepredAddr = ptDevInfo->ptMMRDecInfo->dwIntraDepredAddr;

			//ptMMRDecInfo->dwDeblockAddr = ptDevInfo->ptMMRDecInfo->dwDeblockAddr;
			//ptMMRDecInfo->dwBSCtrl = ptDevInfo->ptMMRDecInfo->dwBSCtrl;
			//ptMMRDecInfo->dwBSCurrAddr = ptDevInfo->ptMMRDecInfo->dwBSCurrAddr;
			//ptMMRDecInfo->dwBSValidSize = ptDevInfo->ptMMRDecInfo->dwBSValidSize;
			burst_4w(&(ptDevInfo->ptMMRDecInfo->dwDeblockAddr), &(ptMMRDecInfo->dwDeblockAddr));

			//ptMMRDecInfo->dwBSLowBoundAddr = ptDevInfo->ptMMRDecInfo->dwBSLowBoundAddr;
			//ptMMRDecInfo->dwBSUpBoundAddr = ptDevInfo->ptMMRDecInfo->dwBSUpBoundAddr;
			//ptMMRDecInfo->dwBSDecSize = ptDevInfo->ptMMRDecInfo->dwBSDecSize;
			//ptMMRDecInfo->dwCMTblAddr = ptDevInfo->ptMMRDecInfo->dwCMTblAddr;
			burst_4w(&(ptDevInfo->ptMMRDecInfo->dwBSLowBoundAddr), &(ptMMRDecInfo->dwBSLowBoundAddr));
			//printk("ptDevInfo->ptMMRDecInfo->dwBSDecSize =%d\n", ptMMRDecInfo->dwBSDecSize);

			ptMMRDecInfo->dwWeightScaleTblAddr = ptDevInfo->ptMMRDecInfo->dwWeightScaleTblAddr;
			ptMMRDecInfo->dwPredWeightTblAddr = ptDevInfo->ptMMRDecInfo->dwPredWeightTblAddr;
			ptMMRDecInfo->dwFrameSizeInfo0 = ptDevInfo->ptMMRDecInfo->dwFrameSizeInfo0;
			ptMMRDecInfo->dwFrameSizeInfo1 = ptDevInfo->ptMMRDecInfo->dwFrameSizeInfo1;
			ptMMRDecInfo->dwCrCurrAddr = ptDevInfo->ptMMRDecInfo->dwCrCurrAddr;

			//ptMMRDecInfo->dwOPCycleLimitation = ptDevInfo->ptMMRDecInfo->dwOPCycleLimitation;

			//*pdwOPcyclelimit = ptDevInfo->ptMMRDecInfo->dwOPCycleLimitation;
			//PDEBUG("ISRHead ptDevInfo->ptMMRDecInfo->dwOPCycleLimitation =  0x%08x!!\n", (int)ptDevInfo->ptMMRDecInfo->dwOPCycleLimitation);

			ptMMRDecInfo->dwSPSInfo = ptDevInfo->ptMMRDecInfo->dwSPSInfo;
			ptMMRDecInfo->dwPPSInfo = ptDevInfo->ptMMRDecInfo->dwPPSInfo;
			ptMMRDecInfo->dwSliceInfo00 = ptDevInfo->ptMMRDecInfo->dwSliceInfo00;
			ptMMRDecInfo->dwSliceInfo01 = ptDevInfo->ptMMRDecInfo->dwSliceInfo01;
			ptMMRDecInfo->dwSliceInfo02 = ptDevInfo->ptMMRDecInfo->dwSliceInfo02;
			ptMMRDecInfo->dwSliceInfo03 = ptDevInfo->ptMMRDecInfo->dwSliceInfo03;
			ptMMRDecInfo->dwSliceInfo04 = ptDevInfo->ptMMRDecInfo->dwSliceInfo04;
			ptMMRDecInfo->dwSliceInfo05 = ptDevInfo->ptMMRDecInfo->dwSliceInfo05;
			ptMMRDecInfo->dwSliceInfo06 = ptDevInfo->ptMMRDecInfo->dwSliceInfo06;
			ptMMRDecInfo->dwSliceInfo07 = ptDevInfo->ptMMRDecInfo->dwSliceInfo07;
			ptMMRDecInfo->dwSliceInfo08 = ptDevInfo->ptMMRDecInfo->dwSliceInfo08;
			ptMMRDecInfo->dwSliceInfo09 = ptDevInfo->ptMMRDecInfo->dwSliceInfo09;
			ptMMRDecInfo->dwSliceInfo10 = ptDevInfo->ptMMRDecInfo->dwSliceInfo10;
			ptMMRDecInfo->dwLTInfo = ptDevInfo->ptMMRDecInfo->dwLTInfo;
			ptMMRDecInfo->dwCurrL0RefIdxPOC00 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC00;
			ptMMRDecInfo->dwCurrL0RefIdxPOC01 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC01;
			ptMMRDecInfo->dwCurrL0RefIdxPOC02 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC02;
			ptMMRDecInfo->dwCurrL0RefIdxPOC03 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC03;
			ptMMRDecInfo->dwCurrL0RefIdxPOC04 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC04;
			ptMMRDecInfo->dwCurrL0RefIdxPOC05 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC05;
			ptMMRDecInfo->dwCurrL0RefIdxPOC06 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC06;
			ptMMRDecInfo->dwCurrL0RefIdxPOC07 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC07;
			ptMMRDecInfo->dwCurrL0RefIdxPOC08 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC08;
			ptMMRDecInfo->dwCurrL0RefIdxPOC09 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC09;
			ptMMRDecInfo->dwCurrL0RefIdxPOC10 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC10;
			ptMMRDecInfo->dwCurrL0RefIdxPOC11 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC11;
			ptMMRDecInfo->dwCurrL0RefIdxPOC12 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC12;
			ptMMRDecInfo->dwCurrL0RefIdxPOC13 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC13;
			ptMMRDecInfo->dwCurrL0RefIdxPOC14 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC14;
			ptMMRDecInfo->dwCurrL0RefIdxPOC15 = ptDevInfo->ptMMRDecInfo->dwCurrL0RefIdxPOC15;
			ptMMRDecInfo->dwCurrL1RefIdxPOC00 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC00;
			ptMMRDecInfo->dwCurrL1RefIdxPOC01 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC01;
			ptMMRDecInfo->dwCurrL1RefIdxPOC02 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC02;
			ptMMRDecInfo->dwCurrL1RefIdxPOC03 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC03;
			ptMMRDecInfo->dwCurrL1RefIdxPOC04 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC04;
			ptMMRDecInfo->dwCurrL1RefIdxPOC05 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC05;
			ptMMRDecInfo->dwCurrL1RefIdxPOC06 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC06;
			ptMMRDecInfo->dwCurrL1RefIdxPOC07 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC07;
			ptMMRDecInfo->dwCurrL1RefIdxPOC08 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC08;
			ptMMRDecInfo->dwCurrL1RefIdxPOC09 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC09;
			ptMMRDecInfo->dwCurrL1RefIdxPOC10 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC10;
			ptMMRDecInfo->dwCurrL1RefIdxPOC11 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC11;
			ptMMRDecInfo->dwCurrL1RefIdxPOC12 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC12;
			ptMMRDecInfo->dwCurrL1RefIdxPOC13 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC13;
			ptMMRDecInfo->dwCurrL1RefIdxPOC14 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC14;
			ptMMRDecInfo->dwCurrL1RefIdxPOC15 = ptDevInfo->ptMMRDecInfo->dwCurrL1RefIdxPOC15;
			ptMMRDecInfo->dwIOVectorStartAddr = ptDevInfo->ptMMRDecInfo->dwIOVectorStartAddr;
			ptMMRDecInfo->dwIOVectorEndAddr = ptDevInfo->ptMMRDecInfo->dwIOVectorEndAddr;
			ptMMRDecInfo->dwConfigCycleUsed = ptDevInfo->ptMMRDecInfo->dwConfigCycleUsed;


			//printk("ISRHead dwReadIndex = %d, dwStat =  0x%08x!!\n", (int)dwReadIndex, (int)dwCurrStatus);
			//ptMMRDecInfo->dwStat = ptMMRDecInfo->dwStat;


			if ((ptMMRDecInfo->dwStat & 0x8000007C))
			{
				PDEBUG("h4de error, reset !!\n");
				VMA_H4EE_Reset(hDevInfo);
			}

	        //VMA_H4EE_Reset(hDevInfo);
		}
    }


	ptDevInfo->dwReadIndex = (dwReadIndex+1) & VMA_H4EE_MMR_BUFF_MASK;

	bEncMode = ptDevInfo->abEnc[ptDevInfo->dwReadIndex];

	/*if (ptDevInfo->abEnc[ptDevInfo->dwReadIndex] != ptDevInfo->abEnc[dwReadIndex])
	{
		VMA_H4EE_Reset(hDevInfo);
	}*/

	//need this one??
	//if (ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex] != ptDevInfo->aptMMRInfo[dwReadIndex])
	//	VMA_H4EE_Reset(hDevInfo);

	if (ptDevInfo->dwReadIndex != ptDevInfo->dwWriteIndex)
	{
		if (bEncMode)
		{
			vma_h4ee_copy_mmr(ptDevInfo->ptMMRInfo, ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex]);
		}
		else
		{
			vma_h4de_copy_mmr(ptDevInfo->ptMMRDecInfo, ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex]);
		 }
	}
	else
	{
		//*ptDevInfo->pdwClkEnMmr = (*ptDevInfo->pdwClkEnMmr) & (~(0x1<<VMA_H4EE_CLK_EN_NUM));
		clk_disable(ptDevInfo->pClk);
		ptDevInfo->bBusy = FALSE;
	}

	return dwReadIndex;
}

void VMA_H4EE_SetChipVersionInfo(HANDLE hDevInfo)
{
	TVMAH4EEDevInfo *ptDevInfo = (TVMAH4EEDevInfo *)hDevInfo;
	DWORD *pdwSysCtrl;

	pdwSysCtrl = (DWORD *)IO_ADDRESS(VPL_SYSC_MMR_BASE);
    ptDevInfo->dwSysCtrlVersion = readl(pdwSysCtrl);
    PDEBUG("[SetChipVersionInfo]ptDevInfo->dwSysCtrlVersion = %8x\n", ptDevInfo->dwSysCtrlVersion);
}
/* ============================================================================================== */
