/*
 * $Header: /rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE/vma_ispe.h 12    15/03/11 1:46p Curt.tsao $
 *
 * vma_ispe
 * Driver for VMA ISPE
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vma_ispe.h $
 * 
 * *****************  Version 12  *****************
 * User: Curt.tsao    Date: 15/03/11   Time: 1:46p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 11  *****************
 * User: Curt.tsao    Date: 15/03/11   Time: 1:21p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 10  *****************
 * User: Curt.tsao    Date: 14/11/28   Time: 11:12a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 9  *****************
 * User: Curt.tsao    Date: 14/04/16   Time: 6:07p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 8  *****************
 * User: Curt.tsao    Date: 14/04/16   Time: 4:28p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 7  *****************
 * User: Curt.tsao    Date: 14/03/14   Time: 4:44p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 6  *****************
 * User: Curt.tsao    Date: 14/02/12   Time: 11:05a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 5  *****************
 * User: Curt.tsao    Date: 14/01/15   Time: 3:27p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 4  *****************
 * User: Curt.tsao    Date: 13/12/18   Time: 11:07a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 3  *****************
 * User: Linus.huang  Date: 13/09/16   Time: 9:13p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 2  *****************
 * User: Linus.huang  Date: 13/04/10   Time: 4:22p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 1  *****************
 * User: Linus.huang  Date: 13/03/26   Time: 10:24a
 * Created in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 *
 */

/* ============================================================================================== */
#ifndef __VMA_ISPE_H__
#define __VMA_ISPE_H__

/* ============================================================================================== */
#include <linux/ioctl.h>

#include "typedef.h"
#include "vivo_codec.h"

/* ============================================================================================== */
#define VMA_ISPE_VERSION MAKEFOURCC(7, 0, 0, 1)
#define VMA_ISPE_ID_VERSION "7.0.0.1"

/* ============================================================================================== */

#define VMA_ISPE_MASTER_0_BUS_NUM	1
#define VMA_ISPE_MASTER_1_BUS_NUM	1

#define VMA_ISPE_MASTER_0_MASTER_NUM	0x0C
#define VMA_ISPE_MASTER_1_MASTER_NUM	0x0D

/* ============================================================================================== */
typedef struct vma_ispe_info
{
	DWORD adwReserved[509];
} TVMAISPEInfo;

typedef struct vma_ispe_hw_info
{
	DWORD adwReserved[363];
} TVMAISPEHWInfo;

/* ============================================================================================== */
#define VMA_ISPE_IOC_MAGIC 228

#define VMA_ISPE_IOC_START						_IOW	(VMA_ISPE_IOC_MAGIC, 0, DWORD)
#define VMA_ISPE_IOC_WAIT_COMPLETE				_IO		(VMA_ISPE_IOC_MAGIC, 1)
#define VMA_ISPE_IOC_SHARE_MMR_INFO_SPACE		_IOW	(VMA_ISPE_IOC_MAGIC, 2, DWORD)
#define VMA_ISPE_IOC_GET_VERSION_NUMBER			_IOR	(VMA_ISPE_IOC_MAGIC, 3, DWORD)
#define VMA_ISPE_IOC_MASTER_0_GET_BANDWIDTH		_IOR	(VMA_ISPE_IOC_MAGIC, 4, DWORD)
#define VMA_ISPE_IOC_MASTER_0_GET_RG_INTERVAL	_IOR	(VMA_ISPE_IOC_MAGIC, 5, DWORD)
#define VMA_ISPE_IOC_MASTER_0_GET_REQ_TIMES		_IOR	(VMA_ISPE_IOC_MAGIC, 6, DWORD)
#define VMA_ISPE_IOC_MASTER_0_CLEAR_PROFILE		_IO		(VMA_ISPE_IOC_MAGIC, 7)
#define VMA_ISPE_IOC_MASTER_1_GET_BANDWIDTH		_IOR	(VMA_ISPE_IOC_MAGIC, 8, DWORD)
#define VMA_ISPE_IOC_MASTER_1_GET_RG_INTERVAL	_IOR	(VMA_ISPE_IOC_MAGIC, 9, DWORD)
#define VMA_ISPE_IOC_MASTER_1_GET_REQ_TIMES		_IOR	(VMA_ISPE_IOC_MAGIC, 10, DWORD)
#define VMA_ISPE_IOC_MASTER_1_CLEAR_PROFILE		_IO		(VMA_ISPE_IOC_MAGIC, 11)
#define VMA_ISPE_IOC_RESET						_IO		(VMA_ISPE_IOC_MAGIC, 12)

#define VMA_ISPE_IOC_MAX_NUMBER	12

/* ============================================================================================== */
#endif //__VMA_ISPE_H__

/* ============================================================================================== */
