/*
 * $Header: /rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE/vma_ispe_driver.h 4     14/11/28 11:12a Curt.tsao $
 *
 * vma_ispe
 * Driver for VMA ISPE
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vma_ispe_driver.h $
 * 
 * *****************  Version 4  *****************
 * User: Curt.tsao    Date: 14/11/28   Time: 11:12a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 3  *****************
 * User: Curt.tsao    Date: 14/01/15   Time: 3:26p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 2  *****************
 * User: Linus.huang  Date: 13/04/17   Time: 2:49p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 1  *****************
 * User: Linus.huang  Date: 13/03/26   Time: 10:24a
 * Created in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 *
 */

/* ============================================================================================== */
#ifndef __VMA_ISPE_DRIVER_H__
#define __VMA_ISPE_DRIVER_H__

/* ============================================================================================== */
#include <linux/interrupt.h>
#include <linux/mm.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/ioctl.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/irqdomain.h>
#include <linux/clk.h>
#ifdef __USE_SWAIT__
#include <linux/swait.h>
#endif
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/cache.h>
#include <mach/platform.h>

#include "vma_ispe.h"

//#define SYSC_CLK_EN_MMR (IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x94)
//#define VMA_ISPE_CLK_EN_NUM 0x1B

/* ============================================================================================== */
#undef PDEBUG
#ifdef _DEBUG
	#ifdef __KERNEL__
		#define LOGLEVEL KERN_DEBUG
		#define PDEBUG(fmt, args...) printk(LOGLEVEL "VMA_ISPE: " fmt, ## args)
	#else
		#define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
	#endif
#else
	#define PDEBUG(fmt, args...)
#endif

/* ============================================================================================== */
#define VMA_ISPE_MMR_BUFF_NUM 32
#define VMA_ISPE_MMR_BUFF_MASK 31


/* ============================================================================================== */
extern struct file_operations vma_ispe_fops;

/* ============================================================================================== */
typedef struct vma_ispe_obj_info
{
	HANDLE hProfileInfo;

	TVMAISPEInfo *ptMMRInfo;

	DWORD dwMMRInfoPhyAddr;
	DWORD dwWriteIndex;
} TVMAISPEObjInfo;

/* ============================================================================================== */
typedef struct vma_ispe_shared_info
{
	HANDLE hDevInfo;

	DWORD dwIrq;

#ifdef __USE_SWAIT__
	struct swait_queue_head atWaitQueueHead[VMA_ISPE_MMR_BUFF_NUM];
#else
	wait_queue_head_t atWaitQueueHead[VMA_ISPE_MMR_BUFF_NUM];
#endif

	volatile BOOL abIntr[VMA_ISPE_MMR_BUFF_NUM];
	volatile BOOL abWriteEn[VMA_ISPE_MMR_BUFF_NUM];

	struct clk *pClk;
	struct mutex ioctl_lock;
} TVMAISPESharedInfo;

/* ============================================================================================== */
DWORD VMA_ISPE_GetDevInfoSize(void);
SCODE VMA_ISPE_SetMMRInfo(HANDLE, volatile TVMAISPEHWInfo *, struct clk *, volatile DWORD *);
DWORD VMA_ISPE_GetMMRInfo(HANDLE);
SCODE VMA_ISPE_InitProfileInfo(TVMAISPEObjInfo *);
SCODE VMA_ISPE_GetProfileInfo(HANDLE, TVMAISPEObjInfo *, DWORD);
SCODE VMA_ISPE_InitProfile(HANDLE);
SCODE VMA_ISPE_CloseProfile(HANDLE);
SCODE VMA_ISPE_SetupProfile(TVMAISPEObjInfo *, DWORD, DWORD);

DWORD VMA_ISPE_GetVersion(HANDLE);
DWORD VMA_ISPE_StartHead(HANDLE);
void VMA_ISPE_StartTail(HANDLE, DWORD, TVMAISPEInfo *);
void VMA_ISPE_IntrEnable(HANDLE);
void VMA_ISPE_IntrDisable(HANDLE);
void VMA_ISPE_IntrClear(HANDLE);
void VMA_ISPE_Reset(HANDLE);
void VMA_ISPE_Open(HANDLE);
DWORD VMA_ISPE_ISR(HANDLE);
//void VMA_ISPE_ISRTail(HANDLE, DWORD);

/* ============================================================================================== */
#endif //__VMA_ISPE_DRIVER_H__

/* ============================================================================================== */
