/*
 * $Header: /rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE/vma_ispe_locals.c 16    15/03/11 1:58p Curt.tsao $
 *
 * Copyright 2007-2012 VATICS Inc. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.4.0.13.
 *
 * $History: vma_ispe_locals.c $
 * 
 * *****************  Version 16  *****************
 * User: Curt.tsao    Date: 15/03/11   Time: 1:58p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 15  *****************
 * User: Curt.tsao    Date: 14/11/28   Time: 11:12a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 14  *****************
 * User: Curt.tsao    Date: 14/08/01   Time: 2:11p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 13  *****************
 * User: Curt.tsao    Date: 14/04/16   Time: 6:07p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 12  *****************
 * User: Curt.tsao    Date: 14/04/16   Time: 4:23p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 1. MODIFICATION: Freeze bit 03-12 in Ctrl MMR - DONE.
 * 
 * *****************  Version 11  *****************
 * User: Curt.tsao    Date: 14/04/11   Time: 5:30p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 10  *****************
 * User: Curt.tsao    Date: 14/03/14   Time: 4:45p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 1. MODIFICATION: Add freeze mode flag from hardware MMR - DONE.
 * 
 * *****************  Version 9  *****************
 * User: Curt.tsao    Date: 14/02/14   Time: 4:47p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 8  *****************
 * User: Curt.tsao    Date: 14/02/14   Time: 10:41a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 7  *****************
 * User: Curt.tsao    Date: 14/02/12   Time: 6:57p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 6  *****************
 * User: Curt.tsao    Date: 14/02/12   Time: 11:05a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 5  *****************
 * User: Curt.tsao    Date: 14/01/15   Time: 3:26p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 4  *****************
 * User: Curt.tsao    Date: 13/12/18   Time: 11:08a
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 3  *****************
 * User: Linus.huang  Date: 13/09/16   Time: 9:13p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 2  *****************
 * User: Linus.huang  Date: 13/04/10   Time: 4:22p
 * Updated in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 * 
 * *****************  Version 1  *****************
 * User: Linus.huang  Date: 13/03/26   Time: 10:25a
 * Created in $/rd_2/project/SoC/Components/ISPE/Device_Driver/ISPE
 *
 */

/* ============================================================================================== */
#include "vma_ispe_locals.h"

/* ============================================================================================== */
DWORD VMA_ISPE_GetDevInfoSize(void)
{
	return sizeof(TVMAISPEDevInfo);
}

/* ============================================================================================== */
SCODE VMA_ISPE_SetMMRInfo(HANDLE hDevInfo, volatile TVMAISPEHWInfo *ptHWMMRInfo, struct clk *pClk, volatile DWORD *pdwRstEnMmr)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->ptHWMMRInfo = (TVMAISPEHWInterInfo *)ptHWMMRInfo;
	ptDevInfo->pClk = pClk;
	ptDevInfo->pdwRstEnMmr = pdwRstEnMmr;
	ptDevInfo->dwVersionNum = ptDevInfo->ptHWMMRInfo->dwVersion;

	if ((ptDevInfo->ptHWMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptHWMMRInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VMA_ISPE_GetMMRInfo(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptHWMMRInfo);
}

/* ============================================================================================== */
#ifdef __PROFILE__
SCODE VMA_ISPE_InitProfileInfo(TVMAISPEObjInfo *ptObjInfo)
{
	DWORD dwProfileInfoSize;

	dwProfileInfoSize = sizeof(TVMAISPEProfileInfo);
	if ((ptObjInfo->hProfileInfo=(HANDLE)kmalloc(dwProfileInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate profile info buffer fail !!");
		return -ENOMEM;
	}
	memset(ptObjInfo->hProfileInfo, 0, dwProfileInfoSize);

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_ISPE_InitProfile(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD), "VMA_ISPE Profile Clear");
	ptDevInfo->apdwProfileClr[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Bandwidth");
	ptDevInfo->apdwBandwidth[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Request Grant Interval");
	ptDevInfo->apdwRGInterval[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Request Times");
	ptDevInfo->apdwReqTimes[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD), "VMA_ISPE Profile Clear");
	ptDevInfo->apdwProfileClr[1] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Bandwidth");
	ptDevInfo->apdwBandwidth[1] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Request Grant Interval");
	ptDevInfo->apdwRGInterval[1] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_ISPE Request Times");
	ptDevInfo->apdwReqTimes[1] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_ISPE_GetProfileInfo(HANDLE hDevInfo, TVMAISPEObjInfo *ptObjInfo, DWORD dwWriteIndex)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;
	TVMAISPEProfileInfo *ptProfileInfo = (TVMAISPEProfileInfo *)ptObjInfo->hProfileInfo;

	ptProfileInfo->adwBandwidth[0] = ptDevInfo->aadwBandwidth[dwWriteIndex][0];
	ptProfileInfo->adwRGInterval[0] = ptDevInfo->aadwRGInterval[dwWriteIndex][0];
	ptProfileInfo->adwReqTimes[0] = ptDevInfo->aadwReqTimes[dwWriteIndex][0];
	ptProfileInfo->adwBandwidth[1] = ptDevInfo->aadwBandwidth[dwWriteIndex][1];
	ptProfileInfo->adwRGInterval[1] = ptDevInfo->aadwRGInterval[dwWriteIndex][1];
	ptProfileInfo->adwReqTimes[1] = ptDevInfo->aadwReqTimes[dwWriteIndex][1];
	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_ISPE_CloseProfile(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	if (ptDevInfo->apdwProfileClr[0] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[0] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[0] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[0] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwProfileClr[1] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[1]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[1] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[1]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[1] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[1]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[1] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[1]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_ISPE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_ISPE_SetupProfile(TVMAISPEObjInfo *ptObjInfo, DWORD dwArg, DWORD dwCmd)
{
	TVMAISPEProfileInfo *ptProfileInfo = (TVMAISPEProfileInfo *)ptObjInfo->hProfileInfo;

	switch (dwCmd)
	{
		case VMA_ISPE_IOC_MASTER_0_GET_BANDWIDTH:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[0], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_0_GET_RG_INTERVAL:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[0], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_0_GET_REQ_TIMES:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[0], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_0_CLEAR_PROFILE:
		break;
		case VMA_ISPE_IOC_MASTER_1_GET_BANDWIDTH:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[1], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_1_GET_RG_INTERVAL:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[1], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_1_GET_REQ_TIMES:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[1], sizeof(DWORD));
		break;
		case VMA_ISPE_IOC_MASTER_1_CLEAR_PROFILE:
		break;
		default:
			return S_FAIL;
	}

	return S_OK;
}

#endif //__PROFILE__

/* ============================================================================================== */
DWORD VMA_ISPE_GetVersion(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	return ptDevInfo->ptHWMMRInfo->dwVersion;
}

/* ============================================================================================== */
DWORD VMA_ISPE_StartHead(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	return ptDevInfo->dwWriteIndex;
}

/* ============================================================================================== */

static inline void vma_ispe_copy_mmr(volatile TVMAISPEHWInterInfo* ptHWMMRInfo, TVMAISPEInterInfo* ptMMRInfo)
{
	DWORD i;
	//BOOL bPTEn = (ptMMRInfo->dwCtrl>>4) & 0x1;
	//BOOL bGCEn = (ptMMRInfo->dwCtrl>>5) & 0x1;
	//BOOL bRTEn = (ptMMRInfo->dwCtrl>>3) & 0x1;
	//BOOL bDIEn = (ptMMRInfo->dwCtrl>>6) & 0x1;
	//BOOL bNR3DEn = (ptMMRInfo->dwCtrl>>7) & 0x1;
	//BOOL bNR2DEn = (ptMMRInfo->dwCtrl>>8) & 0x1;
	//BOOL bMDEn = (ptMMRInfo->dwCtrl>>9) & 0x1;
	//BOOL bEEEn = (ptMMRInfo->dwCtrl>>10) & 0x1;
	//BOOL bPMEn = (ptMMRInfo->dwCtrl>>11) & 0x1;
	//BOOL bRSEn = (ptMMRInfo->dwCtrl>>12) & 0x1;

	const DWORD dwCtrl = ptMMRInfo->dwCtrl;

	ptHWMMRInfo->dwCtrl = dwCtrl;
	ptHWMMRInfo->dwProcSize = ptMMRInfo->dwProcSize;
	ptHWMMRInfo->dwStride = ptMMRInfo->dwStride;

	ptHWMMRInfo->dwBusCtrl = ptMMRInfo->dwBusCtrl;
	//ptDevInfo->ptHWMMRInfo->dwPasscode = ptDevInfo->aptMMRInfo[dwWriteIndex]->dwPasscode;

	ptHWMMRInfo->dwCacheCtrl = ptMMRInfo->dwCacheCtrl;

	//if (bPTEn)
	if ((dwCtrl>>4) & 0x1)
	{
		ptHWMMRInfo->dwPTCtrl = ptMMRInfo->dwPTCtrl;
		ptHWMMRInfo->dwPTSrcSize = ptMMRInfo->dwPTSrcSize;
		ptHWMMRInfo->dwPTStride = ptMMRInfo->dwPTStride;
		ptHWMMRInfo->dwPTGridSize = ptMMRInfo->dwPTGridSize;
		ptHWMMRInfo->dwPTBackgroundColor = ptMMRInfo->dwPTBackgroundColor;
		//port
		//for (i=0; i<33; i++)
		{
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[0];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[1];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[2];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[3];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[4];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[5];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[6];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[7];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[8];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[9];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[10];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[11];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[12];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[13];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[14];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[15];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[16];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[17];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[18];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[19];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[20];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[21];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[22];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[23];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[24];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[25];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[26];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[27];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[28];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[29];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[30];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[31];
			ptHWMMRInfo->dwPTITPFCoeff = ptMMRInfo->dwPTITPFCoeff[32];
		}
		//port
		ptHWMMRInfo->dwPTGridCoeff0 = ptMMRInfo->dwPTGridCoeff0;
		ptHWMMRInfo->dwPTGridCoeff1 = ptMMRInfo->dwPTGridCoeff1;
		ptHWMMRInfo->dwPTGridCoeff2 = ptMMRInfo->dwPTGridCoeff2;
		ptHWMMRInfo->dwPTGridCoeff3 = ptMMRInfo->dwPTGridCoeff3;
		ptHWMMRInfo->dwPTGridCoeff4 = ptMMRInfo->dwPTGridCoeff4;
		ptHWMMRInfo->dwPTGridCoeff5 = ptMMRInfo->dwPTGridCoeff5;
	}
	//else if (bGCEn)
	else if ((dwCtrl>>5) & 0x1)
	{
		ptHWMMRInfo->dwGCCtrl = ptMMRInfo->dwGCCtrl;
		ptHWMMRInfo->dwGCSrcSize = ptMMRInfo->dwGCSrcSize;
		ptHWMMRInfo->dwGCSrcStride = ptMMRInfo->dwGCSrcStride;
		ptHWMMRInfo->dwGCSrcCenter = ptMMRInfo->dwGCSrcCenter;
		ptHWMMRInfo->dwGCBackgroundColor = ptMMRInfo->dwGCBackgroundColor;
		ptHWMMRInfo->dwGCLumaCoeff0 = ptMMRInfo->dwGCLumaCoeff0;
		ptHWMMRInfo->dwGCLumaCoeff1 = ptMMRInfo->dwGCLumaCoeff1;
		ptHWMMRInfo->dwGCLumaCoeff2 = ptMMRInfo->dwGCLumaCoeff2;
		ptHWMMRInfo->dwGCChromaCoeff0 = ptMMRInfo->dwGCChromaCoeff0;
		ptHWMMRInfo->dwGCChromaCoeff1 = ptMMRInfo->dwGCChromaCoeff1;
		ptHWMMRInfo->dwGCChromaCoeff2 = ptMMRInfo->dwGCChromaCoeff2;
		//port
		for (i=0; i<33; i++)
		{
			ptHWMMRInfo->dwGCITPFCoeff = ptMMRInfo->dwGCITPFCoeff[i];
		}
		//port
		ptHWMMRInfo->dwGCSrcOffset = ptMMRInfo->dwGCSrcOffset;

	}
	//else if (bRTEn)
	else if ((dwCtrl>>3) & 0x1)
	{
		ptHWMMRInfo->dwRTCtrl = 	ptMMRInfo->dwRTCtrl;		
		ptHWMMRInfo->dwRTSrcStride = ptMMRInfo->dwRTSrcStride;
	}

	//if (bDIEn)
	if ((dwCtrl>>6) & 0x1)
	{
		ptHWMMRInfo->dwDICtrl = ptMMRInfo->dwDICtrl;
		ptHWMMRInfo->dwDISpatialCtrl = ptMMRInfo->dwDISpatialCtrl;
		ptHWMMRInfo->dwDISpatialMDOIThrGroupA = ptMMRInfo->dwDISpatialMDOIThrGroupA;
		ptHWMMRInfo->dwDISpatialMDOIThrGroupB = ptMMRInfo->dwDISpatialMDOIThrGroupB;
		ptHWMMRInfo->dwDIMACtrl = ptMMRInfo->dwDIMACtrl;
		ptHWMMRInfo->dwDIMAThrGroupA = ptMMRInfo->dwDIMAThrGroupA;
		ptHWMMRInfo->dwDIMAThrGroupB = ptMMRInfo->dwDIMAThrGroupB;
		ptHWMMRInfo->dwDIMAMorphExcludeStartPos = ptMMRInfo->dwDIMAMorphExcludeStartPos;
		ptHWMMRInfo->dwDIMAMorphExcludeEndPos = ptMMRInfo->dwDIMAMorphExcludeEndPos;
	}

	// NR3D, NR2D, and MD have some complex condidtion for hardware control
	ptHWMMRInfo->dwNR2DCtrl = ptMMRInfo->dwNR2DCtrl;
	ptHWMMRInfo->dwNR2DWeightedCoeff = ptMMRInfo->dwNR2DWeightedCoeff;
	ptHWMMRInfo->dwNR2DPostWeightedCoeff = ptMMRInfo->dwNR2DPostWeightedCoeff;
	ptHWMMRInfo->dwNR2DGlobalNoiseLevel = ptMMRInfo->dwNR2DGlobalNoiseLevel;
	ptHWMMRInfo->dwNR2DHybridCtrl = ptMMRInfo->dwNR2DHybridCtrl;
	ptHWMMRInfo->dwNR2DMACurrCtrl = ptMMRInfo->dwNR2DMACurrCtrl;
	ptHWMMRInfo->dwNR2DMARefCtrl = ptMMRInfo->dwNR2DMARefCtrl;
	ptHWMMRInfo->dwNR2DMASlope = ptMMRInfo->dwNR2DMASlope;
	ptHWMMRInfo->dwNR3DCtrl = ptMMRInfo->dwNR3DCtrl;
	ptHWMMRInfo->dwMDCtrl = ptMMRInfo->dwMDCtrl;

	//if (bMDEn)
	if ((dwCtrl>>9) & 0x1)
	{
		//port
		for (i=0; i<3; i++)
		{
			ptHWMMRInfo->adwMDWindowInfo[0] = ptMMRInfo->adwMDWindowInfo[i];
			ptHWMMRInfo->adwMDWindowInfo[1] = ptMMRInfo->adwMDWindowInfo[3+i];
			ptHWMMRInfo->adwMDWindowInfo[2] = ptMMRInfo->adwMDWindowInfo[6+i];
			ptHWMMRInfo->adwMDWindowInfo[3] = ptMMRInfo->adwMDWindowInfo[9+i];
			ptHWMMRInfo->adwMDWindowInfo[4] = ptMMRInfo->adwMDWindowInfo[12+i];
			ptHWMMRInfo->adwMDWindowInfo[5] = ptMMRInfo->adwMDWindowInfo[15+i];
			ptHWMMRInfo->adwMDWindowInfo[6] = ptMMRInfo->adwMDWindowInfo[18+i];
			ptHWMMRInfo->adwMDWindowInfo[7] = ptMMRInfo->adwMDWindowInfo[21+i];
			ptHWMMRInfo->adwMDWindowInfo[8] = ptMMRInfo->adwMDWindowInfo[24+i];
			ptHWMMRInfo->adwMDWindowInfo[9] = ptMMRInfo->adwMDWindowInfo[27+i];
			ptHWMMRInfo->adwMDWindowInfo[10] = ptMMRInfo->adwMDWindowInfo[30+i];
			ptHWMMRInfo->adwMDWindowInfo[11] = ptMMRInfo->adwMDWindowInfo[33+i];
			ptHWMMRInfo->adwMDWindowInfo[12] = ptMMRInfo->adwMDWindowInfo[36+i];
			ptHWMMRInfo->adwMDWindowInfo[13] = ptMMRInfo->adwMDWindowInfo[39+i];
			ptHWMMRInfo->adwMDWindowInfo[14] = ptMMRInfo->adwMDWindowInfo[42+i];
			ptHWMMRInfo->adwMDWindowInfo[15] = ptMMRInfo->adwMDWindowInfo[45+i];
		}
	}
	ptHWMMRInfo->dwEECtrl = ptMMRInfo->dwEECtrl;
	//port
	//for (i=0; i<18; i++)
	{
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[0];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[1];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[2];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[3];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[4];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[5];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[6];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[7];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[8];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[9];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[10];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[11];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[12];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[13];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[14];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[15];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[16];
		ptHWMMRInfo->dwEEHPFCoeff = ptMMRInfo->dwEEHPFCoeff[17];
	}
	ptHWMMRInfo->dwDPCCtrl = ptMMRInfo->dwDPCCtrl;
	ptHWMMRInfo->dwDPCVarianceWeightCurve = ptMMRInfo->dwDPCVarianceWeightCurve;
	ptHWMMRInfo->dwDPCDistanceWeightCurve = ptMMRInfo->dwDPCDistanceWeightCurve;
	ptHWMMRInfo->dwPMCtrl = ptMMRInfo->dwPMCtrl;
	ptHWMMRInfo->dwPMMaskColor = ptMMRInfo->dwPMMaskColor;

	//if (bRSEn)
	if ((dwCtrl>>12) & 0x1)
	{
		const DWORD dwResizeChNum = ptMMRInfo->dwRSCtrl;
		ptHWMMRInfo->dwRSCtrl = ptMMRInfo->dwRSCtrl;
		//port
		//for (i=0; i<33; i++)
		{		
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[0];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[1];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[2];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[3];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[4];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[5];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[6];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[7];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[8];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[9];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[10];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[11];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[12];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[13];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[14];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[15];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[16];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[17];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[18];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[19];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[20];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[21];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[22];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[23];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[24];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[25];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[26];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[27];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[28];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[29];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[30];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[31];
			ptHWMMRInfo->dwRSITPFCoeff = ptMMRInfo->dwRSITPFCoeff[32];
		}

		for (i = 0; i < dwResizeChNum; ++i)
		{
			ptHWMMRInfo->adwRSOutSize[i] = ptMMRInfo->adwRSOutSize[i];
			ptHWMMRInfo->adwRSOutStride[i] = ptMMRInfo->adwRSOutStride[i];
			ptHWMMRInfo->adwRSOutSizeInv[i] = ptMMRInfo->adwRSOutSizeInv[i];
			ptHWMMRInfo->adwRSHorzDivValue[i] = ptMMRInfo->adwRSHorzDivValue[i];
			ptHWMMRInfo->adwRSVertDivValue[i] = ptMMRInfo->adwRSVertDivValue[i];
			ptHWMMRInfo->adwRSAAFCoeff[i] = ptMMRInfo->adwRSAAFCoeff[i];

			ptHWMMRInfo->adwYResizedFilteredOutAddr[i] = ptMMRInfo->adwYResizedFilteredOutAddr[i];
			ptHWMMRInfo->adwCbResizedFilteredOutAddr[i] = ptMMRInfo->adwCbResizedFilteredOutAddr[i];
			ptHWMMRInfo->adwCrResizedFilteredOutAddr[i] = ptMMRInfo->adwCrResizedFilteredOutAddr[i];
		}
		/*ptHWMMRInfo->adwRSOutSize[0] = ptMMRInfo->adwRSOutSize[0];
		ptHWMMRInfo->adwRSOutSize[1] = ptMMRInfo->adwRSOutSize[1];
		ptHWMMRInfo->adwRSOutSize[2] = ptMMRInfo->adwRSOutSize[2];
		ptHWMMRInfo->adwRSOutSize[3] = ptMMRInfo->adwRSOutSize[3];
		ptHWMMRInfo->adwRSOutStride[0] = ptMMRInfo->adwRSOutStride[0];
		ptHWMMRInfo->adwRSOutStride[1] = ptMMRInfo->adwRSOutStride[1];
		ptHWMMRInfo->adwRSOutStride[2] = ptMMRInfo->adwRSOutStride[2];
		ptHWMMRInfo->adwRSOutStride[3] = ptMMRInfo->adwRSOutStride[3];
		ptHWMMRInfo->adwRSOutSizeInv[0] = ptMMRInfo->adwRSOutSizeInv[0];
		ptHWMMRInfo->adwRSOutSizeInv[1] = ptMMRInfo->adwRSOutSizeInv[1];
		ptHWMMRInfo->adwRSOutSizeInv[2] = ptMMRInfo->adwRSOutSizeInv[2];
		ptHWMMRInfo->adwRSOutSizeInv[3] = ptMMRInfo->adwRSOutSizeInv[3];
		ptHWMMRInfo->adwRSHorzDivValue[0] = ptMMRInfo->adwRSHorzDivValue[0];
		ptHWMMRInfo->adwRSHorzDivValue[1] = ptMMRInfo->adwRSHorzDivValue[1];
		ptHWMMRInfo->adwRSHorzDivValue[2] = ptMMRInfo->adwRSHorzDivValue[2];
		ptHWMMRInfo->adwRSHorzDivValue[3] = ptMMRInfo->adwRSHorzDivValue[3];
		ptHWMMRInfo->adwRSVertDivValue[0] = ptMMRInfo->adwRSVertDivValue[0];
		ptHWMMRInfo->adwRSVertDivValue[1] = ptMMRInfo->adwRSVertDivValue[1];
		ptHWMMRInfo->adwRSVertDivValue[2] = ptMMRInfo->adwRSVertDivValue[2];
		ptHWMMRInfo->adwRSVertDivValue[3] = ptMMRInfo->adwRSVertDivValue[3];
		ptHWMMRInfo->adwRSAAFCoeff[0] = ptMMRInfo->adwRSAAFCoeff[0];
		ptHWMMRInfo->adwRSAAFCoeff[1] = ptMMRInfo->adwRSAAFCoeff[1];
		ptHWMMRInfo->adwRSAAFCoeff[2] = ptMMRInfo->adwRSAAFCoeff[2];
		ptHWMMRInfo->adwRSAAFCoeff[3] = ptMMRInfo->adwRSAAFCoeff[3];*/
	}
	ptHWMMRInfo->dwYCurrInAddr = ptMMRInfo->dwYCurrInAddr;
	ptHWMMRInfo->dwCbCurrInAddr = ptMMRInfo->dwCbCurrInAddr;
	ptHWMMRInfo->dwCrCurrInAddr = ptMMRInfo->dwCrCurrInAddr;
	ptHWMMRInfo->dwYRefInAddr = ptMMRInfo->dwYRefInAddr;
	ptHWMMRInfo->dwCbRefInAddr = ptMMRInfo->dwCbRefInAddr;
	ptHWMMRInfo->dwCrRefInAddr = ptMMRInfo->dwCrRefInAddr;
	ptHWMMRInfo->dwYDenoisedPrev0InAddr = ptMMRInfo->dwYDenoisedPrev0InAddr;
	ptHWMMRInfo->dwCbDenoisedPrev0InAddr = ptMMRInfo->dwCbDenoisedPrev0InAddr;
	ptHWMMRInfo->dwCrDenoisedPrev0InAddr = ptMMRInfo->dwCrDenoisedPrev0InAddr;
	ptHWMMRInfo->dwYDenoisedPrev1InAddr = ptMMRInfo->dwYDenoisedPrev1InAddr;
	ptHWMMRInfo->dwCbDenoisedPrev1InAddr = ptMMRInfo->dwCbDenoisedPrev1InAddr;
	ptHWMMRInfo->dwCrDenoisedPrev1InAddr = ptMMRInfo->dwCrDenoisedPrev1InAddr;
	ptHWMMRInfo->dwYAccumulatedPrevInAddr = ptMMRInfo->dwYAccumulatedPrevInAddr;
	ptHWMMRInfo->dwCbAccumulatedPrevInAddr = ptMMRInfo->dwCbAccumulatedPrevInAddr;
	ptHWMMRInfo->dwCrAccumulatedPrevInAddr = ptMMRInfo->dwCrAccumulatedPrevInAddr;
	ptHWMMRInfo->dwYDenoisedCurrOutAddr = ptMMRInfo->dwYDenoisedCurrOutAddr;
	ptHWMMRInfo->dwCbDenoisedCurrOutAddr = ptMMRInfo->dwCbDenoisedCurrOutAddr;
	ptHWMMRInfo->dwCrDenoisedCurrOutAddr = ptMMRInfo->dwCrDenoisedCurrOutAddr;
	ptHWMMRInfo->dwYAccumulatedCurrOutAddr = ptMMRInfo->dwYAccumulatedCurrOutAddr;
	ptHWMMRInfo->dwCbAccumulatedCurrOutAddr = ptMMRInfo->dwCbAccumulatedCurrOutAddr;
	ptHWMMRInfo->dwCrAccumulatedCurrOutAddr = ptMMRInfo->dwCrAccumulatedCurrOutAddr;
	ptHWMMRInfo->dwYFilteredOutAddr = ptMMRInfo->dwYFilteredOutAddr;
	ptHWMMRInfo->dwCbFilteredOutAddr = ptMMRInfo->dwCbFilteredOutAddr;
	ptHWMMRInfo->dwCrFilteredOutAddr = ptMMRInfo->dwCrFilteredOutAddr;
	ptHWMMRInfo->dwStaticMapInAddr = ptMMRInfo->dwStaticMapInAddr;
	ptHWMMRInfo->dwStaticMapOutAddr = ptMMRInfo->dwStaticMapOutAddr;
	ptHWMMRInfo->dwGridCoeffInAddr = ptMMRInfo->dwGridCoeffInAddr;
	ptHWMMRInfo->dwBlkInfoInAddr = ptMMRInfo->dwBlkInfoInAddr;
	ptHWMMRInfo->dwCoeffMapInAddr = ptMMRInfo->dwCoeffMapInAddr;
	ptHWMMRInfo->dwMotionInfoOutAddr = ptMMRInfo->dwMotionInfoOutAddr;
	ptHWMMRInfo->dwMaskInAddr = ptMMRInfo->dwMaskInAddr;
	/*ptHWMMRInfo->adwYResizedFilteredOutAddr[0] = ptMMRInfo->adwYResizedFilteredOutAddr[0];
	ptHWMMRInfo->adwYResizedFilteredOutAddr[1] = ptMMRInfo->adwYResizedFilteredOutAddr[1];
	ptHWMMRInfo->adwYResizedFilteredOutAddr[2] = ptMMRInfo->adwYResizedFilteredOutAddr[2];
	ptHWMMRInfo->adwYResizedFilteredOutAddr[3] = ptMMRInfo->adwYResizedFilteredOutAddr[3];
	ptHWMMRInfo->adwCbResizedFilteredOutAddr[0] = ptMMRInfo->adwCbResizedFilteredOutAddr[0];
	ptHWMMRInfo->adwCbResizedFilteredOutAddr[1] = ptMMRInfo->adwCbResizedFilteredOutAddr[1];
	ptHWMMRInfo->adwCbResizedFilteredOutAddr[2] = ptMMRInfo->adwCbResizedFilteredOutAddr[2];
	ptHWMMRInfo->adwCbResizedFilteredOutAddr[3] = ptMMRInfo->adwCbResizedFilteredOutAddr[3];
	ptHWMMRInfo->adwCrResizedFilteredOutAddr[0] = ptMMRInfo->adwCrResizedFilteredOutAddr[0];
	ptHWMMRInfo->adwCrResizedFilteredOutAddr[1] = ptMMRInfo->adwCrResizedFilteredOutAddr[1];
	ptHWMMRInfo->adwCrResizedFilteredOutAddr[2] = ptMMRInfo->adwCrResizedFilteredOutAddr[2];
	ptHWMMRInfo->adwCrResizedFilteredOutAddr[3] = ptMMRInfo->adwCrResizedFilteredOutAddr[3];*/
	ptHWMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;
	//ptDevInfo->ptHWMMRInfo->dwCtrl = (ptDevInfo->aptMMRInfo[dwWriteIndex]->dwCtrl&0xFFFFFFF6) | 0x00000006;
	//ptDevInfo->ptHWMMRInfo->dwCtrl = 0xEFEF1230;

}


void VMA_ISPE_StartTail(HANDLE hDevInfo, DWORD dwWriteIndex, TVMAISPEInfo *ptMMRInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->aptMMRInfo[dwWriteIndex] = (TVMAISPEInterInfo *)ptMMRInfo;
	ptDevInfo->dwWriteIndex = (dwWriteIndex+1) & VMA_ISPE_MMR_BUFF_MASK;

	//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
	if (!ptDevInfo->bBusy)
	{
		ptDevInfo->bBusy = TRUE;
		clk_enable(ptDevInfo->pClk);

		vma_ispe_copy_mmr(ptDevInfo->ptHWMMRInfo, (TVMAISPEInterInfo*)ptMMRInfo);
	}
}

/* ============================================================================================== */
void VMA_ISPE_IntrEnable(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->ptHWMMRInfo->dwCtrl = ptDevInfo->ptHWMMRInfo->dwCtrl | 0x00000002;

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VMA_ISPE_IntrDisable(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->ptHWMMRInfo->dwCtrl = ptDevInfo->ptHWMMRInfo->dwCtrl & 0xFFFFFFFD;

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VMA_ISPE_IntrClear(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->ptHWMMRInfo->dwCtrl = ptDevInfo->ptHWMMRInfo->dwCtrl & 0xFFFFFFFE;

	PDEBUG("Interrupt cleared !!\n");
}

/* ============================================================================================== */
void VMA_ISPE_Reset(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	PDEBUG("Enter Reset function...\n");

	ptDevInfo->ptHWMMRInfo->dwCtrl = (0x1<<31);
//	ptDevInfo->ptHWMMRInfo->dwCtrl = (0x1<<31) | 0x00000008;

//	while ((ptDevInfo->ptHWMMRInfo->dwCtrl&0x00000008) != 0);

	ptDevInfo->ptHWMMRInfo->dwCtrl = 0x0;

	PDEBUG("Exit Reset function !!\n");
}

/* ============================================================================================== */
void VMA_ISPE_Open(HANDLE hDevInfo)
{
	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	ptDevInfo->bBusy = FALSE;
	ptDevInfo->dwReadIndex = 0;
	ptDevInfo->dwWriteIndex = 0;
}

/* ============================================================================================== */
DWORD VMA_ISPE_ISR(HANDLE hDevInfo)
{
	DWORD dwReadIndex;
	TVMAISPEInterInfo* ptMMRInfo;

	TVMAISPEDevInfo *ptDevInfo = (TVMAISPEDevInfo *)hDevInfo;

	dwReadIndex = ptDevInfo->dwReadIndex;

	ptDevInfo->ptHWMMRInfo->dwCtrl = ptDevInfo->ptHWMMRInfo->dwCtrl & 0xFFFFFFFE;

#ifdef __PROFILE__
	ptDevInfo->aadwBandwidth[dwReadIndex][0] = *ptDevInfo->apdwBandwidth[0];
	ptDevInfo->aadwRGInterval[dwReadIndex][0] = *ptDevInfo->apdwRGInterval[0];
	ptDevInfo->aadwReqTimes[dwReadIndex][0] = *ptDevInfo->apdwReqTimes[0];
	writel((0x1<<VMA_ISPE_MASTER_0_MASTER_NUM), ptDevInfo->apdwProfileClr[0]);

	ptDevInfo->aadwBandwidth[dwReadIndex][1] = *ptDevInfo->apdwBandwidth[1];
	ptDevInfo->aadwRGInterval[dwReadIndex][1] = *ptDevInfo->apdwRGInterval[1];
	ptDevInfo->aadwReqTimes[dwReadIndex][1] = *ptDevInfo->apdwReqTimes[1];
	writel((0x1<<VMA_ISPE_MASTER_1_MASTER_NUM), ptDevInfo->apdwProfileClr[1]);

#endif //__PROFILE__
	ptMMRInfo = ptDevInfo->aptMMRInfo[dwReadIndex];
	if (!ptMMRInfo)
	{
#if 0
		ptMMRInfo->dwVersion = ptDevInfo->ptHWMMRInfo->dwVersion;
		ptMMRInfo->dwCycles = ptDevInfo->ptHWMMRInfo->dwCycles;
		ptMMRInfo->dwCtrl = ptDevInfo->ptHWMMRInfo->dwCtrl;
		ptMMRInfo->dwStat = ptDevInfo->ptHWMMRInfo->dwStat;
		ptMMRInfo->dwProcSize = ptDevInfo->ptHWMMRInfo->dwProcSize;
		ptMMRInfo->dwStride = ptDevInfo->ptHWMMRInfo->dwStride;
#endif
		ptMMRInfo->dwBusCtrl = ptDevInfo->ptHWMMRInfo->dwBusCtrl;
#if 0
		//ptDevInfo->aptMMRInfo[dwReadIndex]->dwPasscode = ptDevInfo->ptHWMMRInfo->dwPasscode;
		
		ptMMRInfo->dwCacheCtrl = ptDevInfo->ptHWMMRInfo->dwCacheCtrl;
		ptMMRInfo->dwPTCtrl = ptDevInfo->ptHWMMRInfo->dwPTCtrl;
		ptMMRInfo->dwPTSrcSize = ptDevInfo->ptHWMMRInfo->dwPTSrcSize;
		ptMMRInfo->dwPTStride = ptDevInfo->ptHWMMRInfo->dwPTStride;
		ptMMRInfo->dwPTGridSize = ptDevInfo->ptHWMMRInfo->dwPTGridSize;
		ptMMRInfo->dwPTBackgroundColor = ptDevInfo->ptHWMMRInfo->dwPTBackgroundColor;
		//ptDevInfo->aptMMRInfo[dwReadIndex]->dwPTITPFCoeff = ptDevInfo->ptHWMMRInfo->dwPTITPFCoeff;	
		ptMMRInfo->dwPTGridCoeff0 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff0;
		ptMMRInfo->dwPTGridCoeff1 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff1;
		ptMMRInfo->dwPTGridCoeff2 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff2;
		ptMMRInfo->dwPTGridCoeff3 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff3;
		ptMMRInfo->dwPTGridCoeff4 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff4;
		ptMMRInfo->dwPTGridCoeff5 = ptDevInfo->ptHWMMRInfo->dwPTGridCoeff5;
		ptMMRInfo->dwGCCtrl = ptDevInfo->ptHWMMRInfo->dwGCCtrl;
		ptMMRInfo->dwGCSrcSize = ptDevInfo->ptHWMMRInfo->dwGCSrcSize;
		ptMMRInfo->dwGCSrcStride = ptDevInfo->ptHWMMRInfo->dwGCSrcStride;
		ptMMRInfo->dwGCSrcCenter = ptDevInfo->ptHWMMRInfo->dwGCSrcCenter;
		ptMMRInfo->dwGCBackgroundColor = ptDevInfo->ptHWMMRInfo->dwGCBackgroundColor;
		ptMMRInfo->dwGCLumaCoeff0 = ptDevInfo->ptHWMMRInfo->dwGCLumaCoeff0;
		ptMMRInfo->dwGCLumaCoeff1 = ptDevInfo->ptHWMMRInfo->dwGCLumaCoeff1;
		ptMMRInfo->dwGCLumaCoeff2 = ptDevInfo->ptHWMMRInfo->dwGCLumaCoeff2;
		ptMMRInfo->dwGCChromaCoeff0 = ptDevInfo->ptHWMMRInfo->dwGCChromaCoeff0;
		ptMMRInfo->dwGCChromaCoeff1 = ptDevInfo->ptHWMMRInfo->dwGCChromaCoeff1;
		ptMMRInfo->dwGCChromaCoeff2 = ptDevInfo->ptHWMMRInfo->dwGCChromaCoeff2;
		//ptDevInfo->aptMMRInfo[dwReadIndex]->dwGCITPFCoeff = ptDevInfo->ptHWMMRInfo->dwGCITPFCoeff;
		ptMMRInfo->dwGCSrcOffset = ptDevInfo->ptHWMMRInfo->dwGCSrcOffset;
		ptMMRInfo->dwRTCtrl = ptDevInfo->ptHWMMRInfo->dwRTCtrl;
		ptMMRInfo->dwRTSrcStride = ptDevInfo->ptHWMMRInfo->dwRTSrcStride;
		ptMMRInfo->dwDICtrl = ptDevInfo->ptHWMMRInfo->dwDICtrl;
		ptMMRInfo->dwDISpatialCtrl = ptDevInfo->ptHWMMRInfo->dwDISpatialCtrl;
		ptMMRInfo->dwDISpatialMDOIThrGroupA = ptDevInfo->ptHWMMRInfo->dwDISpatialMDOIThrGroupA;
		ptMMRInfo->dwDISpatialMDOIThrGroupB = ptDevInfo->ptHWMMRInfo->dwDISpatialMDOIThrGroupB;
		ptMMRInfo->dwDIMACtrl = ptDevInfo->ptHWMMRInfo->dwDIMACtrl;
		ptMMRInfo->dwDIMAThrGroupA = ptDevInfo->ptHWMMRInfo->dwDIMAThrGroupA;
		ptMMRInfo->dwDIMAThrGroupB = ptDevInfo->ptHWMMRInfo->dwDIMAThrGroupB;
		ptMMRInfo->dwDIMAMorphExcludeStartPos = ptDevInfo->ptHWMMRInfo->dwDIMAMorphExcludeStartPos;
		ptMMRInfo->dwDIMAMorphExcludeEndPos = ptDevInfo->ptHWMMRInfo->dwDIMAMorphExcludeEndPos;
		ptMMRInfo->dwNR2DCtrl = ptDevInfo->ptHWMMRInfo->dwNR2DCtrl;
		ptMMRInfo->dwNR2DWeightedCoeff = ptDevInfo->ptHWMMRInfo->dwNR2DWeightedCoeff;
		ptMMRInfo->dwNR2DPostWeightedCoeff = ptDevInfo->ptHWMMRInfo->dwNR2DPostWeightedCoeff;
#endif
		ptMMRInfo->dwNR2DGlobalNoiseLevel = ptDevInfo->ptHWMMRInfo->dwNR2DGlobalNoiseLevel;
#if 0
		ptMMRInfo->dwNR2DHybridCtrl = ptDevInfo->ptHWMMRInfo->dwNR2DHybridCtrl;
		ptMMRInfo->dwNR2DMACurrCtrl = ptDevInfo->ptHWMMRInfo->dwNR2DMACurrCtrl;
		ptMMRInfo->dwNR2DMARefCtrl = ptDevInfo->ptHWMMRInfo->dwNR2DMARefCtrl;
		ptMMRInfo->dwNR2DMASlope = ptDevInfo->ptHWMMRInfo->dwNR2DMASlope;
		ptMMRInfo->dwNR3DCtrl = ptDevInfo->ptHWMMRInfo->dwNR3DCtrl;
		ptMMRInfo->dwMDCtrl = ptDevInfo->ptHWMMRInfo->dwMDCtrl;
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[0] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[0];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[1] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[1];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[2] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[2];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[3] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[3];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[4] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[4];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[5] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[5];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[6] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[6];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[7] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[7];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[8] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[8];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[9] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[9];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[10] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[10];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[11] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[11];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[12] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[12];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[13] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[13];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[14] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[14];
		//ptDevInfo->aptMMRInfo[dwReadIndex]->adwMDWindowInfo[15] = ptDevInfo->ptHWMMRInfo->adwMDWindowInfo[15];
		ptMMRInfo->dwEECtrl = ptDevInfo->ptHWMMRInfo->dwEECtrl;
		//ptDevInfo->aptMMRInfo[dwReadIndex]->dwEEHPFCoeff = ptDevInfo->ptHWMMRInfo->dwEEHPFCoeff;
		ptMMRInfo->dwDPCCtrl = ptDevInfo->ptHWMMRInfo->dwDPCCtrl;
		ptMMRInfo->dwDPCVarianceWeightCurve = ptDevInfo->ptHWMMRInfo->dwDPCVarianceWeightCurve;
		ptMMRInfo->dwDPCDistanceWeightCurve = ptDevInfo->ptHWMMRInfo->dwDPCDistanceWeightCurve;
		ptMMRInfo->dwPMCtrl = ptDevInfo->ptHWMMRInfo->dwPMCtrl;
		ptMMRInfo->dwPMMaskColor = ptDevInfo->ptHWMMRInfo->dwPMMaskColor;
		ptMMRInfo->dwRSCtrl = ptDevInfo->ptHWMMRInfo->dwRSCtrl;
		//ptDevInfo->aptMMRInfo[dwReadIndex]->dwRSITPFCoeff = ptDevInfo->ptHWMMRInfo->dwRSITPFCoeff;
		ptMMRInfo->adwRSOutSize[0] = ptDevInfo->ptHWMMRInfo->adwRSOutSize[0];
		ptMMRInfo->adwRSOutSize[1] = ptDevInfo->ptHWMMRInfo->adwRSOutSize[1];
		ptMMRInfo->adwRSOutSize[2] = ptDevInfo->ptHWMMRInfo->adwRSOutSize[2];
		ptMMRInfo->adwRSOutSize[3] = ptDevInfo->ptHWMMRInfo->adwRSOutSize[3];
		ptMMRInfo->adwRSOutStride[0] = ptDevInfo->ptHWMMRInfo->adwRSOutStride[0];
		ptMMRInfo->adwRSOutStride[1] = ptDevInfo->ptHWMMRInfo->adwRSOutStride[1];
		ptMMRInfo->adwRSOutStride[2] = ptDevInfo->ptHWMMRInfo->adwRSOutStride[2];
		ptMMRInfo->adwRSOutStride[3] = ptDevInfo->ptHWMMRInfo->adwRSOutStride[3];
		ptMMRInfo->adwRSOutSizeInv[0] = ptDevInfo->ptHWMMRInfo->adwRSOutSizeInv[0];
		ptMMRInfo->adwRSOutSizeInv[1] = ptDevInfo->ptHWMMRInfo->adwRSOutSizeInv[1];
		ptMMRInfo->adwRSOutSizeInv[2] = ptDevInfo->ptHWMMRInfo->adwRSOutSizeInv[2];
		ptMMRInfo->adwRSOutSizeInv[3] = ptDevInfo->ptHWMMRInfo->adwRSOutSizeInv[3];
		ptMMRInfo->adwRSHorzDivValue[0] = ptDevInfo->ptHWMMRInfo->adwRSHorzDivValue[0];
		ptMMRInfo->adwRSHorzDivValue[1] = ptDevInfo->ptHWMMRInfo->adwRSHorzDivValue[1];
		ptMMRInfo->adwRSHorzDivValue[2] = ptDevInfo->ptHWMMRInfo->adwRSHorzDivValue[2];
		ptMMRInfo->adwRSHorzDivValue[3] = ptDevInfo->ptHWMMRInfo->adwRSHorzDivValue[3];
		ptMMRInfo->adwRSVertDivValue[0] = ptDevInfo->ptHWMMRInfo->adwRSVertDivValue[0];
		ptMMRInfo->adwRSVertDivValue[1] = ptDevInfo->ptHWMMRInfo->adwRSVertDivValue[1];
		ptMMRInfo->adwRSVertDivValue[2] = ptDevInfo->ptHWMMRInfo->adwRSVertDivValue[2];
		ptMMRInfo->adwRSVertDivValue[3] = ptDevInfo->ptHWMMRInfo->adwRSVertDivValue[3];
		ptMMRInfo->adwRSAAFCoeff[0] = ptDevInfo->ptHWMMRInfo->adwRSAAFCoeff[0];
		ptMMRInfo->adwRSAAFCoeff[1] = ptDevInfo->ptHWMMRInfo->adwRSAAFCoeff[1];
		ptMMRInfo->adwRSAAFCoeff[2] = ptDevInfo->ptHWMMRInfo->adwRSAAFCoeff[2];
		ptMMRInfo->adwRSAAFCoeff[3] = ptDevInfo->ptHWMMRInfo->adwRSAAFCoeff[3];
		ptMMRInfo->dwYCurrInAddr = ptDevInfo->ptHWMMRInfo->dwYCurrInAddr;
		ptMMRInfo->dwCbCurrInAddr = ptDevInfo->ptHWMMRInfo->dwCbCurrInAddr;
		ptMMRInfo->dwCrCurrInAddr = ptDevInfo->ptHWMMRInfo->dwCrCurrInAddr;
		ptMMRInfo->dwYRefInAddr = ptDevInfo->ptHWMMRInfo->dwYRefInAddr;
		ptMMRInfo->dwCbRefInAddr = ptDevInfo->ptHWMMRInfo->dwCbRefInAddr;
		ptMMRInfo->dwCrRefInAddr = ptDevInfo->ptHWMMRInfo->dwCrRefInAddr;
		ptMMRInfo->dwYDenoisedPrev0InAddr = ptDevInfo->ptHWMMRInfo->dwYDenoisedPrev0InAddr;
		ptMMRInfo->dwCbDenoisedPrev0InAddr = ptDevInfo->ptHWMMRInfo->dwCbDenoisedPrev0InAddr;
		ptMMRInfo->dwCrDenoisedPrev0InAddr = ptDevInfo->ptHWMMRInfo->dwCrDenoisedPrev0InAddr;
		ptMMRInfo->dwYDenoisedPrev1InAddr = ptDevInfo->ptHWMMRInfo->dwYDenoisedPrev1InAddr;
		ptMMRInfo->dwCbDenoisedPrev1InAddr = ptDevInfo->ptHWMMRInfo->dwCbDenoisedPrev1InAddr;
		ptMMRInfo->dwCrDenoisedPrev1InAddr = ptDevInfo->ptHWMMRInfo->dwCrDenoisedPrev1InAddr;
		ptMMRInfo->dwYAccumulatedPrevInAddr = ptDevInfo->ptHWMMRInfo->dwYAccumulatedPrevInAddr;
		ptMMRInfo->dwCbAccumulatedPrevInAddr = ptDevInfo->ptHWMMRInfo->dwCbAccumulatedPrevInAddr;
		ptMMRInfo->dwCrAccumulatedPrevInAddr = ptDevInfo->ptHWMMRInfo->dwCrAccumulatedPrevInAddr;
		ptMMRInfo->dwYDenoisedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwYDenoisedCurrOutAddr;
		ptMMRInfo->dwCbDenoisedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwCbDenoisedCurrOutAddr;
		ptMMRInfo->dwCrDenoisedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwCrDenoisedCurrOutAddr;
		ptMMRInfo->dwYAccumulatedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwYAccumulatedCurrOutAddr;
		ptMMRInfo->dwCbAccumulatedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwCbAccumulatedCurrOutAddr;
		ptMMRInfo->dwCrAccumulatedCurrOutAddr = ptDevInfo->ptHWMMRInfo->dwCrAccumulatedCurrOutAddr;
		ptMMRInfo->dwYFilteredOutAddr = ptDevInfo->ptHWMMRInfo->dwYFilteredOutAddr;
		ptMMRInfo->dwCbFilteredOutAddr = ptDevInfo->ptHWMMRInfo->dwCbFilteredOutAddr;
		ptMMRInfo->dwCrFilteredOutAddr = ptDevInfo->ptHWMMRInfo->dwCrFilteredOutAddr;
		ptMMRInfo->dwStaticMapInAddr = ptDevInfo->ptHWMMRInfo->dwStaticMapInAddr;
		ptMMRInfo->dwStaticMapOutAddr = ptDevInfo->ptHWMMRInfo->dwStaticMapOutAddr;
		ptMMRInfo->dwGridCoeffInAddr = ptDevInfo->ptHWMMRInfo->dwGridCoeffInAddr;
		ptMMRInfo->dwBlkInfoInAddr = ptDevInfo->ptHWMMRInfo->dwBlkInfoInAddr;
		ptMMRInfo->dwCoeffMapInAddr = ptDevInfo->ptHWMMRInfo->dwCoeffMapInAddr;
		ptMMRInfo->dwMotionInfoOutAddr = ptDevInfo->ptHWMMRInfo->dwMotionInfoOutAddr;
		ptMMRInfo->dwMaskInAddr = ptDevInfo->ptHWMMRInfo->dwMaskInAddr;
		ptMMRInfo->adwYResizedFilteredOutAddr[0] = ptDevInfo->ptHWMMRInfo->adwYResizedFilteredOutAddr[0];
		ptMMRInfo->adwYResizedFilteredOutAddr[1] = ptDevInfo->ptHWMMRInfo->adwYResizedFilteredOutAddr[1];
		ptMMRInfo->adwYResizedFilteredOutAddr[2] = ptDevInfo->ptHWMMRInfo->adwYResizedFilteredOutAddr[2];
		ptMMRInfo->adwYResizedFilteredOutAddr[3] = ptDevInfo->ptHWMMRInfo->adwYResizedFilteredOutAddr[3];
		ptMMRInfo->adwCbResizedFilteredOutAddr[0] = ptDevInfo->ptHWMMRInfo->adwCbResizedFilteredOutAddr[0];
		ptMMRInfo->adwCbResizedFilteredOutAddr[1] = ptDevInfo->ptHWMMRInfo->adwCbResizedFilteredOutAddr[1];
		ptMMRInfo->adwCbResizedFilteredOutAddr[2] = ptDevInfo->ptHWMMRInfo->adwCbResizedFilteredOutAddr[2];
		ptMMRInfo->adwCbResizedFilteredOutAddr[3] = ptDevInfo->ptHWMMRInfo->adwCbResizedFilteredOutAddr[3];
		ptMMRInfo->adwCrResizedFilteredOutAddr[0] = ptDevInfo->ptHWMMRInfo->adwCrResizedFilteredOutAddr[0];
		ptMMRInfo->adwCrResizedFilteredOutAddr[1] = ptDevInfo->ptHWMMRInfo->adwCrResizedFilteredOutAddr[1];
		ptMMRInfo->adwCrResizedFilteredOutAddr[2] = ptDevInfo->ptHWMMRInfo->adwCrResizedFilteredOutAddr[2];
		ptMMRInfo->adwCrResizedFilteredOutAddr[3] = ptDevInfo->ptHWMMRInfo->adwCrResizedFilteredOutAddr[3];
#endif
	}

	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr & (0xFFFFFFFF - VMA_ISPE_RST_EN_NUM);
	while (ptDevInfo->ptHWMMRInfo->dwYCurrInAddr != 0);
	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr | VMA_ISPE_RST_EN_NUM;
	
	ptDevInfo->dwReadIndex = (dwReadIndex+1) & VMA_ISPE_MMR_BUFF_MASK;

	if (ptDevInfo->dwReadIndex != ptDevInfo->dwWriteIndex)
	{		
		vma_ispe_copy_mmr(ptDevInfo->ptHWMMRInfo, ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex]);
	}
	else
	{
		clk_disable(ptDevInfo->pClk);
		ptDevInfo->bBusy = FALSE;
	}

	return dwReadIndex;
}

/* ============================================================================================== */
