/*
 * $Header: /rd_2/project/Rossini/Components/JEBE/Device_Driver/JEBE/vma_jebe_locals.c 5     15/12/25 1:18p Dy.lu $
 *
 * Copyright 2015-2020 VATICS INC.. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.8.0.6.
 *
 * $History: vma_jebe_locals.c $
 * 
 * *****************  Version 5  *****************
 * User: Dy.lu        Date: 15/12/25   Time: 1:18p
 * Updated in $/rd_2/project/Rossini/Components/JEBE/Device_Driver/JEBE
 * 
 * *****************  Version 4  *****************
 * User: Dy.lu        Date: 15/11/27   Time: 5:08p
 * Updated in $/rd_2/project/Rossini/Components/JEBE/Device_Driver/JEBE
 *
 */

/* ============================================================================================== */
#include "vma_jebe_locals.h"

/* ============================================================================================== */
DWORD VMA_JEBE_GetDevInfoSize(void)
{
	return sizeof(TVMAJEBEDevInfo);
}

/* ============================================================================================== */
SCODE VMA_JEBE_SetMMRInfo(HANDLE hDevInfo, volatile TVMAJEBEInfo *ptMMRInfo, struct clk *pClk, volatile DWORD *pdwRstEnMmr)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo = ptMMRInfo;
	ptDevInfo->pClk = pClk;
	ptDevInfo->pdwRstEnMmr = pdwRstEnMmr;
	ptDevInfo->dwVersionNum = ptDevInfo->ptMMRInfo->dwVersion;

	if ((ptDevInfo->ptMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptMMRInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VMA_JEBE_GetMMRInfo(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
#ifdef __PROFILE__
SCODE VMA_JEBE_InitProfileInfo(TVMAJEBEObjInfo *ptObjInfo)
{
	DWORD dwProfileInfoSize;

	dwProfileInfoSize = sizeof(TVMAJEBEProfileInfo);
	if ((ptObjInfo->hProfileInfo=(HANDLE)kmalloc(dwProfileInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate profile info buffer fail !!");
		return -ENOMEM;
	}
	memset(ptObjInfo->hProfileInfo, 0, dwProfileInfoSize);

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_JEBE_InitProfile(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD), "VMA_JEBE Profile Clear");
	ptDevInfo->apdwProfileClr[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Bandwidth");
	ptDevInfo->apdwBandwidth[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Request Grant Interval");
	ptDevInfo->apdwRGInterval[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x148+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Request Times");
	ptDevInfo->apdwReqTimes[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x184+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD), "VMA_JEBE Profile Clear");
	ptDevInfo->apdwProfileClr[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Bandwidth");
	ptDevInfo->apdwBandwidth[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Request Grant Interval");
	ptDevInfo->apdwRGInterval[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x148+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_JEBE Request Times");
	ptDevInfo->apdwReqTimes[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x184+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_JEBE_GetProfileInfo(HANDLE hDevInfo, TVMAJEBEObjInfo *ptObjInfo, DWORD dwWriteIndex)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;
	TVMAJEBEProfileInfo *ptProfileInfo = (TVMAJEBEProfileInfo *)ptObjInfo->hProfileInfo;

	ptProfileInfo->adwBandwidth[0] = ptDevInfo->aadwBandwidth[dwWriteIndex][0];
	ptProfileInfo->adwRGInterval[0] = ptDevInfo->aadwRGInterval[dwWriteIndex][0];
	ptProfileInfo->adwReqTimes[0] = ptDevInfo->aadwReqTimes[dwWriteIndex][0];
	ptProfileInfo->adwBandwidth[1] = ptDevInfo->aadwBandwidth[dwWriteIndex][1];
	ptProfileInfo->adwRGInterval[1] = ptDevInfo->aadwRGInterval[dwWriteIndex][1];
	ptProfileInfo->adwReqTimes[1] = ptDevInfo->aadwReqTimes[dwWriteIndex][1];

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_JEBE_CloseProfile(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	if (ptDevInfo->apdwProfileClr[0] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[0] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[0] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[0] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VMA_JEBE_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwProfileClr[1] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[1] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[1] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[1] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VMA_JEBE_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_JEBE_SetupProfile(TVMAJEBEObjInfo *ptObjInfo, DWORD dwArg, DWORD dwCmd)
{
	SCODE scError = S_OK;
	TVMAJEBEProfileInfo *ptProfileInfo = (TVMAJEBEProfileInfo *)ptObjInfo->hProfileInfo;

	switch (dwCmd)
	{
		case VMA_JEBE_IOC_MASTER_0_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[0], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_0_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[0], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_0_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[0], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_0_CLEAR_PROFILE:
		break;
		case VMA_JEBE_IOC_MASTER_1_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[1], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_1_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[1], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_1_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[1], sizeof(DWORD));
		break;
		case VMA_JEBE_IOC_MASTER_1_CLEAR_PROFILE:
		break;
		default:
			scError = S_FAIL;
	}

	return scError;
}
#endif //__PROFILE__

/* ============================================================================================== */
DWORD VMA_JEBE_GetVersion(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	return ptDevInfo->ptMMRInfo->dwVersion;
}

/* ============================================================================================== */
DWORD VMA_JEBE_StartHead(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	return ptDevInfo->dwWriteIndex;
}

/* ============================================================================================== */
static inline void vma_jebe_copy_mmr(volatile TVMAJEBEInfo *hw_ptMMRInfo, TVMAJEBEInfo *ptMMRInfo)
{
	hw_ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl;
	hw_ptMMRInfo->dwCodingCtrl = ptMMRInfo->dwCodingCtrl;
	hw_ptMMRInfo->dwYFrameAddr = ptMMRInfo->dwYFrameAddr;
	hw_ptMMRInfo->dwCbFrameAddr = ptMMRInfo->dwCbFrameAddr;
	hw_ptMMRInfo->dwCrFrameAddr = ptMMRInfo->dwCrFrameAddr;
	hw_ptMMRInfo->dwBSLowBoundAddr = ptMMRInfo->dwBSLowBoundAddr;
	hw_ptMMRInfo->dwBSUpBoundAddr = ptMMRInfo->dwBSUpBoundAddr;
	hw_ptMMRInfo->dwLumQuantTblAddr = ptMMRInfo->dwLumQuantTblAddr;
	hw_ptMMRInfo->dwChrQuantTblAddr = ptMMRInfo->dwChrQuantTblAddr;
	hw_ptMMRInfo->dwLumHufIndxTblAddr = ptMMRInfo->dwLumHufIndxTblAddr;
	hw_ptMMRInfo->dwChrHufIndxTblAddr = ptMMRInfo->dwChrHufIndxTblAddr;
	hw_ptMMRInfo->dwLumHufCntTblAddr = ptMMRInfo->dwLumHufCntTblAddr;
	hw_ptMMRInfo->dwChrHufCntTblAddr = ptMMRInfo->dwChrHufCntTblAddr;
	hw_ptMMRInfo->dwTotalBlkNum = ptMMRInfo->dwTotalBlkNum;
	hw_ptMMRInfo->dwBuffSize = ptMMRInfo->dwBuffSize;
	hw_ptMMRInfo->dwLumSizeInfo = ptMMRInfo->dwLumSizeInfo;
	hw_ptMMRInfo->dwPrevSliceInfo0 = ptMMRInfo->dwPrevSliceInfo0;
	hw_ptMMRInfo->dwPrevSliceInfo1 = ptMMRInfo->dwPrevSliceInfo1;
	hw_ptMMRInfo->dwUnAlignBytesMSBs = ptMMRInfo->dwUnAlignBytesMSBs;
	hw_ptMMRInfo->dwUnAlignBytesLSBs = ptMMRInfo->dwUnAlignBytesLSBs;
	hw_ptMMRInfo->dwOsdYFrameAddr = ptMMRInfo->dwOsdYFrameAddr;
	hw_ptMMRInfo->dwOsdCbFrameAddr = ptMMRInfo->dwOsdCbFrameAddr;
	hw_ptMMRInfo->dwOsdCrFrameAddr = ptMMRInfo->dwOsdCrFrameAddr;
	hw_ptMMRInfo->dwOsdStrideInfo = ptMMRInfo->dwOsdStrideInfo;
	hw_ptMMRInfo->dwOsdSizeInfo = ptMMRInfo->dwOsdSizeInfo;
	hw_ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;

}
void VMA_JEBE_StartTail(HANDLE hDevInfo, DWORD dwWriteIndex, TVMAJEBEInfo *ptMMRInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->aptMMRInfo[dwWriteIndex] = ptMMRInfo;
	ptDevInfo->dwWriteIndex = (dwWriteIndex+1) & VMA_JEBE_MMR_BUFF_MASK;

	//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
	if (!ptDevInfo->bBusy)
	{
		ptDevInfo->bBusy = TRUE;
		clk_enable(ptDevInfo->pClk);

		vma_jebe_copy_mmr(ptDevInfo->ptMMRInfo, ptMMRInfo);
	}
}

/* ============================================================================================== */
void VMA_JEBE_IntrEnable(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl | 0x00000002;

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VMA_JEBE_IntrDisable(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFD;

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VMA_JEBE_IntrClear(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

	PDEBUG("Interrupt cleared !!\n");
}

/* ============================================================================================== */
void VMA_JEBE_Reset(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	PDEBUG("Enter Reset function...\n");

	ptDevInfo->ptMMRInfo->dwCtrl = 0x00000008;

    *ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr & (~(VMA_JEBE_RST_EN_VALUE<<VMA_JEBE_RST_EN_NUM));                                                                                   
    *ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr | (VMA_JEBE_RST_EN_VALUE<<VMA_JEBE_RST_EN_NUM);

	while (ptDevInfo->ptMMRInfo->dwVersion != ptDevInfo->dwVersionNum);

	PDEBUG("Exit Reset function !!\n");
}

/* ============================================================================================== */
void VMA_JEBE_Open(HANDLE hDevInfo)
{
	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	ptDevInfo->bBusy = FALSE;
	ptDevInfo->dwReadIndex = 0;
	ptDevInfo->dwWriteIndex = 0;
}

/* ============================================================================================== */
DWORD VMA_JEBE_ISR(HANDLE hDevInfo)
{
	DWORD dwReadIndex;

	TVMAJEBEDevInfo *ptDevInfo = (TVMAJEBEDevInfo *)hDevInfo;

	dwReadIndex = ptDevInfo->dwReadIndex;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

#ifdef __PROFILE__
	ptDevInfo->aadwBandwidth[dwReadIndex][0] = *ptDevInfo->apdwBandwidth[0];
	ptDevInfo->aadwRGInterval[dwReadIndex][0] = *ptDevInfo->apdwRGInterval[0];
	ptDevInfo->aadwReqTimes[dwReadIndex][0] = *ptDevInfo->apdwReqTimes[0];
	writel((0x1<<VMA_JEBE_MASTER_0_MASTER_NUM), ptDevInfo->apdwProfileClr[0]);

	ptDevInfo->aadwBandwidth[dwReadIndex][1] = *ptDevInfo->apdwBandwidth[1];
	ptDevInfo->aadwRGInterval[dwReadIndex][1] = *ptDevInfo->apdwRGInterval[1];
	ptDevInfo->aadwReqTimes[dwReadIndex][1] = *ptDevInfo->apdwReqTimes[1];
	writel((0x1<<VMA_JEBE_MASTER_1_MASTER_NUM), ptDevInfo->apdwProfileClr[1]);

#endif //__PROFILE__
	if (ptDevInfo->aptMMRInfo[dwReadIndex] != NULL)
	{
		/*ptDevInfo->aptMMRInfo[dwReadIndex]->dwCycles = ptDevInfo->ptMMRInfo->dwCycles;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwStat = ptDevInfo->ptMMRInfo->dwStat;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCodingCtrl = ptDevInfo->ptMMRInfo->dwCodingCtrl;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwYFrameAddr = ptDevInfo->ptMMRInfo->dwYFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCbFrameAddr = ptDevInfo->ptMMRInfo->dwCbFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCrFrameAddr = ptDevInfo->ptMMRInfo->dwCrFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwBSLowBoundAddr = ptDevInfo->ptMMRInfo->dwBSLowBoundAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwBSUpBoundAddr = ptDevInfo->ptMMRInfo->dwBSUpBoundAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwLumQuantTblAddr = ptDevInfo->ptMMRInfo->dwLumQuantTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwChrQuantTblAddr = ptDevInfo->ptMMRInfo->dwChrQuantTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwLumHufIndxTblAddr = ptDevInfo->ptMMRInfo->dwLumHufIndxTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwChrHufIndxTblAddr = ptDevInfo->ptMMRInfo->dwChrHufIndxTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwLumHufCntTblAddr = ptDevInfo->ptMMRInfo->dwLumHufCntTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwChrHufCntTblAddr = ptDevInfo->ptMMRInfo->dwChrHufCntTblAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwTotalBlkNum = ptDevInfo->ptMMRInfo->dwTotalBlkNum;*/
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwBuffSize = ptDevInfo->ptMMRInfo->dwBuffSize;
		/*ptDevInfo->aptMMRInfo[dwReadIndex]->dwLumSizeInfo = ptDevInfo->ptMMRInfo->dwLumSizeInfo;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwPrevSliceInfo0 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo0;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwPrevSliceInfo1 = ptDevInfo->ptMMRInfo->dwPrevSliceInfo1;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwUnAlignBytesMSBs = ptDevInfo->ptMMRInfo->dwUnAlignBytesMSBs;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwUnAlignBytesLSBs = ptDevInfo->ptMMRInfo->dwUnAlignBytesLSBs;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwOsdYFrameAddr = ptDevInfo->ptMMRInfo->dwOsdYFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwOsdCbFrameAddr = ptDevInfo->ptMMRInfo->dwOsdCbFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwOsdCrFrameAddr = ptDevInfo->ptMMRInfo->dwOsdCrFrameAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwOsdStrideInfo = ptDevInfo->ptMMRInfo->dwOsdStrideInfo;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwOsdSizeInfo = ptDevInfo->ptMMRInfo->dwOsdSizeInfo;*/
	}


	ptDevInfo->dwReadIndex = (dwReadIndex+1) & VMA_JEBE_MMR_BUFF_MASK;

	if (ptDevInfo->dwReadIndex != ptDevInfo->dwWriteIndex)
	{
		vma_jebe_copy_mmr(ptDevInfo->ptMMRInfo, ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex]);
	}
	else
	{
		clk_disable(ptDevInfo->pClk);
		ptDevInfo->bBusy = FALSE;
	}

	return dwReadIndex;
}

/* ============================================================================================== */
