/*
 * $Header: /rd_2/project/Rossini/Components/MEAE/Device_Driver/MEAE/vma_meae_locals.c 4     15/12/24 1:40p Alan $
 *
 * Copyright 2013-2018 VATICS INC.. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.6.0.10.
 *
 * $History: vma_meae_locals.c $
 * 
 * *****************  Version 4  *****************
 * User: Alan         Date: 15/12/24   Time: 1:40p
 * Updated in $/rd_2/project/Rossini/Components/MEAE/Device_Driver/MEAE
 * 
 * *****************  Version 3  *****************
 * User: Angel        Date: 14/09/03   Time: 4:34p
 * Updated in $/rd_2/project/Rossini/Components/MEAE/Device_Driver/MEAE
 *
 */

/* ============================================================================================== */
#include "vma_meae_locals.h"

/* ============================================================================================== */
DWORD VMA_MEAE_GetDevInfoSize(void)
{
	return sizeof(TVMAMEAEDevInfo);
}

/* ============================================================================================== */
SCODE VMA_MEAE_SetMMRInfo(HANDLE hDevInfo, volatile TVMAMEAEInfo *ptMMRInfo, struct clk *pClk, volatile DWORD *pdwRstEnMmr)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo = ptMMRInfo;
	ptDevInfo->pClk = pClk;
	ptDevInfo->pdwRstEnMmr = pdwRstEnMmr;
	ptDevInfo->dwVersionNum = ptDevInfo->ptMMRInfo->dwVersion;

	if ((ptDevInfo->ptMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptMMRInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VMA_MEAE_GetMMRInfo(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
#ifdef __PROFILE__
SCODE VMA_MEAE_InitProfileInfo(TVMAMEAEObjInfo *ptObjInfo)
{
	DWORD dwProfileInfoSize;

	dwProfileInfoSize = sizeof(TVMAMEAEProfileInfo);
	if ((ptObjInfo->hProfileInfo=(HANDLE)kmalloc(dwProfileInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate profile info buffer fail !!");
		return -ENOMEM;
	}
	memset(ptObjInfo->hProfileInfo, 0, dwProfileInfoSize);

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_MEAE_InitProfile(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD), "VMA_MEAE Profile Clear");
	ptDevInfo->pdwProfileClr = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_MEAE Bandwidth");
	ptDevInfo->pdwBandwidth = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_MEAE_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_MEAE Request Grant Interval");
	ptDevInfo->pdwRGInterval = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x148+((VMA_MEAE_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD), "VMA_MEAE Request Times");
	ptDevInfo->pdwReqTimes = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x184+((VMA_MEAE_MASTER_NUM-1)<<2)), sizeof(DWORD));

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_MEAE_GetProfileInfo(HANDLE hDevInfo, TVMAMEAEObjInfo *ptObjInfo, DWORD dwWriteIndex)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;
	TVMAMEAEProfileInfo *ptProfileInfo = (TVMAMEAEProfileInfo *)ptObjInfo->hProfileInfo;

	ptProfileInfo->dwBandwidth = ptDevInfo->adwBandwidth[dwWriteIndex];
	ptProfileInfo->dwRGInterval = ptDevInfo->adwRGInterval[dwWriteIndex];
	ptProfileInfo->dwReqTimes = ptDevInfo->adwReqTimes[dwWriteIndex];

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_MEAE_CloseProfile(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	if (ptDevInfo->pdwProfileClr != NULL)
	{
		iounmap(ptDevInfo->pdwProfileClr);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->pdwBandwidth != NULL)
	{
		iounmap(ptDevInfo->pdwBandwidth);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->pdwRGInterval != NULL)
	{
		iounmap(ptDevInfo->pdwRGInterval);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->pdwReqTimes != NULL)
	{
		iounmap(ptDevInfo->pdwReqTimes);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VMA_MEAE_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	return S_OK;
}

/* ============================================================================================== */
SCODE VMA_MEAE_SetupProfile(TVMAMEAEObjInfo *ptObjInfo, DWORD dwArg, DWORD dwCmd)
{
	TVMAMEAEProfileInfo *ptProfileInfo = (TVMAMEAEProfileInfo *)ptObjInfo->hProfileInfo;

	switch (dwCmd)
	{
		case VMA_MEAE_IOC_GET_BANDWIDTH:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->dwBandwidth, sizeof(DWORD));
		break;
		case VMA_MEAE_IOC_GET_RG_INTERVAL:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->dwRGInterval, sizeof(DWORD));
		break;
		case VMA_MEAE_IOC_GET_REQ_TIMES:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->dwReqTimes, sizeof(DWORD));
		break;
		case VMA_MEAE_IOC_CLEAR_PROFILE:
		break;
		default:
			return S_FAIL;
	}

	return S_OK;
}
#endif //__PROFILE__

/* ============================================================================================== */
DWORD VMA_MEAE_GetVersion(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	return ptDevInfo->ptMMRInfo->dwVersion;
}

/* ============================================================================================== */
DWORD VMA_MEAE_StartHead(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	return ptDevInfo->dwWriteIndex;
}

static inline void vma_meae_copy_mmr(volatile TVMAMEAEInfo* ptHWMMRInfo, TVMAMEAEInfo* ptMMRInfo)
{
	ptHWMMRInfo->dwCtrl = ptMMRInfo->dwCtrl;
	ptHWMMRInfo->dwBrate = ptMMRInfo->dwBrate;
	ptHWMMRInfo->dwIrAddr = ptMMRInfo->dwIrAddr;
	ptHWMMRInfo->dwXrAddr = ptMMRInfo->dwXrAddr;
	ptHWMMRInfo->dwSfAddr = ptMMRInfo->dwSfAddr;
	ptHWMMRInfo->dwCbAddr = ptMMRInfo->dwCbAddr;
	ptHWMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;
}

/* ============================================================================================== */
void VMA_MEAE_StartTail(HANDLE hDevInfo, DWORD dwWriteIndex, TVMAMEAEInfo *ptMMRInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->aptMMRInfo[dwWriteIndex] = ptMMRInfo;
	ptDevInfo->dwWriteIndex = (dwWriteIndex+1) & VMA_MEAE_MMR_BUFF_MASK;

	//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
	if (!ptDevInfo->bBusy)
	{
		ptDevInfo->bBusy = TRUE;
		clk_enable(ptDevInfo->pClk);

		vma_meae_copy_mmr(ptDevInfo->ptMMRInfo, ptDevInfo->aptMMRInfo[dwWriteIndex]);
	}
}

/* ============================================================================================== */
void VMA_MEAE_IntrEnable(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl | 0x00000002;

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VMA_MEAE_IntrDisable(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFD;

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VMA_MEAE_IntrClear(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

	PDEBUG("Interrupt cleared !!\n");
}

/* ============================================================================================== */
/*void VMA_MEAE_Reset(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	PDEBUG("Enter Reset function...\n");

	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<19);
	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<19) | 0x00000008;

	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr & (~(VMA_MEAE_RST_EN_VALUE<<VMA_MEAE_RST_EN_NUM));
	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr | (VMA_MEAE_RST_EN_VALUE<<VMA_MEAE_RST_EN_NUM);

	while (ptDevInfo->ptMMRInfo->dwVersion != ptDevInfo->dwVersionNum);

	ptDevInfo->ptMMRInfo->dwCtrl = 0x0;

	PDEBUG("Exit Reset function !!\n");
}*/

/* ============================================================================================== */
void VMA_MEAE_Open(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;

	ptDevInfo->bBusy = FALSE;
	ptDevInfo->dwReadIndex = 0;
	ptDevInfo->dwWriteIndex = 0;
}

/* ============================================================================================== */
DWORD VMA_MEAE_ISR(HANDLE hDevInfo)
{
	TVMAMEAEDevInfo *ptDevInfo = (TVMAMEAEDevInfo *)hDevInfo;
	DWORD dwReadIndex = ptDevInfo->dwReadIndex;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

#ifdef __PROFILE__
	ptDevInfo->adwBandwidth[dwReadIndex] = *ptDevInfo->pdwBandwidth;
	ptDevInfo->adwRGInterval[dwReadIndex] = *ptDevInfo->pdwRGInterval;
	ptDevInfo->adwReqTimes[dwReadIndex] = *ptDevInfo->pdwReqTimes;
	writel((0x1<<VMA_MEAE_MASTER_NUM), ptDevInfo->pdwProfileClr);

#endif //__PROFILE__
	if (ptDevInfo->aptMMRInfo[dwReadIndex] != NULL)
	{
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCycles = ptDevInfo->ptMMRInfo->dwCycles;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwStat = ptDevInfo->ptMMRInfo->dwStat;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwBrate = ptDevInfo->ptMMRInfo->dwBrate;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwIrAddr = ptDevInfo->ptMMRInfo->dwIrAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwXrAddr = ptDevInfo->ptMMRInfo->dwXrAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwSfAddr = ptDevInfo->ptMMRInfo->dwSfAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCbAddr = ptDevInfo->ptMMRInfo->dwCbAddr;
	}

	ptDevInfo->dwReadIndex = (dwReadIndex+1) & VMA_MEAE_MMR_BUFF_MASK;

	if (ptDevInfo->dwReadIndex != ptDevInfo->dwWriteIndex)
	{
		vma_meae_copy_mmr(ptDevInfo->ptMMRInfo, ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex]);
	}
	else
	{
		clk_disable(ptDevInfo->pClk);
		ptDevInfo->bBusy = FALSE;
	}

	return dwReadIndex;
}

/* ============================================================================================== */
