/*
 * $Header: /rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC/vpl_dmac.h 8     15/12/24 2:56p Yiming.liu $
 *
 * vpl_dmac
 * Driver for VPL DMAC
 *
 * Copyright (C) 2015-2020  VATICS INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vpl_dmac.h $
 * 
 * *****************  Version 8  *****************
 * User: Yiming.liu   Date: 15/12/24   Time: 2:56p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 * 
 * *****************  Version 7  *****************
 * User: Yiming.liu   Date: 15/11/27   Time: 2:33p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 * 
 * *****************  Version 6  *****************
 * User: Yiming.liu   Date: 15/10/16   Time: 5:34p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 *
 */

/* ============================================================================================== */
#ifndef __VPL_DMAC_H__
#define __VPL_DMAC_H__

/* ============================================================================================== */
#include <linux/ioctl.h>

#include "typedef.h"
#include "vivo_codec.h"

/* ============================================================================================== */
#define VPL_DMAC_VERSION MAKEFOURCC(1, 0, 0, 4)
#define VPL_DMAC_ID_VERSION "1.0.0.4"

/* ============================================================================================== */
#define VPL_DMAC_MASTER_0_BUS_NUM	1
#define VPL_DMAC_MASTER_1_BUS_NUM	2

#define VPL_DMAC_MASTER_0_MASTER_NUM	0x0F
#define VPL_DMAC_MASTER_1_MASTER_NUM	0x0F

/* ============================================================================================== */
typedef struct vpl_dmac_info
{
	DWORD dwVersion; // MMR 0
	DWORD dwCycles; // MMR 1
	DWORD dwCtrl; // MMR 2
	DWORD dwStat; // MMR 3
	DWORD dwYSrcAddr; // MMR 4
	DWORD dwCbSrcAddr; // MMR 5
	DWORD dwCrSrcAddr; // MMR 6
	DWORD dwYDstAddr; // MMR 7
	DWORD dwCbDstAddr; // MMR 8
	DWORD dwCrDstAddr; // MMR 9
	DWORD dwTransSize; // MMR 10
	DWORD dwSrcStride; // MMR 11
	DWORD dwDstWidth; // MMR 12
	DWORD dwDstHeight; // MMR 13
	DWORD dwDstStride; // MMR 14
	DWORD dwFillingConstant00; // MMR 15
	DWORD dwFillingConstant01; // MMR 16
	DWORD dwMaskAddr; // MMR 17
	DWORD dwMaxBurstLength; // MMR 18
	DWORD dwAlpha; // MMR 19
	DWORD dwMaskStride; // MMR 20
	DWORD dwNextDescriptor; // MMR 21
	DWORD dwDescriptor; // MMR 22
	DWORD dwMaxDistort; // MMR 23
	DWORD dwMcmprObserve; // MMR 24
} TVPLDMACInfo;

/* ============================================================================================== */
#define VPL_DMAC_IOC_MAGIC 239

#define VPL_DMAC_IOC_START						_IOW	(VPL_DMAC_IOC_MAGIC, 0, DWORD)
#define VPL_DMAC_IOC_WAIT_COMPLETE				_IO		(VPL_DMAC_IOC_MAGIC, 1)
#define VPL_DMAC_IOC_SHARE_MMR_INFO_SPACE		_IOW	(VPL_DMAC_IOC_MAGIC, 2, DWORD)
#define VPL_DMAC_IOC_GET_VERSION_NUMBER			_IOR	(VPL_DMAC_IOC_MAGIC, 3, DWORD)
#define VPL_DMAC_IOC_MASTER_0_GET_BANDWIDTH		_IOR	(VPL_DMAC_IOC_MAGIC, 4, DWORD)
#define VPL_DMAC_IOC_MASTER_0_GET_RG_INTERVAL	_IOR	(VPL_DMAC_IOC_MAGIC, 5, DWORD)
#define VPL_DMAC_IOC_MASTER_0_GET_REQ_TIMES		_IOR	(VPL_DMAC_IOC_MAGIC, 6, DWORD)
#define VPL_DMAC_IOC_MASTER_0_CLEAR_PROFILE		_IO		(VPL_DMAC_IOC_MAGIC, 7)
#define VPL_DMAC_IOC_MASTER_1_GET_BANDWIDTH		_IOR	(VPL_DMAC_IOC_MAGIC, 8, DWORD)
#define VPL_DMAC_IOC_MASTER_1_GET_RG_INTERVAL	_IOR	(VPL_DMAC_IOC_MAGIC, 9, DWORD)
#define VPL_DMAC_IOC_MASTER_1_GET_REQ_TIMES		_IOR	(VPL_DMAC_IOC_MAGIC, 10, DWORD)
#define VPL_DMAC_IOC_MASTER_1_CLEAR_PROFILE		_IO		(VPL_DMAC_IOC_MAGIC, 11)

#define VPL_DMAC_IOC_MAX_NUMBER	11

/* ============================================================================================== */
#endif //__VPL_DMAC_H__

/* ============================================================================================== */
