/*
 * $Header: /rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC/vpl_dmac_driver.h 4     15/10/16 5:34p Yiming.liu $
 *
 * vpl_dmac
 * Driver for VPL DMAC
 *
 * Copyright (C) 2015-2020  VATICS INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History: vpl_dmac_driver.h $
 * 
 * *****************  Version 4  *****************
 * User: Yiming.liu   Date: 15/10/16   Time: 5:34p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 *
 */

/* ============================================================================================== */
#ifndef __VPL_DMAC_DRIVER_H__
#define __VPL_DMAC_DRIVER_H__

/* ============================================================================================== */
#include <linux/interrupt.h>
#include <linux/mm.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/ioctl.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/irqdomain.h>
#include <linux/clk.h>
#ifdef __USE_SWAIT__
#include <linux/swait.h>
#endif
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/cache.h>
#include <mach/platform.h>

#include "vpl_dmac.h"

/* ============================================================================================== */
#undef PDEBUG
#ifdef _DEBUG
	#ifdef __KERNEL__
		#define LOGLEVEL KERN_DEBUG
		#define PDEBUG(fmt, args...) printk(LOGLEVEL "VPL_DMAC: " fmt, ## args)
	#else
		#define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
	#endif
#else
	#define PDEBUG(fmt, args...)
#endif

/* ============================================================================================== */
#define VPL_DMAC_MMR_BUFF_NUM 32
#define VPL_DMAC_MMR_BUFF_MASK 31
#define SYSC_RST_EN_MMR (IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x24)

/* ============================================================================================== */
extern struct file_operations vpl_dmac_fops;

/* ============================================================================================== */
typedef struct vpl_dmac_obj_info
{
	HANDLE hProfileInfo;

	TVPLDMACInfo *ptMMRInfo;

	DWORD dwMMRInfoPhyAddr;
	DWORD dwWriteIndex;
} TVPLDMACObjInfo;

/* ============================================================================================== */
typedef struct vpl_dmac_shared_info
{
	HANDLE hDevInfo;

	DWORD dwIrq;

#ifdef __USE_SWAIT__
	struct swait_queue_head atWaitQueueHead[VPL_DMAC_MMR_BUFF_NUM];
#else
	wait_queue_head_t atWaitQueueHead[VPL_DMAC_MMR_BUFF_NUM];
#endif

	volatile BOOL abIntr[VPL_DMAC_MMR_BUFF_NUM];
	volatile BOOL abWriteEn[VPL_DMAC_MMR_BUFF_NUM];

	struct clk *pClk;
	struct mutex ioctl_lock;
} TVPLDMACSharedInfo;

/* ============================================================================================== */
DWORD VPL_DMAC_GetDevInfoSize(void);
SCODE VPL_DMAC_SetMMRInfo(HANDLE, volatile TVPLDMACInfo *, struct clk *, volatile DWORD *);
DWORD VPL_DMAC_GetMMRInfo(HANDLE);
#ifdef __PROFILE__
SCODE VPL_DMAC_InitProfileInfo(TVPLDMACObjInfo *);
SCODE VPL_DMAC_GetProfileInfo(HANDLE, TVPLDMACObjInfo *, DWORD);
SCODE VPL_DMAC_InitProfile(HANDLE);
SCODE VPL_DMAC_CloseProfile(HANDLE);
SCODE VPL_DMAC_SetupProfile(TVPLDMACObjInfo *, DWORD, DWORD);
#endif
DWORD VPL_DMAC_GetVersion(HANDLE);
DWORD VPL_DMAC_StartHead(HANDLE);
void VPL_DMAC_StartTail(HANDLE, DWORD, TVPLDMACInfo *);
void VPL_DMAC_IntrEnable(HANDLE);
void VPL_DMAC_IntrDisable(HANDLE);
void VPL_DMAC_IntrClear(HANDLE);
void VPL_DMAC_Reset(HANDLE);
void VPL_DMAC_Open(HANDLE);
DWORD VPL_DMAC_ISR(HANDLE);
//void VPL_DMAC_ISRTail(HANDLE, DWORD);

/* ============================================================================================== */
#endif //__VPL_DMAC_DRIVER_H__

/* ============================================================================================== */
